/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.CoordMouseMode;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.image.ImageScaler;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.PropUtils;
import java.awt.AlphaComposite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.border.Border;

public class PanMouseMode
extends CoordMouseMode
implements ProjectionListener {
    public static final String OpaquenessProperty = "opaqueness";
    public static final String LeaveShadowProperty = "leaveShadow";
    public static final String UseCursorProperty = "useCursor";
    public final float DEFAULT_OPAQUENESS = 0.5f;
    public static final transient String modeID = "Pan";
    private boolean isPanning = false;
    private BufferedImage bufferedMapImage = null;
    private BufferedImage bufferedRenderingImage = null;
    private int beanBufferWidth = 0;
    private int beanBufferHeight = 0;
    private int oX;
    private int oY;
    private float opaqueness;
    private boolean leaveShadow;
    private boolean useCursor;
    static /* synthetic */ Class class$com$bbn$openmap$event$PanMouseMode;

    public PanMouseMode() {
        super(modeID, true);
        this.setUseCursor(true);
        this.setLeaveShadow(true);
        this.setOpaqueness(0.5f);
    }

    public void setActive(boolean val) {
        if (!val) {
            if (this.bufferedMapImage != null) {
                this.bufferedMapImage.flush();
            }
            if (this.bufferedRenderingImage != null) {
                this.bufferedRenderingImage.flush();
            }
            this.beanBufferWidth = 0;
            this.beanBufferHeight = 0;
            this.bufferedMapImage = null;
            this.bufferedRenderingImage = null;
        }
    }

    public boolean isUseCursor() {
        return this.useCursor;
    }

    public void setUseCursor(boolean useCursor) {
        this.useCursor = useCursor;
        if (useCursor) {
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                ImageIcon pointer = new ImageIcon(this.getClass().getResource("pan.gif"));
                Dimension bestSize = tk.getBestCursorSize(pointer.getIconWidth(), pointer.getIconHeight());
                Image pointerImage = ImageScaler.getOptimalScalingImage(pointer.getImage(), (int)bestSize.getWidth(), (int)bestSize.getHeight());
                Cursor cursor = tk.createCustomCursor(pointerImage, new Point(0, 0), "PP");
                this.setModeCursor(cursor);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setModeCursor(Cursor.getPredefinedCursor(1));
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.opaqueness = PropUtils.floatFromProperties(props, prefix + OpaquenessProperty, this.opaqueness);
        this.leaveShadow = PropUtils.booleanFromProperties(props, prefix + LeaveShadowProperty, this.leaveShadow);
        this.setUseCursor(PropUtils.booleanFromProperties(props, prefix + UseCursorProperty, this.isUseCursor()));
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + OpaquenessProperty, Float.toString(this.getOpaqueness()));
        props.put(prefix + LeaveShadowProperty, Boolean.toString(this.isLeaveShadow()));
        props.put(prefix + UseCursorProperty, Boolean.toString(this.isUseCursor()));
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        PropUtils.setI18NPropertyInfo(this.i18n, props, class$com$bbn$openmap$event$PanMouseMode == null ? (class$com$bbn$openmap$event$PanMouseMode = PanMouseMode.class$("com.bbn.openmap.event.PanMouseMode")) : class$com$bbn$openmap$event$PanMouseMode, OpaquenessProperty, "Transparency", "Transparency level for moving map, between 0 (clear) and 1 (opaque).", null);
        PropUtils.setI18NPropertyInfo(this.i18n, props, class$com$bbn$openmap$event$PanMouseMode == null ? (class$com$bbn$openmap$event$PanMouseMode = PanMouseMode.class$("com.bbn.openmap.event.PanMouseMode")) : class$com$bbn$openmap$event$PanMouseMode, LeaveShadowProperty, "Leave Shadow", "Display current map in background while panning.", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, props, class$com$bbn$openmap$event$PanMouseMode == null ? (class$com$bbn$openmap$event$PanMouseMode = PanMouseMode.class$("com.bbn.openmap.event.PanMouseMode")) : class$com$bbn$openmap$event$PanMouseMode, UseCursorProperty, "Use Cursor", "Use hand cursor for mouse mode.", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return props;
    }

    public void mouseDragged(MouseEvent arg0) {
        int x = arg0.getX();
        int y = arg0.getY();
        MapBean mb = (MapBean)arg0.getSource();
        if (!this.isPanning) {
            int w = mb.getWidth();
            int h = mb.getHeight();
            if (this.bufferedMapImage == null || this.bufferedRenderingImage == null) {
                this.createBuffers(w, h);
            }
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Graphics2D g = ge.createGraphics(this.bufferedMapImage);
            g.setClip(0, 0, w, h);
            Border border = mb.getBorder();
            mb.setBorder(null);
            mb.paintAll(g);
            mb.setBorder(border);
            this.oX = x;
            this.oY = y;
            this.isPanning = true;
        } else if (this.bufferedMapImage != null && this.bufferedRenderingImage != null) {
            Graphics2D gr2d = (Graphics2D)this.bufferedRenderingImage.getGraphics();
            if (this.leaveShadow) {
                gr2d.drawImage((Image)this.bufferedMapImage, 0, 0, null);
            } else {
                gr2d.setPaint(mb.getBckgrnd());
                gr2d.fillRect(0, 0, mb.getWidth(), mb.getHeight());
            }
            gr2d.setComposite(AlphaComposite.getInstance(3, this.opaqueness));
            gr2d.drawImage((Image)this.bufferedMapImage, x - this.oX, y - this.oY, null);
            ((Graphics2D)mb.getGraphics()).drawImage((Image)this.bufferedRenderingImage, 0, 0, null);
        }
        super.mouseDragged(arg0);
    }

    public void mouseReleased(MouseEvent arg0) {
        if (this.isPanning && arg0.getSource() instanceof MapBean) {
            MapBean mb = (MapBean)arg0.getSource();
            Projection proj = mb.getProjection();
            Point center = proj.forward(proj.getCenter());
            center.setLocation(center.getX() - (double)arg0.getX() + (double)this.oX, center.getY() - (double)arg0.getY() + (double)this.oY);
            mb.setCenter(proj.inverse(center));
            this.isPanning = false;
        }
        super.mouseReleased(arg0);
    }

    public boolean isLeaveShadow() {
        return this.leaveShadow;
    }

    public void setLeaveShadow(boolean leaveShadow) {
        this.leaveShadow = leaveShadow;
    }

    public float getOpaqueness() {
        return this.opaqueness;
    }

    public void setOpaqueness(float opaqueness) {
        this.opaqueness = opaqueness;
    }

    public boolean isPanning() {
        return this.isPanning;
    }

    public int getOX() {
        return this.oX;
    }

    public int getOY() {
        return this.oY;
    }

    public void projectionChanged(ProjectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof MapBean) {
            MapBean mb = (MapBean)obj;
            int w = mb.getWidth();
            int h = mb.getHeight();
            this.createBuffers(w, h);
        }
    }

    public synchronized void createBuffers(int w, int h) {
        if (w > 0 && h > 0 && (w != this.beanBufferWidth || h != this.beanBufferHeight)) {
            this.beanBufferWidth = w;
            this.beanBufferHeight = h;
            this.createBuffersImpl(w, h);
        }
    }

    protected void createBuffersImpl(int w, int h) {
        if (this.bufferedMapImage != null) {
            this.bufferedMapImage.flush();
        }
        if (this.bufferedRenderingImage != null) {
            this.bufferedRenderingImage.flush();
        }
        this.bufferedMapImage = new BufferedImage(w, h, 2);
        this.bufferedRenderingImage = new BufferedImage(w, h, 2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

