/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import java.util.EventObject;

public class PanEvent
extends EventObject {
    public static final int PAN_FIRST = 1300;
    public static final int PAN_LAST = 1307;
    public static final int NORTH = 1300;
    public static final int NORTH_EAST = 1301;
    public static final int EAST = 1302;
    public static final int SOUTH_EAST = 1303;
    public static final int SOUTH = 1304;
    public static final int SOUTH_WEST = 1305;
    public static final int WEST = 1306;
    public static final int NORTH_WEST = 1307;
    protected float Az;
    protected float c;

    public PanEvent(Object source, int direction) {
        this(source, PanEvent.dir2Az(direction), Float.NaN);
    }

    public PanEvent(Object source, int direction, float amount) {
        this(source, PanEvent.dir2Az(direction), Float.NaN);
    }

    public PanEvent(Object source, float Az) {
        this(source, Az, Float.NaN);
    }

    public PanEvent(Object source, float Az, float c) {
        super(source);
        this.Az = Az;
        this.c = c;
    }

    static final float dir2Az(int direction) {
        switch (direction) {
            case 1307: {
                return -45.0f;
            }
            case 1300: {
                return 0.0f;
            }
            case 1301: {
                return 45.0f;
            }
            case 1302: {
                return 90.0f;
            }
            case 1303: {
                return 135.0f;
            }
            case 1304: {
                return 180.0f;
            }
            case 1305: {
                return -135.0f;
            }
            case 1306: {
                return -90.0f;
            }
        }
        return 0.0f;
    }

    public float getAzimuth() {
        return this.Az;
    }

    public float getArcDistance() {
        return this.c;
    }

    public int getDirection() {
        return -1;
    }

    public float getAmount() {
        return Float.NaN;
    }

    public String toString() {
        return this.getClass().getName() + "[Az = " + this.Az + ", c=" + this.c + ", source=" + this.source + "]";
    }
}

