/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.event.ListenerSupport;
import com.bbn.openmap.event.MapMouseEvent;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.util.Debug;
import java.awt.event.MouseEvent;
import java.util.Iterator;

public class MapMouseSupport
extends ListenerSupport {
    protected boolean consumeEvents = true;
    protected MapMouseListener priorityListener = null;
    protected boolean clickHappened = false;
    protected transient MapMouseMode proxy = null;
    protected transient int proxyDistributionMask = 0;
    public static final int PROXY_DISTRIB_MOUSE_PRESSED = 1;
    public static final int PROXY_ACK_CONSUMED_MOUSE_PRESSED = 2;
    public static final int PROXY_DISTRIB_MOUSE_RELEASED = 4;
    public static final int PROXY_ACK_CONSUMED_MOUSE_RELEASED = 8;
    public static final int PROXY_DISTRIB_MOUSE_CLICKED = 16;
    public static final int PROXY_ACK_CONSUMED_MOUSE_CLICKED = 32;
    public static final int PROXY_DISTRIB_MOUSE_MOVED = 64;
    public static final int PROXY_ACK_CONSUMED_MOUSE_MOVED = 128;
    public static final int PROXY_DISTRIB_MOUSE_DRAGGED = 256;
    public static final int PROXY_ACK_CONSUMED_MOUSE_DRAGGED = 512;
    public static final int PROXY_DISTRIB_MOUSE_ENTERED = 1024;
    public static final int PROXY_DISTRIB_MOUSE_EXITED = 2048;
    protected boolean DEBUG = false;
    protected boolean DEBUG_DETAIL = false;

    public MapMouseSupport() {
        this(null, true);
    }

    public MapMouseSupport(MapMouseMode mode) {
        this(mode, true);
    }

    public MapMouseSupport(boolean shouldConsumeEvents) {
        this(null, shouldConsumeEvents);
    }

    public MapMouseSupport(MapMouseMode mode, boolean shouldConsumeEvents) {
        super(mode);
        this.consumeEvents = shouldConsumeEvents;
        this.DEBUG = Debug.debugging("mousemode");
        this.DEBUG_DETAIL = Debug.debugging("mousemodedetail");
    }

    public void setParentMode(MapMouseMode mode) {
        this.setSource(mode);
    }

    public MapMouseMode getParentMode() {
        return (MapMouseMode)this.getSource();
    }

    public void setConsumeEvents(boolean shouldConsumeEvents) {
        this.consumeEvents = shouldConsumeEvents;
    }

    public boolean isConsumeEvents() {
        return this.consumeEvents;
    }

    public void addMapMouseListener(MapMouseListener listener) {
        this.addListener(listener);
    }

    public void removeMapMouseListener(MapMouseListener listener) {
        this.removeListener(listener);
    }

    public void removeAllMapMouseListeners() {
        this.removeAll();
    }

    public boolean fireMapMousePressed(MouseEvent evt) {
        boolean ignoreConsumed;
        if (this.DEBUG) {
            System.out.println("MapMouseSupport.fireMapMousePressed()");
        }
        boolean consumed = false;
        if (this.DEBUG) {
            Debug.output("  -- has proxy (" + (this.proxy != null) + ") -- shift used (" + evt.isShiftDown() + ")");
        }
        if (this.proxy == null || evt.isShiftDown() || (this.proxyDistributionMask & 1) > 0) {
            evt = new MapMouseEvent(this.getParentMode(), evt);
            if (this.DEBUG && this.proxy != null && evt.isShiftDown()) {
                Debug.output("MMS.fireMapMousePressed(): proxy enabled, but side stepping to send event to primary listeners");
            }
            Iterator it = this.iterator();
            while (it.hasNext() && !consumed) {
                MapMouseListener target = (MapMouseListener)it.next();
                consumed = target.mousePressed(evt) && this.consumeEvents;
                if (!consumed) continue;
                this.priorityListener = target;
            }
        }
        boolean bl = ignoreConsumed = !consumed || consumed && (this.proxyDistributionMask & 2) == 0;
        if (this.proxy != null && ignoreConsumed && !evt.isShiftDown()) {
            this.proxy.mousePressed(evt);
            consumed = true;
        } else if (this.DEBUG && evt.isShiftDown()) {
            Debug.output("MMS.fireMapMousePressed(): side-stepped proxy");
        }
        return consumed;
    }

    public boolean fireMapMouseReleased(MouseEvent evt) {
        boolean ignoreConsumed;
        if (this.DEBUG) {
            Debug.output("MapMouseSupport: fireMapMouseReleased");
        }
        boolean consumed = false;
        evt = new MapMouseEvent(this.getParentMode(), evt);
        if (this.priorityListener != null) {
            this.priorityListener.mouseReleased(evt);
            if (!this.clickHappened) {
                this.priorityListener = null;
            }
            consumed = true;
        }
        if (this.proxy == null || evt.isShiftDown() || (this.proxyDistributionMask & 4) > 0) {
            Iterator it = this.iterator();
            while (it.hasNext() && !consumed) {
                consumed = ((MapMouseListener)it.next()).mouseReleased(evt) && this.consumeEvents;
            }
        }
        boolean bl = ignoreConsumed = !consumed || consumed && (this.proxyDistributionMask & 8) == 0;
        if (this.proxy != null && ignoreConsumed && !evt.isShiftDown()) {
            this.proxy.mouseReleased(evt);
            consumed = true;
        }
        return consumed;
    }

    public boolean fireMapMouseClicked(MouseEvent evt) {
        boolean ignoreConsumed;
        if (this.DEBUG) {
            Debug.output("MapMouseSupport: fireMapMouseClicked");
        }
        this.clickHappened = true;
        boolean consumed = false;
        evt = new MapMouseEvent(this.getParentMode(), evt);
        if (this.priorityListener != null && evt.getClickCount() > 1) {
            this.priorityListener.mouseClicked(evt);
            consumed = true;
        }
        this.priorityListener = null;
        if (this.proxy == null || evt.isShiftDown() || (this.proxyDistributionMask & 0x10) > 0) {
            Iterator it = this.iterator();
            while (it.hasNext() && !consumed) {
                MapMouseListener target = (MapMouseListener)it.next();
                consumed = target.mouseClicked(evt) && this.consumeEvents;
                if (!consumed) continue;
                this.priorityListener = target;
            }
        }
        boolean bl = ignoreConsumed = !consumed || consumed && (this.proxyDistributionMask & 0x20) == 0;
        if (this.proxy != null && ignoreConsumed && !evt.isShiftDown()) {
            this.proxy.mouseClicked(evt);
            consumed = true;
        }
        return consumed;
    }

    public boolean fireMapMouseEntered(MouseEvent evt) {
        if (this.DEBUG) {
            Debug.output("MapMouseSupport: fireMapMouseEntered");
        }
        boolean consumed = false;
        if (this.proxy == null || evt.isShiftDown() || (this.proxyDistributionMask & 0x400) > 0) {
            evt = new MapMouseEvent(this.getParentMode(), evt);
            Iterator it = this.iterator();
            while (it.hasNext()) {
                ((MapMouseListener)it.next()).mouseEntered(evt);
                consumed = true;
            }
        }
        if (this.proxy != null && !evt.isShiftDown()) {
            this.proxy.mouseEntered(evt);
            consumed = true;
        }
        return consumed;
    }

    public boolean fireMapMouseExited(MouseEvent evt) {
        if (this.DEBUG) {
            Debug.output("MapMouseSupport: fireMapMouseExited");
        }
        boolean consumed = false;
        if (this.proxy == null || evt.isShiftDown() || (this.proxyDistributionMask & 0x800) > 0) {
            evt = new MapMouseEvent(this.getParentMode(), evt);
            Iterator it = this.iterator();
            while (it.hasNext()) {
                ((MapMouseListener)it.next()).mouseExited(evt);
                consumed = true;
            }
        }
        if (this.proxy != null && !evt.isShiftDown()) {
            this.proxy.mouseExited(evt);
            consumed = true;
        }
        return consumed;
    }

    public boolean fireMapMouseDragged(MouseEvent evt) {
        boolean ignoreConsumed;
        if (this.DEBUG_DETAIL) {
            Debug.output("MapMouseSupport: fireMapMouseDragged");
        }
        this.clickHappened = false;
        boolean consumed = false;
        if (this.proxy == null || evt.isShiftDown() || (this.proxyDistributionMask & 0x100) > 0) {
            evt = new MapMouseEvent(this.getParentMode(), evt);
            Iterator it = this.iterator();
            while (it.hasNext() && !consumed) {
                consumed = ((MapMouseListener)it.next()).mouseDragged(evt) && this.consumeEvents;
            }
        }
        boolean bl = ignoreConsumed = !consumed || consumed && (this.proxyDistributionMask & 0x200) == 0;
        if (this.proxy != null && ignoreConsumed && !evt.isShiftDown()) {
            this.proxy.mouseDragged(evt);
            consumed = true;
        }
        return consumed;
    }

    public boolean fireMapMouseMoved(MouseEvent evt) {
        boolean ignoreConsumed;
        if (this.DEBUG_DETAIL) {
            Debug.output("MapMouseSupport: fireMapMouseMoved");
        }
        boolean consumed = false;
        if (this.proxy == null || evt.isShiftDown() || (this.proxyDistributionMask & 0x40) > 0) {
            evt = new MapMouseEvent(this.getParentMode(), evt);
            Iterator it = this.iterator();
            while (it.hasNext()) {
                MapMouseListener target = (MapMouseListener)it.next();
                if (consumed) {
                    target.mouseMoved();
                    continue;
                }
                consumed = target.mouseMoved(evt);
            }
        }
        boolean bl = ignoreConsumed = !(consumed &= this.consumeEvents) || consumed && (this.proxyDistributionMask & 0x80) == 0;
        if (this.proxy != null && ignoreConsumed && !evt.isShiftDown()) {
            this.proxy.mouseMoved(evt);
            consumed = true;
        }
        return consumed;
    }

    protected synchronized boolean setProxyFor(MapMouseMode mmm, int pdm) {
        this.proxyDistributionMask = pdm;
        if (this.proxy == null || this.proxy == mmm) {
            this.proxy = mmm;
            return true;
        }
        return false;
    }

    public synchronized boolean isProxyFor(MapMouseMode mmm) {
        return this.proxy == mmm;
    }

    protected synchronized void releaseProxy() {
        this.proxy = null;
        this.proxyDistributionMask = 0;
    }

    protected void setProxyDistributionMask(int mask) {
        this.proxyDistributionMask = mask;
    }

    protected int getProxyDistributionMask() {
        return this.proxyDistributionMask;
    }
}

