/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.InformationDelegator;
import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.AbstractMouseMode;
import com.bbn.openmap.event.InfoDisplayEvent;
import com.bbn.openmap.util.Debug;
import java.awt.event.MouseEvent;

public abstract class CoordMouseMode
extends AbstractMouseMode {
    public InformationDelegator infoDelegator = null;

    public CoordMouseMode() {
    }

    public CoordMouseMode(String modeID, boolean shouldConsumeEvents) {
        super(modeID, shouldConsumeEvents);
    }

    public void setInfoDelegator(InformationDelegator id) {
        this.infoDelegator = id;
    }

    public InformationDelegator getInfoDelegator() {
        return this.infoDelegator;
    }

    public void mouseMoved(MouseEvent e) {
        this.fireMouseLocation(e);
        super.mouseMoved(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.fireMouseLocation(e);
        super.mouseDragged(e);
    }

    public void setActive(boolean active) {
        if (Debug.debugging("mousemode")) {
            Debug.output("CoordMouseMode(" + this.getPrettyName() + "): made active (" + active + ")");
        }
        if (!active && this.infoDelegator != null) {
            this.infoDelegator.requestInfoLine(new InfoDisplayEvent(this, "", 1));
        }
    }

    public void fireMouseLocation(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        LatLonPoint llp = null;
        Debug.message("mousemodedetail", "CoordMouseMode: firing mouse location");
        if (this.infoDelegator != null) {
            if (e.getSource() instanceof MapBean) {
                llp = ((MapBean)e.getSource()).getProjection().inverse(x, y);
            }
            String infoLine = this.createCoordinateInformationLine(x, y, llp);
            InfoDisplayEvent info = new InfoDisplayEvent(this, infoLine, 1);
            this.infoDelegator.requestInfoLine(info);
        }
    }

    protected String createCoordinateInformationLine(int x, int y, LatLonPoint llp) {
        if (llp != null) {
            return "Lat, Lon (" + this.df.format(llp.getLatitude()) + ", " + this.df.format(llp.getLongitude()) + ") - x, y (" + x + "," + y + ")";
        }
        return "x, y (" + x + "," + y + ")";
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof InformationDelegator) {
            Debug.message("mousemode", "NavMouseMode: found InformationDelegator");
            this.setInfoDelegator((InformationDelegator)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof InformationDelegator && this.getInfoDelegator() == (InformationDelegator)someObj) {
            this.setInfoDelegator(null);
        }
    }
}

