/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.iso8211;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.dataAccess.iso8211.DDFConstants;
import com.bbn.openmap.dataAccess.iso8211.DDFDataType;
import com.bbn.openmap.layer.vpf.MutableInt;
import com.bbn.openmap.util.Debug;

public class DDFSubfieldDefinition
implements DDFConstants {
    protected String pszName = null;
    protected String pszFormatString;
    protected DDFDataType eType;
    protected int eBinaryFormat = 0;
    protected boolean bIsVariable = true;
    protected char chFormatDelimeter = (char)31;
    protected int nFormatWidth = 0;

    public int getWidth() {
        return this.nFormatWidth;
    }

    public String getName() {
        return this.pszName;
    }

    public String getFormat() {
        return this.pszFormatString;
    }

    public DDFDataType getType() {
        return this.eType;
    }

    public DDFSubfieldDefinition() {
        this.eType = DDFDataType.DDFString;
        this.pszFormatString = new String("");
    }

    public void setName(String pszNewName) {
        this.pszName = pszNewName.trim();
    }

    public boolean setFormat(String pszFormat) {
        this.pszFormatString = pszFormat;
        if (Debug.debugging("iso8211")) {
            Debug.output("DDFSubfieldDefinition.setFormat(" + pszFormat + ")");
        }
        if (this.pszFormatString.length() > 1 && this.pszFormatString.charAt(1) == '(') {
            int i;
            for (i = 3; i < pszFormat.length() && Character.isDigit(pszFormat.charAt(i)); ++i) {
            }
            this.nFormatWidth = Integer.parseInt(pszFormat.substring(2, i));
            this.bIsVariable = this.nFormatWidth == 0;
        } else {
            this.bIsVariable = true;
        }
        switch (this.pszFormatString.charAt(0)) {
            case 'A': 
            case 'C': {
                this.eType = DDFDataType.DDFString;
                break;
            }
            case 'R': {
                this.eType = DDFDataType.DDFFloat;
                break;
            }
            case 'I': 
            case 'S': {
                this.eType = DDFDataType.DDFInt;
                break;
            }
            case 'B': 
            case 'b': {
                int numEndIndex;
                this.bIsVariable = false;
                if (this.pszFormatString.charAt(1) == '(') {
                    for (numEndIndex = 2; numEndIndex < this.pszFormatString.length() && Character.isDigit(this.pszFormatString.charAt(numEndIndex)); ++numEndIndex) {
                    }
                    String numberString = this.pszFormatString.substring(2, numEndIndex);
                    this.nFormatWidth = Integer.valueOf(numberString);
                    if (this.nFormatWidth % 8 != 0) {
                        Debug.error("DDFSubfieldDefinition.setFormat() problem with " + this.pszFormatString.charAt(0) + " not being modded with 8 evenly");
                        return false;
                    }
                    this.nFormatWidth = Integer.parseInt(numberString) / 8;
                    this.eBinaryFormat = 2;
                    if (this.nFormatWidth < 5) {
                        this.eType = DDFDataType.DDFInt;
                        break;
                    }
                    this.eType = DDFDataType.DDFBinaryString;
                    break;
                }
                this.eBinaryFormat = this.pszFormatString.charAt(1) - 48;
                for (numEndIndex = 2; numEndIndex < this.pszFormatString.length() && Character.isDigit(this.pszFormatString.charAt(numEndIndex)); ++numEndIndex) {
                }
                this.nFormatWidth = Integer.valueOf(this.pszFormatString.substring(2, numEndIndex));
                if (this.eBinaryFormat == 2 || this.eBinaryFormat == 1) {
                    this.eType = DDFDataType.DDFInt;
                    break;
                }
                this.eType = DDFDataType.DDFFloat;
                break;
            }
            case 'X': {
                Debug.error("DDFSubfieldDefinition: Format type of " + this.pszFormatString.charAt(0) + " not supported.");
                return false;
            }
            default: {
                Debug.error("DDFSubfieldDefinition: Format type of " + this.pszFormatString.charAt(0) + " not recognised.");
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("    DDFSubfieldDefn:\n");
        buf.append("        Label = " + this.pszName + "\n");
        buf.append("        FormatString = " + this.pszFormatString + "\n");
        return buf.toString();
    }

    public int getDataLength(byte[] pachSourceData, int nMaxBytes, MutableInt pnConsumedBytes) {
        if (!this.bIsVariable) {
            if (this.nFormatWidth > nMaxBytes) {
                Debug.error("DDFSubfieldDefinition: Only " + nMaxBytes + " bytes available for subfield " + this.pszName + " with format string " + this.pszFormatString + " ... returning shortened data.");
                if (pnConsumedBytes != null) {
                    pnConsumedBytes.value = nMaxBytes;
                }
                return nMaxBytes;
            }
            if (pnConsumedBytes != null) {
                pnConsumedBytes.value = this.nFormatWidth;
            }
            return this.nFormatWidth;
        }
        int nLength = 0;
        boolean bCheckFieldTerminator = true;
        if (pachSourceData[0] < 32 || pachSourceData[0] >= 127) {
            bCheckFieldTerminator = false;
        }
        while (!(nLength >= nMaxBytes || pachSourceData[nLength] == this.chFormatDelimeter || bCheckFieldTerminator && pachSourceData[nLength] == 30)) {
            ++nLength;
        }
        if (pnConsumedBytes != null) {
            pnConsumedBytes.value = nMaxBytes == 0 ? nLength : nLength + 1;
        }
        return nLength;
    }

    String extractStringData(byte[] pachSourceData, int nMaxBytes, MutableInt pnConsumedBytes) {
        int oldConsumed = 0;
        if (pnConsumedBytes != null) {
            oldConsumed = pnConsumedBytes.value;
        }
        int nLength = this.getDataLength(pachSourceData, nMaxBytes, pnConsumedBytes);
        String ns = new String(pachSourceData, 0, nLength);
        if (Debug.debugging("iso8211detail")) {
            Debug.output("        extracting string data from " + nLength + " bytes of " + pachSourceData.length + ": " + ns + ": consumed " + pnConsumedBytes.value + " vs. " + oldConsumed + ", max = " + nMaxBytes);
        }
        return ns;
    }

    public double extractFloatData(byte[] pachSourceData, int nMaxBytes, MutableInt pnConsumedBytes) {
        switch (this.pszFormatString.charAt(0)) {
            case 'A': 
            case 'C': 
            case 'I': 
            case 'R': 
            case 'S': {
                String dataString = this.extractStringData(pachSourceData, nMaxBytes, pnConsumedBytes);
                if (dataString.equals("")) {
                    return 0.0;
                }
                try {
                    return Double.parseDouble(dataString);
                }
                catch (NumberFormatException nfe) {
                    if (Debug.debugging("iso8211")) {
                        Debug.output("DDFSubfieldDefinition.extractFloatData: number format problem: " + dataString);
                    }
                    return 0.0;
                }
            }
            case 'B': 
            case 'b': {
                byte[] abyData = new byte[8];
                if (pnConsumedBytes != null) {
                    pnConsumedBytes.value = this.nFormatWidth;
                }
                if (this.nFormatWidth > nMaxBytes) {
                    Debug.error("DDFSubfieldDefinition: format width is greater than max bytes for float");
                    return 0.0;
                }
                System.arraycopy(pachSourceData, 0, abyData, 0, this.nFormatWidth);
                switch (this.eBinaryFormat) {
                    case 1: 
                    case 2: 
                    case 4: {
                        return this.pszFormatString.charAt(0) == 'B' ? (double)MoreMath.BuildIntegerBE(abyData) : (double)MoreMath.BuildIntegerLE(abyData);
                    }
                    case 0: 
                    case 3: 
                    case 5: {
                        return 0.0;
                    }
                }
                break;
            }
        }
        return 0.0;
    }

    public int extractIntData(byte[] pachSourceData, int nMaxBytes, MutableInt pnConsumedBytes) {
        switch (this.pszFormatString.charAt(0)) {
            case 'A': 
            case 'C': 
            case 'I': 
            case 'R': 
            case 'S': {
                String dataString = this.extractStringData(pachSourceData, nMaxBytes, pnConsumedBytes);
                if (dataString.equals("")) {
                    return 0;
                }
                try {
                    return Double.valueOf(dataString).intValue();
                }
                catch (NumberFormatException nfe) {
                    if (Debug.debugging("iso8211")) {
                        Debug.output("DDFSubfieldDefinition.extractIntData: number format problem: " + dataString);
                    }
                    return 0;
                }
            }
            case 'B': 
            case 'b': {
                byte[] abyData = new byte[4];
                if (this.nFormatWidth > nMaxBytes) {
                    Debug.error("DDFSubfieldDefinition: format width is greater than max bytes for int");
                    return 0;
                }
                if (pnConsumedBytes != null) {
                    pnConsumedBytes.value = this.nFormatWidth;
                }
                System.arraycopy(pachSourceData, 0, abyData, 0, this.nFormatWidth);
                switch (this.eBinaryFormat) {
                    case 1: 
                    case 2: 
                    case 4: {
                        return this.pszFormatString.charAt(0) == 'B' ? MoreMath.BuildIntegerBE(abyData) : MoreMath.BuildIntegerLE(abyData);
                    }
                    case 0: 
                    case 3: 
                    case 5: {
                        return 0;
                    }
                }
                break;
            }
            default: {
                return 0;
            }
        }
        return 0;
    }

    public String dumpData(byte[] pachData, int nMaxBytes) {
        StringBuffer sb = new StringBuffer();
        if (this.eType == DDFDataType.DDFFloat) {
            sb.append("      Subfield " + this.pszName + "=" + this.extractFloatData(pachData, nMaxBytes, null) + "\n");
        } else if (this.eType == DDFDataType.DDFInt) {
            sb.append("      Subfield " + this.pszName + "=" + this.extractIntData(pachData, nMaxBytes, null) + "\n");
        } else if (this.eType == DDFDataType.DDFBinaryString) {
            sb.append("      Subfield " + this.pszName + "=" + this.extractStringData(pachData, nMaxBytes, null) + "\n");
        } else {
            sb.append("      Subfield " + this.pszName + "=" + this.extractStringData(pachData, nMaxBytes, null) + "\n");
        }
        return sb.toString();
    }

    public static interface DDFBinaryFormat {
        public static final int NotBinary = 0;
        public static final int UInt = 1;
        public static final int SInt = 2;
        public static final int FPReal = 3;
        public static final int FloatReal = 4;
        public static final int FloatComplex = 5;
    }
}

