/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.asrp;

import com.bbn.openmap.dataAccess.asrp.GeneralASRPFile;
import com.bbn.openmap.dataAccess.iso8211.DDFModule;
import com.bbn.openmap.dataAccess.iso8211.DDFRecord;
import com.bbn.openmap.util.Debug;
import java.awt.Dimension;
import java.io.IOException;

public class GeneralInformationFile
extends GeneralASRPFile {
    public static final String RECORD_ID = "001";
    public static final String DATA_SET_ID = "DSI";
    public static final String GENERAL_INFORMATION = "GEN";
    public static final String DATA_SET_PARAMETERS = "SPR";
    public static final String BAND_ID = "BDF";
    public static final String TILE_INDEX_MAP = "TIM";
    public static final String DATASET_DESCRIPTION = "DRF";
    protected Dimension subframeDimensions;

    public GeneralInformationFile(String fileName) throws IOException {
        DDFModule mod = this.load(fileName);
        if (mod != null) {
            DDFRecord record;
            while ((record = mod.readRecord()) != null) {
                this.loadField(record, DATA_SET_ID, 0);
                this.loadField(record, GENERAL_INFORMATION, 0);
                this.loadField(record, DATA_SET_PARAMETERS, 0);
                this.loadField(record, BAND_ID, 0);
                this.loadField(record, TILE_INDEX_MAP, 0);
                this.loadField(record, DATASET_DESCRIPTION, 0);
            }
        }
    }

    public static void main(String[] argv) {
        Debug.init();
        if (argv.length < 1) {
            Debug.output("Usage: GeneralInformationFile filename");
        }
        try {
            GeneralInformationFile gen = new GeneralInformationFile(argv[0]);
            gen.dumpFields();
        }
        catch (IOException ioe) {
            Debug.error(ioe.getMessage());
        }
        System.exit(0);
    }
}

