/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.SoloMapComponent;
import com.bbn.openmap.SoloMapComponentPolicy;
import com.bbn.openmap.SoloMapComponentRejectPolicy;
import com.bbn.openmap.util.Debug;
import java.beans.beancontext.BeanContextServicesSupport;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class MapHandler
extends BeanContextServicesSupport {
    protected SoloMapComponentPolicy policy;
    protected boolean DEBUG = Debug.debugging("maphandler");
    protected boolean addInProgress = false;
    protected Vector addLaterVector = null;

    public void setPolicy(SoloMapComponentPolicy smcp) {
        this.policy = smcp;
    }

    public SoloMapComponentPolicy getPolicy() {
        if (this.policy == null) {
            this.policy = new SoloMapComponentRejectPolicy();
        }
        return this.policy;
    }

    protected synchronized void addLater(Object obj) {
        if (this.addLaterVector == null) {
            this.addLaterVector = new Vector();
        }
        if (this.DEBUG) {
            Debug.output("=== Adding " + obj.getClass().getName() + " to list for later addition");
        }
        this.addLaterVector.add(obj);
    }

    protected synchronized void purgeLaterList() {
        Vector tmpList = this.addLaterVector;
        this.addLaterVector = null;
        if (tmpList != null) {
            Iterator it = tmpList.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (this.DEBUG) {
                    Debug.output("+++ Adding " + obj.getClass().getName() + " to MapHandler from later list.");
                }
                this.add(obj);
            }
            tmpList.clear();
        }
    }

    protected synchronized void setAddInProgress(boolean value) {
        this.addInProgress = value;
    }

    protected synchronized boolean isAddInProgress() {
        return this.addInProgress;
    }

    public synchronized boolean add(Object obj) {
        block6: {
            try {
                boolean passedSoloMapComponentTest = true;
                if (obj instanceof SoloMapComponent) {
                    passedSoloMapComponentTest = this.getPolicy().canAdd(this, obj);
                }
                if (obj == null || !passedSoloMapComponentTest) break block6;
                if (this.isAddInProgress()) {
                    if (this.DEBUG) {
                        Debug.output("MapHandler: Attempting to add while add in progress, adding [" + obj.getClass().getName() + "]object to list");
                    }
                    this.addLater(obj);
                    break block6;
                }
                this.setAddInProgress(true);
                boolean ret = super.add(obj);
                this.setAddInProgress(false);
                this.purgeLaterList();
                return ret;
            }
            catch (ConcurrentModificationException cme) {
                Debug.error("MapHandler caught ConcurrentModificationException when adding [" + obj.getClass().getName() + "]. The addition of this component to the MapHandler is causing some other component to attempt to be added as well, and the coping mechanism in the MapHandler is not handling it well.");
                if (Debug.debugging("maphandler")) {
                    cme.printStackTrace();
                }
                this.addLater(obj);
                this.setAddInProgress(false);
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public Object get(String classname) {
        Class<?> someClass = null;
        try {
            someClass = Class.forName(classname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.get(someClass);
    }

    public Object get(Class someClass) {
        Collection collection = this.getAll(someClass);
        Iterator it = collection.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public Collection getAll(String classname) {
        Class<?> someClass = null;
        try {
            someClass = Class.forName(classname);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.getAll(someClass);
    }

    public Collection getAll(Class someClass) {
        LinkedList<Object> collection = new LinkedList<Object>();
        if (someClass != null) {
            Iterator<Object> it = this.iterator();
            while (it.hasNext()) {
                Object someObj = it.next();
                if (!someClass.isInstance(someObj)) continue;
                collection.add(someObj);
            }
        }
        return collection;
    }
}

