/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.LayerEvent;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;

public class BufferedMapBean
extends MapBean {
    protected boolean bufferDirty = true;
    protected Image drawingBuffer = null;

    public void setLayers(LayerEvent evt) {
        this.bufferDirty = true;
        super.setLayers(evt);
    }

    public void componentResized(ComponentEvent e) {
        boolean bad = false;
        try {
            this.drawingBuffer = this.createImage(this.getWidth(), this.getHeight());
        }
        catch (NegativeArraySizeException nae) {
            bad = true;
        }
        catch (IllegalArgumentException iae) {
            bad = true;
        }
        if (bad) {
            Debug.message("mapbean", "BufferedMapBean: component resizing is not valid for buffer.");
            this.drawingBuffer = this.createImage(1, 1);
        }
        super.componentResized(e);
    }

    public void paintChildren(Graphics g) {
        this.paintChildren(g, null);
    }

    public void paintChildren(Graphics g, Rectangle clip) {
        if (this.bufferDirty) {
            this.bufferDirty = false;
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.drawingBuffer == null) {
                this.drawingBuffer = this.createImage(w, h);
            }
            Graphics gr = this.getMapBeanRepaintPolicy().modifyGraphicsForPainting(this.drawingBuffer.getGraphics());
            if (clip == null) {
                gr.setClip(0, 0, w, h);
            } else {
                gr.setClip(clip);
            }
            if (Debug.debugging("mapbean")) {
                Debug.output("BufferedMapBean.rendering layers to buffer.");
            }
            this.paintChildrenWithBorder(gr, false);
            gr.dispose();
        } else if (Debug.debugging("mapbean")) {
            Debug.output("BufferedMapBean.rendering buffer.");
        }
        if (clip != null) {
            g.setClip(clip);
        }
        g.drawImage(this.drawingBuffer, 0, 0, null);
        if (this.painters != null) {
            this.painters.paint(g);
        }
        this.paintBorder(g);
    }

    public boolean isBuffered() {
        return true;
    }

    public void setBufferDirty(boolean value) {
        this.bufferDirty = value;
    }

    public boolean isBufferDirty() {
        return this.bufferDirty;
    }
}

