/*
 * Decompiled with CFR 0.152.
 */
package jams.gui.input;

import jams.JAMSFileFilter;
import jams.gui.input.ListInput;
import jams.gui.tools.GUIHelper;
import java.io.File;
import javax.swing.JFileChooser;

public class FileListInput
extends ListInput {
    private JFileChooser jfc = GUIHelper.getJFileChooser();

    public FileListInput() {
        this.jfc.setFileFilter(JAMSFileFilter.getJarFilter());
        this.jfc.setFileSelectionMode(2);
    }

    @Override
    protected void addItem() {
        int result;
        File file;
        String stringValue = null;
        Object o = this.getListbox().getSelectedValue();
        if (o != null && (file = new File((String)o)).exists()) {
            this.jfc.setSelectedFile(file);
        }
        if ((result = this.jfc.showOpenDialog(this)) == 0) {
            stringValue = this.jfc.getSelectedFile().getAbsolutePath();
        }
        if (stringValue != null && !this.listData.getValue().contains(stringValue)) {
            this.listData.addElement(stringValue);
            this.scrollPane.revalidate();
            this.scrollPane.repaint();
        }
    }

    @Override
    protected void editItem() {
        String newValue = null;
        int selection = this.getListbox().getSelectedIndex();
        if (selection >= 0) {
            int result;
            Object value = this.listData.getElementAt(selection);
            File file = new File(value.toString());
            if (file.exists()) {
                this.jfc.setSelectedFile(file);
            }
            if ((result = this.jfc.showOpenDialog(this)) == 0) {
                newValue = this.jfc.getSelectedFile().getAbsolutePath();
            }
            if (newValue != null && !this.listData.getValue().contains(newValue)) {
                this.listData.setElementAt(selection, newValue);
                this.scrollPane.revalidate();
                this.scrollPane.repaint();
            }
        }
    }
}

