/*
 * Decompiled with CFR 0.152.
 */
package jams.gui.input;

import jams.gui.input.InputComponent;
import jams.gui.input.ValueChangeListener;
import jams.gui.tools.GUIHelper;
import jams.tools.StringTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FileInput
extends JPanel
implements InputComponent {
    private static final int BUTTON_SIZE = 20;
    private JTextField textField;
    private JButton addButton;
    private JFileChooser jfc;
    private ValueChangeListener l;
    private boolean dirsOnly;
    private Color oldColor;

    public FileInput(boolean dirsOnly) {
        this();
        this.dirsOnly = dirsOnly;
        if (dirsOnly) {
            this.jfc.setFileSelectionMode(1);
        }
    }

    public FileInput() {
        BorderLayout layout = new BorderLayout();
        layout.setHgap(5);
        this.setLayout(layout);
        this.textField = new JTextField();
        this.textField.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.textField, "Center");
        this.jfc = GUIHelper.getJFileChooser();
        this.addButton = new JButton("...");
        this.addButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.addButton.setPreferredSize(new Dimension(20, 20));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int result = FileInput.this.jfc.showOpenDialog(FileInput.this);
                if (result == 0) {
                    String stringValue = FileInput.this.jfc.getSelectedFile().getAbsolutePath();
                    FileInput.this.textField.setText(stringValue);
                }
            }
        });
        this.add((Component)this.addButton, "East");
    }

    public void setFile(String fileName) {
        if (fileName == null) {
            fileName = "";
        }
        this.textField.setText(fileName);
        File file = new File(fileName);
        if (file.exists()) {
            if (file.isDirectory()) {
                this.jfc.setCurrentDirectory(file);
            } else {
                this.jfc.setCurrentDirectory(file.getParentFile());
            }
        }
    }

    public String getFileName() {
        return this.textField.getText();
    }

    @Override
    public String getValue() {
        return this.getFileName();
    }

    @Override
    public void setValue(String value) {
        this.setFile(value);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setRange(double lower, double upper) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
    }

    @Override
    public boolean verify() {
        if (this.dirsOnly && StringTools.isEmptyString(this.getFileName())) {
            return true;
        }
        File file = new File(this.getFileName());
        return file.exists();
    }

    @Override
    public int getErrorCode() {
        return 0;
    }

    @Override
    public void setLength(int length) {
        this.textField.setColumns(length);
    }

    @Override
    public void addValueChangeListener(ValueChangeListener l) {
        this.l = l;
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FileInput.this.l.valueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FileInput.this.l.valueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FileInput.this.l.valueChanged();
            }
        });
    }

    @Override
    public void setMarked(boolean marked) {
        if (marked) {
            this.oldColor = this.textField.getBackground();
            this.textField.setBackground(new Color(255, 0, 0));
        } else {
            this.textField.setBackground(this.oldColor);
        }
    }

    @Override
    public void setHelpText(String text) {
        text = "<html>" + text + "</html>";
        this.textField.setToolTipText(text);
    }
}

