/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.CellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.DefaultFileFilter;
import ncsa.hdf.view.HDFView;
import ncsa.hdf.view.MetaDataView;
import ncsa.hdf.view.NewAttributeDialog;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DefaultMetaDataView
extends JDialog
implements ActionListener,
MetaDataView {
    private static final long serialVersionUID = 7891048909810508761L;
    private ViewManager viewer;
    private HObject hObject;
    private JTabbedPane tabbedPane = null;
    private JTextArea attrContentArea;
    private JTable attrTable;
    private DefaultTableModel attrTableModel;
    private JLabel attrNumberLabel;
    private int numAttributes;
    private boolean isH5;
    private boolean isH4;
    private byte[] userBlock;
    private JTextArea userBlockArea;
    private JButton jamButton;
    private JTextField linkField = null;
    private FileFormat fileFormat;
    private String LinkTObjName;
    private int[] libver;

    public DefaultMetaDataView(ViewManager theView) {
        super((Frame)((JFrame)((Object)theView)), false);
        boolean isRoot;
        this.setDefaultCloseOperation(2);
        this.setName("DefaultMetaDataView");
        this.viewer = theView;
        this.hObject = this.viewer.getTreeView().getCurrentObject();
        this.fileFormat = this.hObject.getFileFormat();
        this.numAttributes = 0;
        this.userBlock = null;
        this.userBlockArea = null;
        this.libver = new int[2];
        if (this.hObject == null) {
            this.dispose();
        } else if (this.hObject.getPath() == null) {
            this.setTitle("Properties - " + this.hObject.getName());
        } else {
            this.setTitle("Properties - " + this.hObject.getPath() + this.hObject.getName());
        }
        this.isH5 = this.hObject.getFileFormat().isThisType(FileFormat.getFileFormat((String)"HDF5"));
        this.isH4 = this.hObject.getFileFormat().isThisType(FileFormat.getFileFormat((String)"HDF4"));
        this.tabbedPane = new JTabbedPane();
        try {
            this.hObject.getMetadata();
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.tabbedPane.addTab("General", this.createGeneralPropertyPanel());
        this.tabbedPane.addTab("Attributes", this.createAttributePanel());
        boolean bl = isRoot = this.hObject instanceof Group && ((Group)this.hObject).isRoot();
        if (this.isH5 && isRoot) {
            this.tabbedPane.addTab("User Block", this.createUserBlockPanel());
        }
        this.tabbedPane.setSelectedIndex(0);
        if (this.isH5 && this.hObject.getLinkTargetObjName() != null) {
            this.LinkTObjName = this.hObject.getLinkTargetObjName();
        }
        JPanel bPanel = new JPanel();
        bPanel.setName("MetaDataClose");
        JButton b = new JButton("  Close  ");
        b.setName("Close");
        b.setMnemonic(67);
        b.setActionCommand("Close");
        b.addActionListener(this);
        bPanel.add(b);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setName("MetaDataContent");
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPane.setPreferredSize(new Dimension(620, 400));
        contentPane.add("Center", this.tabbedPane);
        contentPane.add("South", bPanel);
        Point l = this.getParent().getLocation();
        l.x += 250;
        l.y += 80;
        this.setLocation(l);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String cmd = e.getActionCommand();
        if (cmd.equals("Close")) {
            if (this.isH5 && this.linkField != null) {
                this.checkLinkTargetChanged();
            }
            this.dispose();
        } else if (cmd.equals("Add attribute")) {
            this.addAttribute(this.hObject);
        } else if (cmd.equals("Delete attribute")) {
            this.deleteAttribute(this.hObject);
        } else if (cmd.equals("Jam user block")) {
            this.writeUserBlock();
        } else if (cmd.equals("Display user block as")) {
            int type = 0;
            String typeName = (String)((JComboBox)source).getSelectedItem();
            this.jamButton.setEnabled(false);
            this.userBlockArea.setEditable(false);
            if (typeName.equalsIgnoreCase("Text")) {
                type = 0;
                this.jamButton.setEnabled(true);
                this.userBlockArea.setEditable(true);
            } else if (typeName.equalsIgnoreCase("Binary")) {
                type = 2;
            } else if (typeName.equalsIgnoreCase("Octal")) {
                type = 8;
            } else if (typeName.equalsIgnoreCase("Hexadecimal")) {
                type = 16;
            } else if (typeName.equalsIgnoreCase("Decimal")) {
                type = 10;
            }
            this.showUserBlockAs(type);
        }
    }

    private final void checkLinkTargetChanged() {
        Group pgroup = null;
        try {
            pgroup = (Group)this.hObject.getFileFormat().get(this.hObject.getPath());
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (pgroup == null) {
            JOptionPane.showMessageDialog(this, "Parent group is null.", this.getTitle(), 0);
            return;
        }
        String target_name = this.linkField.getText();
        if (target_name != null) {
            target_name = target_name.trim();
        }
        int linkType = 1;
        if (this.LinkTObjName.contains("://")) {
            linkType = 64;
        } else if (target_name.equals("/")) {
            return;
        }
        if (target_name.equals(this.hObject.getLinkTargetObjName())) {
            return;
        }
        if (target_name == null || target_name.length() < 1) {
            return;
        }
        try {
            this.fileFormat.createLink(pgroup, this.hObject.getName(), target_name, linkType);
            this.hObject.setLinkTargetObjName(target_name);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
        }
    }

    @Override
    public HObject getDataObject() {
        return this.hObject;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public Attribute addAttribute(HObject obj) {
        if (obj == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj.getFileFormat().getRootNode();
        NewAttributeDialog dialog = new NewAttributeDialog((Dialog)this, obj, node.breadthFirstEnumeration());
        dialog.setVisible(true);
        Attribute attr = dialog.getAttribute();
        if (attr == null) {
            return null;
        }
        Object[] rowData = new String[4];
        rowData[0] = attr.getName();
        rowData[2] = attr.getType().getDatatypeDescription();
        rowData[1] = attr.toString(", ");
        long[] dims = attr.getDataDims();
        rowData[3] = String.valueOf(dims[0]);
        for (int j = 1; j < dims.length; ++j) {
            rowData[3] = (String)rowData[3] + " x " + dims[j];
        }
        this.attrTableModel.addRow(rowData);
        this.attrTableModel.fireTableRowsInserted(this.attrTableModel.getRowCount() - 1, this.attrTableModel.getRowCount() - 1);
        ++this.numAttributes;
        this.attrContentArea.setText("");
        this.attrNumberLabel.setText("Number of attributes = " + this.numAttributes);
        return attr;
    }

    @Override
    public Attribute deleteAttribute(HObject obj) {
        if (obj == null) {
            return null;
        }
        int idx = this.attrTable.getSelectedRow();
        if (idx < 0) {
            JOptionPane.showMessageDialog(this.getOwner(), "No attribute is selected.", this.getTitle(), 0);
            return null;
        }
        int option = JOptionPane.showConfirmDialog(this, "Do you want to delete the selected attribute?", this.getTitle(), 0, 2);
        if (option == 1) {
            return null;
        }
        List attrList = null;
        try {
            attrList = obj.getMetadata();
        }
        catch (Exception ex) {
            attrList = null;
        }
        if (attrList == null) {
            return null;
        }
        Attribute attr = (Attribute)attrList.get(idx);
        try {
            obj.removeMetadata((Object)attr);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.attrTableModel.removeRow(idx);
        --this.numAttributes;
        this.attrTableModel.fireTableRowsDeleted(idx, idx);
        this.attrContentArea.setText("");
        this.attrNumberLabel.setText("Number of attributes = " + this.numAttributes);
        return attr;
    }

    private JPanel createGeneralPropertyPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        boolean isRoot = this.hObject instanceof Group && ((Group)this.hObject).isRoot();
        FileFormat theFile = this.hObject.getFileFormat();
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        JPanel lp = new JPanel();
        lp.setLayout(new GridLayout(5, 1));
        if (isRoot) {
            lp.add(new JLabel("File Name: "));
            lp.add(new JLabel("File Path: "));
            lp.add(new JLabel("File Type: "));
            if (this.isH5) {
                try {
                    this.libver = this.hObject.getFileFormat().getLibBounds();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if ((this.libver[0] == 0 || this.libver[0] == 1) && this.libver[1] == 1) {
                    lp.add(new JLabel("Library version: "));
                }
            }
        } else {
            lp.add(new JLabel("Name: "));
            if (this.isH5 && this.hObject.getLinkTargetObjName() != null) {
                lp.add(new JLabel("Link To Target: "));
            }
            lp.add(new JLabel("Path: "));
            lp.add(new JLabel("Type: "));
            if (this.isH4) {
                lp.add(new JLabel("Tag, Ref:        "));
            } else {
                lp.add(new JLabel("Object Ref:       "));
            }
        }
        JPanel rp = new JPanel();
        rp.setLayout(new GridLayout(5, 1));
        JLabel nameField = new JLabel(this.hObject.getName());
        rp.add(nameField);
        JPanel targetObjPanel = new JPanel();
        JButton ChangeTargetObjButton = new JButton("Change");
        ChangeTargetObjButton.setActionCommand("Change link target");
        ChangeTargetObjButton.addActionListener(this);
        if (this.isH5 && this.hObject.getLinkTargetObjName() != null) {
            this.linkField = new JTextField(this.hObject.getLinkTargetObjName());
            targetObjPanel.setLayout(new BorderLayout());
            targetObjPanel.add((Component)this.linkField, "Center");
            rp.add(targetObjPanel);
        }
        JLabel pathField = new JLabel();
        if (isRoot) {
            pathField.setText(new File(this.hObject.getFile()).getParent());
        } else {
            pathField.setText(this.hObject.getPath());
        }
        rp.add(pathField);
        String typeStr = "Unknown";
        String fileInfo = "";
        if (isRoot) {
            long size = 0L;
            try {
                size = new File(this.hObject.getFile()).length();
            }
            catch (Exception ex) {
                size = -1L;
            }
            size /= 1024L;
            int groupCount = 0;
            int datasetCount = 0;
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)theFile.getRootNode();
            DefaultMutableTreeNode theNode = null;
            Enumeration<TreeNode> local_enum = root.depthFirstEnumeration();
            while (local_enum.hasMoreElements()) {
                theNode = (DefaultMutableTreeNode)local_enum.nextElement();
                if (theNode.getUserObject() instanceof Group) {
                    ++groupCount;
                    continue;
                }
                ++datasetCount;
            }
            fileInfo = "size=" + size + "K,  groups=" + groupCount + ",  datasets=" + datasetCount;
        }
        if (isRoot) {
            typeStr = this.isH5 ? "HDF5,  " + fileInfo : (this.isH4 ? "HDF4,  " + fileInfo : fileInfo);
        } else if (this.isH5) {
            if (this.hObject instanceof Group) {
                typeStr = "HDF5 Group";
            } else if (this.hObject instanceof ScalarDS) {
                typeStr = "HDF5 Scalar Dataset";
            } else if (this.hObject instanceof CompoundDS) {
                typeStr = "HDF5 Compound Dataset";
            } else if (this.hObject instanceof Datatype) {
                typeStr = "HDF5 Named Datatype";
            }
        } else if (this.isH4) {
            if (this.hObject instanceof Group) {
                typeStr = "HDF4 Group";
            } else if (this.hObject instanceof ScalarDS) {
                ScalarDS ds = (ScalarDS)this.hObject;
                typeStr = ds.isImage() ? "HDF4 Raster Image" : "HDF4 SDS";
            } else if (this.hObject instanceof CompoundDS) {
                typeStr = "HDF4 Vdata";
            }
        } else if (this.hObject instanceof Group) {
            typeStr = "Group";
        } else if (this.hObject instanceof ScalarDS) {
            typeStr = "Scalar Dataset";
        } else if (this.hObject instanceof CompoundDS) {
            typeStr = "Compound Dataset";
        }
        JLabel typeField = new JLabel(typeStr);
        rp.add(typeField);
        if (isRoot && this.isH5) {
            String libversion = null;
            if (this.libver[0] == 0 && this.libver[1] == 1) {
                libversion = "Earliest and Latest";
            } else if (this.libver[0] == 1 && this.libver[1] == 1) {
                libversion = "Latest and Latest";
            }
            JLabel libverbound = new JLabel(libversion);
            rp.add(libverbound);
        }
        String oidStr = null;
        long[] OID = this.hObject.getOID();
        if (OID != null) {
            oidStr = String.valueOf(OID[0]);
            for (int i = 1; i < OID.length; ++i) {
                oidStr = oidStr + ", " + OID[i];
            }
        }
        if (!isRoot) {
            JLabel oidField = new JLabel(oidStr);
            rp.add(oidField);
        }
        JPanel tmpP = new JPanel();
        tmpP.setLayout(new BorderLayout());
        tmpP.add("West", lp);
        tmpP.add("Center", rp);
        tmpP.setBorder(new TitledBorder(""));
        topPanel.add("North", new JLabel(""));
        topPanel.add("Center", tmpP);
        JPanel infoPanel = null;
        if (this.hObject instanceof Group) {
            infoPanel = this.createGroupInfoPanel((Group)this.hObject);
        } else if (this.hObject instanceof Dataset) {
            infoPanel = this.createDatasetInfoPanel((Dataset)this.hObject);
        } else if (this.hObject instanceof Datatype) {
            infoPanel = this.createNamedDatatypeInfoPanel((Datatype)this.hObject);
        }
        panel.add((Component)topPanel, "North");
        if (infoPanel != null) {
            panel.add((Component)infoPanel, "Center");
        }
        return panel;
    }

    private JPanel createGroupInfoPanel(Group g) {
        JPanel panel = new JPanel();
        List mlist = g.getMemberList();
        if (mlist == null) {
            return panel;
        }
        int n = mlist.size();
        if (n <= 0) {
            return panel;
        }
        Object[][] rowData = new String[n][2];
        for (int i = 0; i < n; ++i) {
            HObject theObj = (HObject)mlist.get(i);
            rowData[i][0] = theObj.getName();
            if (theObj instanceof Group) {
                rowData[i][1] = "Group";
                continue;
            }
            if (!(theObj instanceof Dataset)) continue;
            rowData[i][1] = "Dataset";
        }
        Object[] columnNames = new String[]{"Name", "Type"};
        JTable table = new JTable(rowData, columnNames){
            private static final long serialVersionUID = -834321929059590629L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        table.setName("GroupInfo");
        table.setCellSelectionEnabled(false);
        int cellRowHeight = Math.max(16, table.getFontMetrics(table.getFont()).getHeight());
        table.setRowHeight(cellRowHeight);
        table.getTableHeader().setReorderingAllowed(false);
        JScrollPane scroller = new JScrollPane(table);
        panel.setLayout(new BorderLayout());
        if (g.getNumberOfMembersInFile() < ViewProperties.getMaxMembers()) {
            panel.add((Component)new JLabel("Number of members: " + n), "North");
        } else {
            panel.add((Component)new JLabel("Number of members: " + n + " (in memory), " + g.getNumberOfMembersInFile() + " (in file)"), "North");
        }
        panel.add((Component)scroller, "Center");
        panel.setBorder(new TitledBorder("Group Members"));
        return panel;
    }

    private JPanel createNamedDatatypeInfoPanel(Datatype t) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JTextArea infoArea = new JTextArea(t.getDatatypeDescription());
        infoArea.setEditable(false);
        panel.add((Component)infoArea, "Center");
        return panel;
    }

    private JPanel createDatasetInfoPanel(Dataset d) {
        CompoundDS compound;
        int n;
        JPanel lp = new JPanel();
        lp.setLayout(new GridLayout(4, 1));
        lp.add(new JLabel("No. of Dimension(s): "));
        lp.add(new JLabel("Dimension Size(s): "));
        lp.add(new JLabel("Max Dimension Size(s): "));
        lp.add(new JLabel("Data Type: "));
        JPanel rp = new JPanel();
        rp.setLayout(new GridLayout(4, 1));
        if (d.getRank() <= 0) {
            d.init();
        }
        JTextField txtf = new JTextField("" + d.getRank());
        txtf.setEditable(false);
        rp.add(txtf);
        String dimStr = null;
        String maxDimStr = null;
        long[] dims = d.getDims();
        long[] maxDims = d.getMaxDims();
        if (dims != null) {
            String[] dimNames = d.getDimNames();
            boolean hasDimNames = dimNames != null && dimNames.length == dims.length;
            StringBuffer sb = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            sb.append(dims[0]);
            if (hasDimNames) {
                sb.append(" (");
                sb.append(dimNames[0]);
                sb.append(")");
            }
            if (maxDims[0] < 0L) {
                sb2.append("Unlimited");
            } else {
                sb2.append(maxDims[0]);
            }
            for (int i = 1; i < dims.length; ++i) {
                sb.append(" x ");
                sb.append(dims[i]);
                if (hasDimNames) {
                    sb.append(" (");
                    sb.append(dimNames[i]);
                    sb.append(")");
                }
                sb2.append(" x ");
                if (maxDims[i] < 0L) {
                    sb2.append("Unlimited");
                    continue;
                }
                sb2.append(maxDims[i]);
            }
            dimStr = sb.toString();
            maxDimStr = sb2.toString();
        }
        txtf = new JTextField(dimStr);
        txtf.setEditable(false);
        rp.add(txtf);
        txtf = new JTextField(maxDimStr);
        txtf.setEditable(false);
        rp.add(txtf);
        String typeStr = null;
        if (d instanceof ScalarDS) {
            ScalarDS sd = (ScalarDS)d;
            typeStr = sd.getDatatype().getDatatypeDescription();
        } else if (d instanceof CompoundDS) {
            typeStr = this.isH4 ? "Vdata" : "Compound";
        }
        txtf = new JTextField(typeStr);
        txtf.setEditable(false);
        rp.add(txtf);
        JPanel infoP = new JPanel();
        infoP.setLayout(new BorderLayout());
        infoP.add((Component)lp, "West");
        infoP.add((Component)rp, "Center");
        infoP.setBorder(new TitledBorder(""));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)infoP, "North");
        panel.setBorder(new TitledBorder("Dataspace and Datatype"));
        if (d instanceof CompoundDS && (n = (compound = (CompoundDS)d).getMemberCount()) > 0) {
            Object[][] rowData = new String[n][3];
            String[] names = compound.getMemberNames();
            Datatype[] types = compound.getMemberTypes();
            int[] orders = compound.getMemberOrders();
            for (int i = 0; i < n; ++i) {
                rowData[i][0] = names[i];
                int[] mDims = compound.getMemeberDims(i);
                if (mDims == null) {
                    rowData[i][2] = String.valueOf(orders[i]);
                    if (this.isH4 && types[i].getDatatypeClass() == 3) {
                        rowData[i][2] = String.valueOf(types[i].getDatatypeSize());
                    }
                } else {
                    String mStr = String.valueOf(mDims[0]);
                    int m = mDims.length;
                    for (int j = 1; j < m; ++j) {
                        mStr = mStr + " x " + mDims[j];
                    }
                    rowData[i][2] = mStr;
                }
                rowData[i][1] = types[i].getDatatypeDescription();
            }
            Object[] columnNames = new String[]{"Name", "Type", "Array Size"};
            JTable table = new JTable(rowData, columnNames){
                private static final long serialVersionUID = -1517773307922536859L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            table.setName("CompoundMetaData");
            table.setCellSelectionEnabled(false);
            table.getTableHeader().setReorderingAllowed(false);
            panel.add((Component)new JScrollPane(table), "Center");
            int cellRowHeight = Math.max(16, table.getFontMetrics(table.getFont()).getHeight());
            table.setRowHeight(cellRowHeight);
        }
        String chunkInfo = "";
        long[] chunks = d.getChunkSize();
        if (chunks == null) {
            chunkInfo = "NONE";
        } else {
            int n2 = chunks.length;
            chunkInfo = String.valueOf(chunks[0]);
            for (int i = 1; i < n2; ++i) {
                chunkInfo = chunkInfo + " X " + chunks[i];
            }
        }
        JPanel bPanel = new JPanel();
        bPanel.setBorder(new TitledBorder(""));
        bPanel.setLayout(new BorderLayout());
        lp = new JPanel();
        lp.setLayout(new GridLayout(3, 1));
        lp.add(new JLabel("Chunking: "));
        lp.add(new JLabel("Compression: "));
        lp.add(new JLabel("Fill value: "));
        bPanel.add((Component)lp, "West");
        Object fillValue = null;
        String fillValueInfo = "NONE";
        if (d instanceof ScalarDS) {
            fillValue = ((ScalarDS)d).getFillValue();
        }
        if (fillValue != null) {
            if (fillValue.getClass().isArray()) {
                int len = Array.getLength(fillValue);
                fillValueInfo = Array.get(fillValue, 0).toString();
                for (int i = 1; i < len; ++i) {
                    fillValueInfo = fillValueInfo + ", ";
                    fillValueInfo = fillValueInfo + Array.get(fillValue, i).toString();
                }
            } else {
                fillValueInfo = fillValue.toString();
            }
        }
        rp = new JPanel();
        rp.setLayout(new GridLayout(3, 1));
        rp.add(new JLabel(chunkInfo));
        rp.add(new JLabel(d.getCompression()));
        rp.add(new JLabel(fillValueInfo));
        bPanel.add((Component)rp, "Center");
        panel.add((Component)bPanel, "South");
        return panel;
    }

    private JPanel createAttributePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        this.attrNumberLabel = new JLabel("Number of attributes = 0");
        topPanel.add((Component)this.attrNumberLabel, "West");
        FileFormat theFile = this.hObject.getFileFormat();
        JPanel bPanel = new JPanel();
        JButton b = new JButton(" Add ");
        b.setMnemonic('A');
        b.addActionListener(this);
        b.setActionCommand("Add attribute");
        bPanel.add(b);
        b.setEnabled(!theFile.isReadOnly());
        if (this.isH5) {
            b = new JButton("Delete");
            b.setMnemonic('D');
            b.addActionListener(this);
            b.setActionCommand("Delete attribute");
            bPanel.add(b);
            b.setEnabled(!theFile.isReadOnly());
        }
        topPanel.add((Component)bPanel, "East");
        panel.add((Component)topPanel, "North");
        List attrList = null;
        try {
            attrList = this.hObject.getMetadata();
        }
        catch (Exception ex) {
            attrList = null;
        }
        if (attrList != null) {
            this.numAttributes = attrList.size();
        }
        Object[] columnNames = new String[]{"Name", "Value", "Type", "Array Size"};
        this.attrTableModel = new DefaultTableModel(columnNames, this.numAttributes);
        this.attrTable = new JTable(this.attrTableModel){
            private static final long serialVersionUID = 2590244645972259454L;
            int lastSelectedRow;
            int lastSelectedCol;
            {
                this.lastSelectedRow = -1;
                this.lastSelectedCol = -1;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1 || DefaultMetaDataView.this.isH5 && column == 0;
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                int row = this.getEditingRow();
                int col = this.getEditingColumn();
                String oldValue = (String)this.getValueAt(row, col);
                super.editingStopped(e);
                Object source = e.getSource();
                if (source instanceof CellEditor) {
                    CellEditor editor = (CellEditor)source;
                    String newValue = (String)editor.getCellEditorValue();
                    this.setValueAt(oldValue, row, col);
                    DefaultMetaDataView.this.updateAttributeValue(newValue, row, col);
                }
            }

            @Override
            public boolean isCellSelected(int row, int col) {
                if (this.getSelectedRow() == row && this.getSelectedColumn() == col && (this.lastSelectedRow != row || this.lastSelectedCol != col)) {
                    Object attrV = this.getValueAt(row, col);
                    if (attrV != null) {
                        DefaultMetaDataView.this.attrContentArea.setText(attrV.toString());
                    }
                    this.lastSelectedRow = row;
                    this.lastSelectedCol = col;
                }
                return super.isCellSelected(row, col);
            }
        };
        this.attrTable.setName("attributes");
        this.attrTable.setRowSelectionAllowed(false);
        this.attrTable.setCellSelectionEnabled(true);
        this.attrTable.getTableHeader().setReorderingAllowed(false);
        this.attrTable.setSelectionMode(0);
        int cellRowHeight = Math.max(16, this.attrTable.getFontMetrics(this.attrTable.getFont()).getHeight());
        this.attrTable.setRowHeight(cellRowHeight);
        JScrollPane scroller1 = new JScrollPane(this.attrTable);
        this.attrContentArea = new JTextArea();
        this.attrContentArea.setLineWrap(true);
        this.attrContentArea.setEditable(false);
        Insets m = new Insets(5, 5, 5, 5);
        this.attrContentArea.setMargin(m);
        JScrollPane scroller2 = new JScrollPane(this.attrContentArea);
        JSplitPane splitPane = new JSplitPane(0, scroller1, scroller2);
        int h = Math.min((this.numAttributes + 2) * this.attrTable.getRowHeight(), scroller1.getPreferredSize().height - 40);
        splitPane.setDividerLocation(h);
        panel.add((Component)splitPane, "Center");
        if (attrList == null) {
            return panel;
        }
        Attribute attr = null;
        this.attrNumberLabel.setText("Number of attributes = " + this.numAttributes);
        for (int i = 0; i < this.numAttributes; ++i) {
            String size;
            attr = (Attribute)attrList.get(i);
            String name = attr.getName();
            String type = attr.getType().getDatatypeDescription();
            if (attr.isScalar()) {
                size = "Scalar";
            } else {
                long[] dims = attr.getDataDims();
                size = String.valueOf(dims[0]);
                for (int j = 1; j < dims.length; ++j) {
                    size = size + " x " + dims[j];
                }
            }
            this.attrTable.setValueAt(name, i, 0);
            this.attrTable.setValueAt(attr.toString(", "), i, 1);
            this.attrTable.setValueAt(type, i, 2);
            this.attrTable.setValueAt(size, i, 3);
        }
        return panel;
    }

    private JPanel createUserBlockPanel() {
        JPanel panel = new JPanel();
        this.userBlock = DefaultFileFilter.getHDF5UserBlock(this.hObject.getFile());
        panel.setLayout(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.userBlockArea = new JTextArea();
        this.userBlockArea.setEditable(true);
        this.userBlockArea.setLineWrap(true);
        Insets m = new Insets(5, 5, 5, 5);
        this.userBlockArea.setMargin(m);
        String[] displayChoices = new String[]{"Text", "Binary", "Octal", "Hexadecimal", "Decimal"};
        JComboBox<String> userBlockDisplayChoice = new JComboBox<String>(displayChoices);
        userBlockDisplayChoice.setSelectedIndex(0);
        userBlockDisplayChoice.addActionListener(this);
        userBlockDisplayChoice.setEditable(false);
        userBlockDisplayChoice.setActionCommand("Display user block as");
        JLabel sizeLabel = new JLabel("Header Size (Bytes): 0");
        this.jamButton = new JButton("Save User Block");
        this.jamButton.setActionCommand("Jam user block");
        this.jamButton.addActionListener(this);
        JPanel topPane = new JPanel();
        topPane.setLayout(new BorderLayout(10, 5));
        topPane.add((Component)new JLabel("Display As:"), "West");
        JPanel topPane0 = new JPanel();
        topPane0.setLayout(new GridLayout(1, 2, 10, 5));
        topPane0.add(userBlockDisplayChoice);
        topPane0.add(sizeLabel);
        topPane.add((Component)topPane0, "Center");
        topPane.add((Component)this.jamButton, "East");
        JScrollPane scroller = new JScrollPane(this.userBlockArea);
        panel.add((Component)topPane, "North");
        panel.add((Component)scroller, "Center");
        int headSize = 0;
        if (this.userBlock != null) {
            headSize = this.showUserBlockAs(0);
            sizeLabel.setText("Header Size (Bytes): " + headSize);
        } else {
            userBlockDisplayChoice.setEnabled(false);
        }
        return panel;
    }

    private int showUserBlockAs(int radix) {
        int headerSize = 0;
        if (this.userBlock == null) {
            return 0;
        }
        String userBlockInfo = null;
        if (radix == 2 || radix == 8 || radix == 16 || radix == 10) {
            StringBuffer sb = new StringBuffer();
            for (headerSize = 0; headerSize < this.userBlock.length; ++headerSize) {
                int intValue = this.userBlock[headerSize];
                if (intValue < 0) {
                    intValue += 256;
                } else if (intValue == 0) break;
                sb.append(Integer.toString(intValue, radix));
                sb.append(" ");
            }
            userBlockInfo = sb.toString();
        } else {
            userBlockInfo = new String(this.userBlock).trim();
            if (userBlockInfo != null) {
                headerSize = userBlockInfo.length();
            }
        }
        this.userBlockArea.setText(userBlockInfo);
        return headerSize;
    }

    private void updateAttributeValue(String newValue, int row, int col) {
        String attrName = (String)this.attrTable.getValueAt(row, 0);
        List attrList = null;
        try {
            attrList = this.hObject.getMetadata();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.getOwner(), ex.getMessage(), this.getTitle(), 0);
            return;
        }
        Attribute attr = (Attribute)attrList.get(row);
        if (col == 1) {
            Object data = attr.getValue();
            if (data == null) {
                return;
            }
            int array_length = Array.getLength(data);
            StringTokenizer st = new StringTokenizer(newValue, ",");
            if (st.countTokens() < array_length) {
                JOptionPane.showMessageDialog(this.getOwner(), "More data value needed: " + newValue, this.getTitle(), 0);
                return;
            }
            int NT = 32;
            String cName = data.getClass().getName();
            int cIndex = cName.lastIndexOf("[");
            if (cIndex >= 0) {
                NT = cName.charAt(cIndex + 1);
            }
            boolean isUnsigned = attr.isUnsigned();
            double d = 0.0;
            String theToken = null;
            long max = 0L;
            long min = 0L;
            block16: for (int i = 0; i < array_length; ++i) {
                min = 0L;
                max = 0L;
                theToken = st.nextToken().trim();
                try {
                    if (!(Array.get(data, i) instanceof String)) {
                        d = Double.parseDouble(theToken);
                    }
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this.getOwner(), ex.getMessage(), this.getTitle(), 0);
                    return;
                }
                if (isUnsigned && d < 0.0) {
                    JOptionPane.showMessageDialog(this.getOwner(), "Negative value for unsigned integer: " + theToken, this.getTitle(), 0);
                    return;
                }
                switch (NT) {
                    case 66: {
                        if (isUnsigned) {
                            min = 0L;
                            max = 255L;
                        } else {
                            min = -128L;
                            max = 127L;
                        }
                        if (d > (double)max || d < (double)min) {
                            JOptionPane.showMessageDialog(this.getOwner(), "Data is out of range[" + min + ", " + max + "]: " + theToken, this.getTitle(), 0);
                            continue block16;
                        }
                        Array.setByte(data, i, (byte)d);
                        continue block16;
                    }
                    case 83: {
                        if (isUnsigned) {
                            min = 0L;
                            max = 65535L;
                        } else {
                            min = -32768L;
                            max = 32767L;
                        }
                        if (d > (double)max || d < (double)min) {
                            JOptionPane.showMessageDialog(this.getOwner(), "Data is out of range[" + min + ", " + max + "]: " + theToken, this.getTitle(), 0);
                            continue block16;
                        }
                        Array.setShort(data, i, (short)d);
                        continue block16;
                    }
                    case 73: {
                        if (isUnsigned) {
                            min = 0L;
                            max = 0xFFFFFFFFL;
                        } else {
                            min = Integer.MIN_VALUE;
                            max = Integer.MAX_VALUE;
                        }
                        if (d > (double)max || d < (double)min) {
                            JOptionPane.showMessageDialog(this.getOwner(), "Data is out of range[" + min + ", " + max + "]: " + theToken, this.getTitle(), 0);
                            continue block16;
                        }
                        Array.setInt(data, i, (int)d);
                        continue block16;
                    }
                    case 74: {
                        if (isUnsigned) {
                            if (theToken != null) {
                                String theValue = theToken;
                                BigInteger big = new BigInteger(theValue);
                                BigInteger Jmax = new BigInteger("18446744073709551615");
                                if (big.compareTo(Jmax) > 0 || big.compareTo(BigInteger.ZERO) < 0) {
                                    JOptionPane.showMessageDialog(this.getOwner(), "Data is out of range[" + min + ", " + max + "]: " + theToken, this.getTitle(), 0);
                                }
                                Array.setLong(data, i, big.longValue());
                                continue block16;
                            }
                            Array.set(data, i, theToken);
                            continue block16;
                        }
                        min = Long.MIN_VALUE;
                        max = Long.MAX_VALUE;
                        if (d > (double)max || d < (double)min) {
                            JOptionPane.showMessageDialog(this.getOwner(), "Data is out of range[" + min + ", " + max + "]: " + theToken, this.getTitle(), 0);
                        }
                        Array.setLong(data, i, (long)d);
                        continue block16;
                    }
                    case 70: {
                        Array.setFloat(data, i, (float)d);
                        continue block16;
                    }
                    case 68: {
                        Array.setDouble(data, i, d);
                        continue block16;
                    }
                    default: {
                        Array.set(data, i, theToken);
                    }
                }
            }
            try {
                this.hObject.getFileFormat().writeAttribute(this.hObject, attr, true);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.getOwner(), ex.getMessage(), this.getTitle(), 0);
                return;
            }
            this.attrTable.setValueAt(attr.toString(", "), row, 1);
        }
        if (col == 0 && this.isH5) {
            try {
                this.hObject.getFileFormat().renameAttribute(this.hObject, attrName, newValue);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.getOwner(), ex.getMessage(), this.getTitle(), 0);
                return;
            }
            this.attrTable.setValueAt(newValue, row, 0);
        }
    }

    private void writeUserBlock() {
        if (!this.isH5) {
            return;
        }
        int blkSize0 = 0;
        if (this.userBlock != null && (blkSize0 = this.userBlock.length) > 0) {
            int offset;
            for (offset = 512; offset < blkSize0; offset *= 2) {
            }
            blkSize0 = offset;
        }
        int blkSize1 = 0;
        String userBlockStr = this.userBlockArea.getText();
        if (userBlockStr == null) {
            if (blkSize0 <= 0) {
                return;
            }
            userBlockStr = " ";
        }
        byte[] buf = null;
        buf = userBlockStr.getBytes();
        blkSize1 = buf.length;
        if (blkSize1 <= blkSize0) {
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(this.hObject.getFile(), "rw");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Can't open output file: " + this.hObject.getFile(), this.getTitle(), 0);
                return;
            }
            try {
                raf.seek(0L);
                raf.write(buf, 0, buf.length);
                raf.seek(buf.length);
                if (blkSize0 > buf.length) {
                    byte[] padBuf = new byte[blkSize0 - buf.length];
                    raf.write(padBuf, 0, padBuf.length);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                raf.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(this, "Saving user block is successful.", this.getTitle(), 1);
        } else {
            int op = JOptionPane.showConfirmDialog(this, "The user block to write is " + blkSize1 + " (bytes),\n" + "which is larger than the user block space in file " + blkSize0 + " (bytes).\n" + "To expand the user block, the file must be rewriten.\n\n" + "Do you want to replace the current file? Click " + "\n\"Yes\" to replace the current file," + "\n\"No\" to save to a different file, " + "\n\"Cancel\" to quit without saving the change.\n\n ", this.getTitle(), 1, 2);
            if (op == 2) {
                return;
            }
            String fin = this.hObject.getFile();
            String fout = fin + "~copy.h5";
            if (fin.endsWith(".h5")) {
                fout = fin.substring(0, fin.length() - 3) + "~copy.h5";
            } else if (fin.endsWith(".hdf5")) {
                fout = fin.substring(0, fin.length() - 5) + "~copy.h5";
            }
            File outFile = null;
            if (op == 1) {
                JFileChooser fchooser = new JFileChooser();
                fchooser.setFileFilter(DefaultFileFilter.getFileFilterHDF5());
                fchooser.setSelectedFile(new File(fout));
                int returnVal = fchooser.showSaveDialog(this);
                if (returnVal != 0) {
                    return;
                }
                File choosedFile = fchooser.getSelectedFile();
                if (choosedFile == null) {
                    return;
                }
                outFile = choosedFile;
                fout = outFile.getAbsolutePath();
            } else {
                outFile = new File(fout);
            }
            if (!outFile.exists()) {
                try {
                    outFile.createNewFile();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "Fail to write user block into file. ", this.getTitle(), 0);
                    return;
                }
            }
            ActionEvent e = new ActionEvent(this, 1001, "Close file");
            ((HDFView)this.viewer).actionPerformed(e);
            if (DefaultFileFilter.setHDF5UserBlock(fin, fout, buf)) {
                if (op == 1) {
                    fin = fout;
                } else {
                    File oldFile = new File(fin);
                    boolean status = oldFile.delete();
                    if (status) {
                        outFile.renameTo(oldFile);
                    } else {
                        JOptionPane.showMessageDialog(this, "Cannot replace the current file.\nPlease save to a different file.", this.getTitle(), 0);
                        outFile.delete();
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this, "Fail to write user block into file. ", this.getTitle(), 0);
                outFile.delete();
            }
            this.dispose();
            e = new ActionEvent(this, 1001, "Open file://" + fin);
            ((HDFView)this.viewer).actionPerformed(e);
        }
    }
}

