/*
 * Decompiled with CFR 0.152.
 */
package worldwind.kml.model;

import gov.nasa.worldwind.geom.Sector;
import java.util.List;
import worldwind.kml.model.KMLCoord;
import worldwind.kml.model.KMLGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMLLineString
extends KMLGraphic {
    List<KMLCoord> coords;
    Sector sector = null;
    boolean tessellate;
    boolean absolute = false;
    boolean extrude = false;

    public List<KMLCoord> getCoords() {
        return this.coords;
    }

    public void setCoords(List<KMLCoord> list) {
        this.coords = list;
    }

    @Override
    public Sector getSector() {
        if (this.sector == null) {
            double d = 180.0;
            double d2 = 90.0;
            double d3 = -180.0;
            double d4 = -90.0;
            for (KMLCoord kMLCoord : this.coords) {
                double d5 = kMLCoord.getLon();
                double d6 = kMLCoord.getLat();
                if (d5 < d) {
                    d = d5;
                }
                if (d5 > d3) {
                    d3 = d5;
                }
                if (d6 < d2) {
                    d2 = d6;
                }
                if (!(d6 > d4)) continue;
                d4 = d6;
            }
            this.sector = Sector.fromDegrees((double)d2, (double)d4, (double)d, (double)d3);
        }
        return this.sector;
    }

    public boolean isTessellate() {
        return this.tessellate;
    }

    public void setTessellate(boolean bl) {
        this.tessellate = bl;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public void setAbsolute(boolean bl) {
        this.absolute = bl;
    }

    public boolean isExtrude() {
        return this.extrude;
    }

    public void setExtrude(boolean bl) {
        this.extrude = bl;
    }
}

