/*
 * Decompiled with CFR 0.152.
 */
package worldwind.kml.model;

import gov.nasa.worldwind.geom.Sector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import worldwind.kml.model.KMLCoord;
import worldwind.kml.model.KMLFolder;
import worldwind.kml.model.KMLGraphic;
import worldwind.kml.model.KMLLineString;
import worldwind.kml.model.KMLObject;
import worldwind.kml.model.KMLPlacemark;
import worldwind.kml.model.KMLPoint;
import worldwind.kml.model.KMLPolygon;
import worldwind.kml.model.KMLStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMLFile {
    KMLFolder rootFolder = new KMLFolder();
    Map<String, KMLStyle> styles = new HashMap<String, KMLStyle>();
    Map<String, Set<String>> schemaAliases = new HashMap<String, Set<String>>();
    Sector sector = null;

    public KMLFolder getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(KMLFolder kMLFolder) {
        this.rootFolder = kMLFolder;
    }

    public void addStyle(String string, KMLStyle kMLStyle) {
        this.styles.put(string, kMLStyle);
    }

    public KMLStyle getStyle(String string) {
        return this.styles.get(string);
    }

    public Sector getSector() {
        if (this.sector == null) {
            ArrayList<KMLCoord> arrayList = new ArrayList<KMLCoord>();
            this.collectCoords(this.rootFolder, arrayList);
            double d = 180.0;
            double d2 = 90.0;
            double d3 = -180.0;
            double d4 = -90.0;
            for (KMLCoord kMLCoord : arrayList) {
                double d5 = kMLCoord.getLon();
                double d6 = kMLCoord.getLat();
                if (d5 < d) {
                    d = d5;
                }
                if (d5 > d3) {
                    d3 = d5;
                }
                if (d6 < d2) {
                    d2 = d6;
                }
                if (!(d6 > d4)) continue;
                d4 = d6;
            }
            this.sector = Sector.fromDegrees((double)d2, (double)d4, (double)d, (double)d3);
        }
        return this.sector;
    }

    private void collectCoords(KMLFolder kMLFolder, List<KMLCoord> list) {
        for (KMLObject object : kMLFolder.getObjects()) {
            if (!(object instanceof KMLPlacemark)) continue;
            KMLGraphic kMLGraphic = ((KMLPlacemark)object).getGraphic();
            if (kMLGraphic instanceof KMLPoint) {
                list.add(((KMLPoint)kMLGraphic).getCoord());
                continue;
            }
            if (kMLGraphic instanceof KMLLineString) {
                list.addAll(((KMLLineString)kMLGraphic).getCoords());
                continue;
            }
            if (!(kMLGraphic instanceof KMLPolygon)) continue;
            list.addAll(((KMLPolygon)kMLGraphic).getOuter());
        }
        for (KMLFolder kMLFolder2 : kMLFolder.getChildFolders()) {
            this.collectCoords(kMLFolder2, list);
        }
    }

    public void addAlias(String string, String string2) {
        Set<String> set = this.schemaAliases.get(string);
        if (set == null) {
            set = new HashSet<String>();
            this.schemaAliases.put(string, set);
        }
        set.add(string2);
    }

    public Set<String> getAliasesFor(String string) {
        Set<String> set = this.schemaAliases.get(string);
        if (set == null) {
            set = new HashSet<String>();
            this.schemaAliases.put(string, set);
        }
        return set;
    }
}

