/*
 * Decompiled with CFR 0.152.
 */
package worldwind.kml;

import gov.nasa.worldwind.BasicModel;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.ViewStateIterator;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLJPanel;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.examples.BasicDragger;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Earth.BMNGSurfaceLayer;
import gov.nasa.worldwind.layers.Earth.LandsatI3;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.WorldMapLayer;
import gov.nasa.worldwind.render.WWIcon;
import gov.nasa.worldwind.util.StatusBar;
import gov.nasa.worldwind.view.FlyToOrbitViewStateIterator;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import worldwind.kml.KMLLayer;
import worldwind.kml.KMLParser;
import worldwind.kml.model.KMLFile;
import worldwind.kml.model.KMLPlacemark;
import worldwind.kml.tree.DocListTreeNode;
import worldwind.kml.tree.KMLDocTreeNode;
import worldwind.kml.tree.KMLTreeView;
import worldwind.kml.tree.Sectored;
import worldwind.kml.ui.InfoDialog;

public class KMLViewer
extends JFrame {
    StatusBar statusBar;
    JLabel cursorPositionDisplay;
    WorldWindowGLJPanel wwd;
    DocListTreeNode docList = new DocListTreeNode();
    KMLTreeView tree;
    JSplitPane splitPane;
    DefaultTreeModel treeModel;
    URL iconURL;

    public KMLViewer() throws HeadlessException {
        super("KML Viewer");
        this.setLayout(new BorderLayout());
        this.wwd = new WorldWindowGLJPanel();
        this.wwd.setPreferredSize(new Dimension(1000, 600));
        this.wwd.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                KMLViewer.this.wwd.grabFocus();
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                KMLViewer.this.wwd.grabFocus();
            }
        });
        this.treeModel = new DefaultTreeModel(this.docList);
        this.tree = new KMLTreeView((WorldWindow)this.wwd, this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TreePath treePath = KMLViewer.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath == null) {
                        return;
                    }
                    Object object = treePath.getLastPathComponent();
                    if (object instanceof Sectored) {
                        KMLViewer.this.zoomToSector(((Sectored)object).getSector());
                    }
                }
            }
        });
        JSplitPane jSplitPane = new JSplitPane(1, new JScrollPane(this.tree), (Component)this.wwd);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDividerSize(3);
        jSplitPane.setDividerLocation(300);
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.statusBar = new StatusBar();
        this.getContentPane().add((Component)this.statusBar, "Last");
        this.statusBar.setEventSource((WorldWindow)this.wwd);
        this.pack();
        BasicModel basicModel = new BasicModel();
        basicModel.getLayers().clear();
        basicModel.getLayers().add((Layer)new BMNGSurfaceLayer());
        LandsatI3 landsatI3 = new LandsatI3();
        landsatI3.setDrawBoundingVolumes(false);
        landsatI3.setOpacity(1.0);
        basicModel.getLayers().add((Layer)landsatI3);
        basicModel.getLayers().add((Layer)new CompassLayer());
        basicModel.getLayers().add((Layer)new WorldMapLayer());
        basicModel.setShowWireframeExterior(false);
        basicModel.setShowWireframeInterior(false);
        this.wwd.setModel((Model)basicModel);
        this.wwd.grabFocus();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.add(new JMenuItem(new AbstractAction("Open File..."){

            public void actionPerformed(ActionEvent actionEvent) {
                KMLViewer.this.openFile();
            }
        }));
        jMenu.add(new JMenuItem(new AbstractAction("Open URL..."){

            public void actionPerformed(ActionEvent actionEvent) {
                KMLViewer.this.openURL();
            }
        }));
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu("Samples");
        jMenu2.add(new SampleFileAction("KML Samples", "http://code.google.com/apis/kml/documentation/KML_Samples.kml"));
        jMenu2.add(new SampleFileAction("Vancouver 3D", "http://bbs.keyhole.com/ubb/placemarks/521519-Vancouver.kmz"));
        jMenu2.add(new SampleFileAction("Appalachian Trail", "http://bbs.keyhole.com/ubb/download.php?Number=1114687"));
        jMenu2.add(new SampleFileAction("World Heritage Sites", "http://whc.unesco.org/p_dynamic/sites/whc-en.kmz"));
        jMenu2.add(new SampleFileAction("Inca Trail", "http://www.jqjacobs.net/archaeo/sites/machu_picchu.kmz"));
        jMenu.add(jMenu2);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.wwd.addSelectListener(new SelectListener(){
            private WWIcon lastToolTipIcon = null;
            private BasicDragger dragger;
            {
                this.dragger = new BasicDragger((WorldWindow)KMLViewer.this.wwd);
            }

            public void selected(SelectEvent selectEvent) {
                Object object;
                if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick") && (object = selectEvent.getTopObject()) != null && object instanceof KMLPlacemark) {
                    KMLViewer.this.displayInfoPane((KMLPlacemark)object);
                }
            }
        });
    }

    private void displayInfoPane(KMLPlacemark kMLPlacemark) {
        if (kMLPlacemark.getDescription() != null) {
            new InfoDialog((Frame)this, "<html>" + kMLPlacemark.getDescription() + "</html>");
        }
    }

    private void openURL() {
        String string = JOptionPane.showInputDialog("KML/KMZ URL:");
        if (string == null) {
            return;
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(this, "Not a valid URL: " + malformedURLException.getMessage());
        }
        if (uRL != null) {
            try {
                KMLFile kMLFile = KMLParser.parseURL(uRL);
                this.addKMLLayer(kMLFile, uRL.toString());
                this.zoomToSector(kMLFile.getSector());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Error: " + exception.getMessage());
            }
        }
    }

    private void openFile() {
        JFileChooser jFileChooser = new JFileChooser();
        if (jFileChooser.showOpenDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                KMLFile kMLFile = KMLParser.parseFile(file.getAbsolutePath());
                this.addKMLLayer(kMLFile, file.getName());
                this.zoomToSector(kMLFile.getSector());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Error: " + exception.getMessage());
            }
        }
    }

    private void addKMLLayer(KMLFile kMLFile, String string) {
        KMLLayer kMLLayer = new KMLLayer(kMLFile);
        this.wwd.getModel().getLayers().add((Layer)kMLLayer);
        this.docList.add(new KMLDocTreeNode(kMLFile, string, kMLLayer));
        this.treeModel.nodeStructureChanged(this.docList);
    }

    private void zoomToSector(Sector sector) {
        if (sector == null) {
            return;
        }
        OrbitView orbitView = (OrbitView)this.wwd.getView();
        Globe globe = this.wwd.getModel().getGlobe();
        LatLon latLon = new LatLon(Angle.average((Angle)sector.getMinLatitude(), (Angle)sector.getMaxLatitude()), Angle.average((Angle)sector.getMinLongitude(), (Angle)sector.getMaxLongitude()));
        FlyToOrbitViewStateIterator flyToOrbitViewStateIterator = FlyToOrbitViewStateIterator.createPanToIterator((OrbitView)orbitView, (Globe)globe, (Position)new Position(latLon, 0.0), (Angle)orbitView.getHeading(), (Angle)orbitView.getPitch(), (double)100000.0);
        orbitView.applyStateIterator((ViewStateIterator)flyToOrbitViewStateIterator);
    }

    public static void main(String[] stringArray) {
        if (Configuration.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "World Wind AWT Canvas App");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
        }
        KMLViewer kMLViewer = new KMLViewer();
        kMLViewer.setDefaultCloseOperation(3);
        kMLViewer.setVisible(true);
    }

    class SampleFileAction
    extends AbstractAction {
        String urlStr;
        String name;

        SampleFileAction(String string, String string2) {
            super(string);
            this.urlStr = string2;
            this.name = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            URL uRL = null;
            try {
                uRL = new URL(this.urlStr);
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(KMLViewer.this, "Not a valid URL: " + malformedURLException.getMessage());
            }
            if (uRL != null) {
                try {
                    KMLFile kMLFile = KMLParser.parseURL(uRL);
                    KMLViewer.this.addKMLLayer(kMLFile, this.name);
                    KMLViewer.this.zoomToSector(kMLFile.getSector());
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(KMLViewer.this, "Error: " + exception.getMessage());
                }
            }
        }
    }
}

