/*
 * Decompiled with CFR 0.152.
 */
package worldwind.kml;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.IconRenderer;
import gov.nasa.worldwind.render.UserFacingIcon;
import java.awt.Color;
import java.awt.Point;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;
import worldwind.kml.model.KMLColor;
import worldwind.kml.model.KMLCoord;
import worldwind.kml.model.KMLFile;
import worldwind.kml.model.KMLFolder;
import worldwind.kml.model.KMLGraphic;
import worldwind.kml.model.KMLLineString;
import worldwind.kml.model.KMLObject;
import worldwind.kml.model.KMLPlacemark;
import worldwind.kml.model.KMLPoint;
import worldwind.kml.model.KMLPolygon;
import worldwind.kml.model.KMLStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMLLayer
extends AbstractLayer {
    KMLFile kmlFile;
    double tessDistance = 10.0;
    double fudgeFactor = 1.0;
    int displayList = -1;
    double simplificationFactor = 0.1;
    List<KMLPlacemark> lineStringsToDraw = new ArrayList<KMLPlacemark>();
    List<KMLPlacemark> pointsToDraw = new ArrayList<KMLPlacemark>();
    ArrayList activeIcons = new ArrayList();
    IconRenderer iconRenderer = new IconRenderer();
    boolean invalid = false;
    KMLPlacemark selectedPoint = null;

    public KMLLayer(KMLFile kMLFile) {
        this.kmlFile = kMLFile;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void setInvalid(boolean bl) {
        this.invalid = bl;
    }

    protected void doRender(DrawContext drawContext) {
        KMLGraphic kMLGraphic;
        if (this.invalid) {
            this.invalid = false;
            drawContext.getGL().glDeleteLists(this.displayList, 1);
            this.displayList = -1;
            this.lineStringsToDraw.clear();
            this.pointsToDraw.clear();
        }
        if (this.displayList == -1) {
            System.out.println("Building display list...");
            this.displayList = drawContext.getGL().glGenLists(1);
            drawContext.getGL().glNewList(this.displayList, 4864);
            this.drawFolder(drawContext, this.kmlFile.getRootFolder());
            drawContext.getGL().glEndList();
            System.out.println("Done.");
        }
        if (!drawContext.getVisibleSector().intersects(this.kmlFile.getSector())) {
            return;
        }
        if (this.sizeInPixels(drawContext, this.kmlFile.getSector()) < 1.0) {
            return;
        }
        GL gL = drawContext.getGL();
        this.setupGL(drawContext, gL);
        gL.glCallList(this.displayList);
        for (KMLPlacemark kMLPlacemark : this.lineStringsToDraw) {
            kMLGraphic = (KMLLineString)kMLPlacemark.getGraphic();
            if (!drawContext.getVisibleSector().intersects(((KMLLineString)kMLGraphic).getSector())) continue;
            this.drawLineString(drawContext, (KMLLineString)kMLGraphic, kMLPlacemark.getStyle());
        }
        this.unsetupGL(gL);
        this.activeIcons = new ArrayList();
        for (KMLPlacemark kMLPlacemark : this.pointsToDraw) {
            kMLGraphic = (KMLPoint)kMLPlacemark.getGraphic();
            if (!drawContext.getVisibleSector().intersects(((KMLPoint)kMLGraphic).getSector()) || !(this.sizeInPixels(drawContext, ((KMLPoint)kMLGraphic).getSector()) > 2.0)) continue;
            UserFacingIcon userFacingIcon = new UserFacingIcon("placemark.png", this.pointPosition(drawContext, (KMLPoint)kMLGraphic));
            if (this.selectedPoint == kMLPlacemark) {
                userFacingIcon.setHighlighted(true);
            }
            this.activeIcons.add(userFacingIcon);
        }
        this.iconRenderer.render(drawContext, (Iterable)this.activeIcons);
    }

    public void pick(DrawContext drawContext, Point point) {
        this.selectedPoint = null;
        Point point2 = new Point(point.x, (int)drawContext.getView().getViewport().getHeight() - point.y);
        for (KMLPlacemark kMLPlacemark : this.pointsToDraw) {
            KMLPoint kMLPoint = (KMLPoint)kMLPlacemark.getGraphic();
            if (!drawContext.getVisibleSector().intersects(kMLPoint.getSector()) || !(this.sizeInPixels(drawContext, kMLPoint.getSector()) > 2.0) || !(this.distanceInPixels(drawContext, this.pointPosition(drawContext, kMLPoint), point2) < 10.0)) continue;
            this.selectedPoint = kMLPlacemark;
            int[] nArray = new int[4];
            ByteBuffer byteBuffer = BufferUtil.newByteBuffer((int)3);
            GL gL = drawContext.getGL();
            gL.glGetIntegerv(2978, nArray, 0);
            gL.glReadPixels(drawContext.getPickPoint().x, nArray[3] - drawContext.getPickPoint().y, 1, 1, 6407, 5121, (Buffer)byteBuffer);
            Color color = new Color(byteBuffer.get(0) & 0xFF, byteBuffer.get(1) & 0xFF, byteBuffer.get(2) & 0xFF, 0);
            drawContext.getPickedObjects().clear();
            drawContext.addPickedObject(new PickedObject(color.getRGB(), (Object)kMLPlacemark, this.pointPosition(drawContext, kMLPoint), false));
            break;
        }
    }

    private Position pointPosition(DrawContext drawContext, KMLPoint kMLPoint) {
        double d;
        Angle angle = Angle.fromDegrees((double)kMLPoint.getCoord().getLat());
        Angle angle2 = Angle.fromDegrees((double)kMLPoint.getCoord().getLon());
        switch (kMLPoint.getAltitudeMode()) {
            case 3: {
                d = kMLPoint.getCoord().getHeight();
                break;
            }
            case 2: {
                d = kMLPoint.getCoord().getHeight() + drawContext.getGlobe().getElevation(angle, angle2);
                break;
            }
            default: {
                d = drawContext.getGlobe().getElevation(angle, angle2);
            }
        }
        return new Position(angle, angle2, d);
    }

    private void setupGL(DrawContext drawContext, GL gL) {
        Vec4 vec4 = drawContext.getView().getEyePoint();
        gL.glPushAttrib(274497);
        gL.glDisable(3553);
        float[] fArray = new float[]{(float)(vec4.x * 2.0), (float)(vec4.y / 2.0), (float)vec4.z, 0.0f};
        float[] fArray2 = new float[]{0.4f, 0.4f, 0.4f, 1.0f};
        float[] fArray3 = new float[]{0.3f, 0.3f, 0.3f, 1.0f};
        float[] fArray4 = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
        gL.glDisable(2903);
        gL.glLightfv(16385, 4611, fArray, 0);
        gL.glLightfv(16385, 4609, fArray2, 0);
        gL.glLightfv(16385, 4608, fArray3, 0);
        gL.glLightfv(16385, 4610, fArray4, 0);
        gL.glDisable(16384);
        gL.glEnable(16385);
        gL.glEnable(2896);
        gL.glEnable(2977);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
    }

    private void unsetupGL(GL gL) {
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        gL.glDisable(16385);
        gL.glEnable(16384);
        gL.glDisable(2896);
        gL.glDisable(2977);
        gL.glPopAttrib();
    }

    private void drawFolder(DrawContext drawContext, KMLFolder kMLFolder) {
        if (!kMLFolder.isVisible()) {
            return;
        }
        for (KMLObject object : kMLFolder.getObjects()) {
            KMLGraphic kMLGraphic;
            KMLPlacemark kMLPlacemark;
            if (!(object instanceof KMLPlacemark) || !(kMLPlacemark = (KMLPlacemark)object).isVisible() || (kMLGraphic = kMLPlacemark.getGraphic()) == null) continue;
            if (kMLGraphic instanceof KMLLineString) {
                KMLLineString kMLLineString = (KMLLineString)kMLGraphic;
                if (kMLLineString.isExtrude()) {
                    this.drawExtrudedLineString(drawContext, (KMLLineString)kMLGraphic);
                    continue;
                }
                this.lineStringsToDraw.add(kMLPlacemark);
                continue;
            }
            if (kMLGraphic instanceof KMLPoint) {
                this.pointsToDraw.add(kMLPlacemark);
                continue;
            }
            if (!(kMLGraphic instanceof KMLPolygon)) continue;
            this.drawPoly(drawContext, kMLPlacemark.getStyle(), (KMLPolygon)kMLGraphic);
        }
        for (KMLFolder kMLFolder2 : kMLFolder.getChildFolders()) {
            this.drawFolder(drawContext, kMLFolder2);
        }
    }

    private void drawExtrudedLineString(DrawContext drawContext, KMLLineString kMLLineString) {
        List<KMLCoord> list = kMLLineString.getCoords();
        if (kMLLineString.isTessellate()) {
            list = this.interpolateCoords(list);
        }
        List<Vec4> list2 = this.getExact3dPointsForCoords(drawContext, list, kMLLineString.isAbsolute());
        drawContext.getGL().glLineWidth(3.0f);
        drawContext.getGL().glDisable(2896);
        drawContext.getGL().glColor3f(1.0f, 0.0f, 0.0f);
        drawContext.getGL().glBegin(3);
        for (int i = 0; i < list2.size(); ++i) {
            Vec4 vec4 = list2.get(i);
            drawContext.getGL().glVertex3d(vec4.x, vec4.y, vec4.z);
        }
        drawContext.getGL().glEnd();
        drawContext.getGL().glEnable(2896);
    }

    private void drawLineString(DrawContext drawContext, KMLLineString kMLLineString, KMLStyle kMLStyle) {
        double d = (double)drawContext.getDrawableWidth() / drawContext.getVisibleSector().getDeltaLonDegrees();
        double d2 = this.simplificationFactor / d;
        List<KMLCoord> list = kMLLineString.getCoords();
        ArrayList<KMLCoord> arrayList = new ArrayList<KMLCoord>();
        KMLCoord kMLCoord = null;
        for (int i = 0; i < list.size(); ++i) {
            double d3 = -1.0;
            if (kMLCoord != null && (d3 = kMLCoord.dist(list.get(i))) < d2 && i < list.size() - 1) continue;
            if (kMLLineString.isTessellate() && d3 > d2 * 2.0) {
                double d4 = d3 / (d2 * 2.0);
                double d5 = (kMLCoord.getLon() - list.get(i).getLon()) / d4;
                double d6 = (kMLCoord.getLat() - list.get(i).getLat()) / d4;
                double d7 = (kMLCoord.getHeight() - list.get(i).getHeight()) / d4;
                for (double d8 = 1.0; d8 < d4; d8 += 1.0) {
                    KMLCoord kMLCoord2 = new KMLCoord(kMLCoord.getLon() - d5 * d8, kMLCoord.getLat() - d6 * d8, kMLCoord.getHeight() - d7 * d8);
                    arrayList.add(kMLCoord2);
                }
            }
            arrayList.add(list.get(i));
            kMLCoord = list.get(i);
        }
        List<Vec4> list2 = this.get3dPointsForCoords(drawContext, arrayList, kMLLineString.isAbsolute());
        KMLColor kMLColor = new KMLColor();
        float f = 3.0f;
        if (kMLStyle != null) {
            Float f2;
            if (kMLStyle.getLineStyle("color") != null) {
                kMLColor = (KMLColor)kMLStyle.getLineStyle("color");
            }
            if ((f2 = (Float)kMLStyle.getLineStyle("width")) != null) {
                f = f2.floatValue();
            }
        }
        drawContext.getGL().glLineWidth(f);
        drawContext.getGL().glDisable(2896);
        drawContext.getGL().glColor3f(kMLColor.red, kMLColor.green, kMLColor.blue);
        drawContext.getGL().glBegin(3);
        for (int i = 0; i < list2.size(); ++i) {
            Vec4 vec4 = list2.get(i);
            drawContext.getGL().glVertex3d(vec4.x, vec4.y, vec4.z);
        }
        drawContext.getGL().glEnd();
        drawContext.getGL().glEnable(2896);
    }

    private List<KMLCoord> interpolateCoords(List<KMLCoord> list) {
        if (list.size() < 2) {
            return list;
        }
        ArrayList<KMLCoord> arrayList = new ArrayList<KMLCoord>(list.size());
        arrayList.add(list.get(0));
        KMLCoord kMLCoord = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            KMLCoord kMLCoord2 = list.get(i);
            double d = this.distance(kMLCoord, kMLCoord2);
            if (d > this.tessDistance * 2.0) {
                double d2 = d / this.tessDistance;
                double d3 = (kMLCoord.getLon() - kMLCoord2.getLon()) / d2;
                double d4 = (kMLCoord.getLat() - kMLCoord2.getLat()) / d2;
                double d5 = (kMLCoord.getHeight() - list.get(i).getHeight()) / d2;
                int n = 1;
                while ((double)n < d2) {
                    KMLCoord kMLCoord3 = new KMLCoord(kMLCoord.getLon() - d3 * (double)n, kMLCoord.getLat() - d4 * (double)n, kMLCoord.getHeight() - d5 * (double)n);
                    arrayList.add(kMLCoord3);
                    ++n;
                }
            }
            arrayList.add(kMLCoord2);
            kMLCoord = kMLCoord2;
        }
        return arrayList;
    }

    private void drawPoly(DrawContext drawContext, KMLStyle kMLStyle, KMLPolygon kMLPolygon) {
        Vec4 vec4;
        Vec4 vec42;
        int n;
        Object object;
        Vec4 vec43;
        Object object2;
        List<KMLCoord> list = kMLPolygon.getOuter();
        List<Vec4> list2 = this.getExact3dPointsForCoords(drawContext, list, false);
        List<Vec4> list3 = this.getExactGroundPointsForCoords(drawContext, list, -1.0);
        List<Vec4> list4 = null;
        List<Vec4> list5 = null;
        if (kMLPolygon.getInner() != null) {
            object2 = kMLPolygon.getInner();
            list4 = this.getExact3dPointsForCoords(drawContext, (List<KMLCoord>)object2, false);
            list5 = this.getExactGroundPointsForCoords(drawContext, (List<KMLCoord>)object2, -1.0);
        }
        object2 = null;
        if (kMLStyle != null) {
            object2 = (KMLColor)kMLStyle.getPolyStyle("color");
        }
        if (object2 == null) {
            object2 = new KMLColor();
        }
        boolean bl = true;
        if (kMLStyle != null && kMLStyle.getPolyStyle("outline") != null) {
            bl = (Boolean)kMLStyle.getPolyStyle("outline");
        }
        float[] fArray = new float[]{((KMLColor)object2).red, ((KMLColor)object2).green, ((KMLColor)object2).blue, ((KMLColor)object2).alpha};
        float[] fArray2 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        drawContext.getGL().glMaterialfv(1028, 4610, fArray2, 0);
        drawContext.getGL().glMaterialfv(1028, 4609, fArray, 0);
        drawContext.getGL().glMaterialfv(1028, 4608, fArray, 0);
        drawContext.getGL().glMaterialf(1028, 5633, 50.0f);
        drawContext.getGL().glMaterialfv(1028, 5632, fArray, 0);
        GLUtessellator gLUtessellator = drawContext.getGLU().gluNewTess();
        PloygonTessCallback ploygonTessCallback = new PloygonTessCallback(drawContext);
        drawContext.getGLU().gluTessCallback(gLUtessellator, 100101, (GLUtessellatorCallback)ploygonTessCallback);
        drawContext.getGLU().gluTessCallback(gLUtessellator, 100100, (GLUtessellatorCallback)ploygonTessCallback);
        drawContext.getGLU().gluTessCallback(gLUtessellator, 100102, (GLUtessellatorCallback)ploygonTessCallback);
        drawContext.getGLU().gluTessCallback(gLUtessellator, 100103, (GLUtessellatorCallback)ploygonTessCallback);
        drawContext.getGL().glCullFace(1029);
        drawContext.getGL().glEnable(3042);
        drawContext.getGL().glBlendFunc(770, 771);
        drawContext.getGL().glEnable(2881);
        if (list2.size() > 2) {
            Vec4 vec44 = list2.get(1).subtract3(list2.get(0)).normalize3();
            vec43 = list2.get(2).subtract3(list2.get(0)).normalize3();
            object = vec44.cross3(vec43).normalize3();
            drawContext.getGL().glNormal3d(object.x, object.y, object.z);
        }
        drawContext.getGLU().gluTessBeginPolygon(gLUtessellator, null);
        drawContext.getGLU().gluTessBeginContour(gLUtessellator);
        for (n = 0; n < list2.size(); ++n) {
            vec43 = list2.get(n);
            object = vec43.toArray3(new double[3], 0);
            drawContext.getGLU().gluTessVertex(gLUtessellator, object, 0, object);
        }
        drawContext.getGLU().gluTessEndContour(gLUtessellator);
        if (list4 != null) {
            drawContext.getGLU().gluTessBeginContour(gLUtessellator);
            for (n = 0; n < list4.size(); ++n) {
                vec43 = list4.get(n);
                object = vec43.toArray3(new double[3], 0);
                drawContext.getGLU().gluTessVertex(gLUtessellator, object, 0, object);
            }
            drawContext.getGLU().gluTessEndContour(gLUtessellator);
        }
        drawContext.getGLU().gluTessEndPolygon(gLUtessellator);
        for (n = 0; n < list2.size(); ++n) {
            drawContext.getGL().glBegin(9);
            vec43 = list2.get(n);
            object = list2.get((n + 1) % list2.size());
            vec42 = list3.get((n + 1) % list3.size());
            vec4 = list3.get(n);
            Vec4 vec45 = object.subtract3(vec43).normalize3();
            Vec4 vec46 = vec42.subtract3(vec43).normalize3();
            Vec4 vec47 = vec46.cross3(vec45).normalize3();
            drawContext.getGL().glNormal3d(vec47.x, vec47.y, vec47.z);
            drawContext.getGL().glVertex3d(vec43.x, vec43.y, vec43.z);
            drawContext.getGL().glVertex3d(object.x, object.y, object.z);
            drawContext.getGL().glVertex3d(vec42.x, vec42.y, vec42.z);
            drawContext.getGL().glVertex3d(vec4.x, vec4.y, vec4.z);
            drawContext.getGL().glEnd();
        }
        if (list4 != null) {
            for (n = 0; n < list4.size(); ++n) {
                drawContext.getGL().glBegin(9);
                vec43 = list4.get(n);
                object = list4.get((n + 1) % list4.size());
                vec42 = list5.get((n + 1) % list5.size());
                vec4 = list5.get(n);
                drawContext.getGL().glVertex3d(vec43.x, vec43.y, vec43.z);
                drawContext.getGL().glVertex3d(object.x, object.y, object.z);
                drawContext.getGL().glVertex3d(vec42.x, vec42.y, vec42.z);
                drawContext.getGL().glVertex3d(vec4.x, vec4.y, vec4.z);
                drawContext.getGL().glEnd();
            }
        }
        drawContext.getGL().glDisable(3042);
        drawContext.getGL().glDisable(2881);
        if (bl) {
            drawContext.getGL().glColor3f(1.0f, 1.0f, 1.0f);
            drawContext.getGL().glLineWidth(1.5f);
            drawContext.getGL().glBegin(1);
            drawContext.getGL().glEnable(2848);
            for (n = 0; n < list2.size(); ++n) {
                vec43 = list2.get(n);
                object = list2.get((n + 1) % list2.size());
                vec42 = list3.get(n);
                drawContext.getGL().glVertex3d(vec43.x, vec43.y, vec43.z);
                drawContext.getGL().glVertex3d(object.x, object.y, object.z);
                drawContext.getGL().glVertex3d(vec43.x, vec43.y, vec43.z);
                drawContext.getGL().glVertex3d(vec42.x, vec42.y, vec42.z);
            }
            if (list4 != null) {
                for (n = 0; n < list4.size(); ++n) {
                    vec43 = list4.get(n);
                    object = list4.get((n + 1) % list4.size());
                    vec42 = list5.get(n);
                    drawContext.getGL().glVertex3d(vec43.x, vec43.y, vec43.z);
                    drawContext.getGL().glVertex3d(object.x, object.y, object.z);
                    drawContext.getGL().glVertex3d(vec43.x, vec43.y, vec43.z);
                    drawContext.getGL().glVertex3d(vec42.x, vec42.y, vec42.z);
                }
            }
            drawContext.getGL().glEnd();
            drawContext.getGL().glDisable(2848);
        }
        drawContext.getGL().glEnable(2896);
    }

    private List<Vec4> getExactGroundPointsForCoords(DrawContext drawContext, List<KMLCoord> list, double d) {
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>(list.size());
        for (KMLCoord kMLCoord : list) {
            Vec4 vec4 = this.getExact3dPointForLocation(drawContext, kMLCoord.getLat(), kMLCoord.getLon(), d);
            arrayList.add(vec4);
        }
        return arrayList;
    }

    private List<Vec4> get3dPointsForCoords(DrawContext drawContext, List<KMLCoord> list, boolean bl) {
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>(list.size());
        if (bl) {
            for (KMLCoord kMLCoord : list) {
                Angle angle = Angle.fromDegrees((double)kMLCoord.getLat());
                Angle angle2 = Angle.fromDegrees((double)kMLCoord.getLon());
                Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(angle, angle2, kMLCoord.getHeight());
                arrayList.add(vec4);
            }
        } else {
            for (KMLCoord kMLCoord : list) {
                Vec4 vec4 = this.computeSurfacePoint(drawContext, kMLCoord, 1.0);
                arrayList.add(vec4);
            }
        }
        return arrayList;
    }

    private Vec4 computeSurfacePoint(DrawContext drawContext, KMLCoord kMLCoord, double d) {
        Angle angle = Angle.fromDegrees((double)kMLCoord.getLat());
        Angle angle2 = Angle.fromDegrees((double)kMLCoord.getLon());
        Vec4 vec4 = drawContext.getSurfaceGeometry().getSurfacePoint(angle, angle2, d);
        if (vec4 != null) {
            return vec4;
        }
        return drawContext.getGlobe().computePointFromPosition(angle, angle2, d);
    }

    private List<Vec4> getExact3dPointsForCoords(DrawContext drawContext, List<KMLCoord> list, boolean bl) {
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>(list.size());
        if (bl) {
            for (KMLCoord kMLCoord : list) {
                Angle angle = Angle.fromDegrees((double)kMLCoord.getLat());
                Angle angle2 = Angle.fromDegrees((double)kMLCoord.getLon());
                Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(angle, angle2, kMLCoord.getHeight());
                arrayList.add(vec4);
            }
        } else {
            for (KMLCoord kMLCoord : list) {
                Vec4 vec4 = this.getExact3dPointForLocation(drawContext, kMLCoord.getLat(), kMLCoord.getLon(), Math.max(kMLCoord.getHeight(), this.fudgeFactor));
                arrayList.add(vec4);
            }
        }
        return arrayList;
    }

    private Vec4 getExact3dPointForLocation(DrawContext drawContext, double d, double d2, double d3) {
        Double d4 = null;
        Angle angle = Angle.fromDegrees((double)d);
        Angle angle2 = Angle.fromDegrees((double)d2);
        while (d4 == null) {
            d4 = drawContext.getGlobe().getBestElevation(angle, angle2);
            if (d4 != null) continue;
            System.out.print(".");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
            }
        }
        return drawContext.getGlobe().computePointFromPosition(angle, angle2, d4 + d3);
    }

    private double sizeInPixels(DrawContext drawContext, Sector sector) {
        return Math.max(this.distanceInPixels(drawContext, sector.getMinLatitude(), sector.getMinLongitude(), sector.getMaxLatitude(), sector.getMaxLongitude()), this.distanceInPixels(drawContext, sector.getMinLatitude(), sector.getMaxLongitude(), sector.getMaxLatitude(), sector.getMinLongitude()));
    }

    private double distanceInPixels(DrawContext drawContext, Angle angle, Angle angle2, Angle angle3, Angle angle4) {
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        int[] nArray = new int[4];
        drawContext.getGL().glGetDoublev(2982, dArray, 0);
        drawContext.getGL().glGetDoublev(2983, dArray2, 0);
        drawContext.getGL().glGetIntegerv(2978, nArray, 0);
        Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(new Position(angle, angle2, 0.0));
        Vec4 vec42 = drawContext.getGlobe().computePointFromPosition(new Position(angle3, angle4, 0.0));
        double[] dArray3 = new double[4];
        double[] dArray4 = new double[4];
        drawContext.getGLU().gluProject(vec4.x, vec4.y, vec4.z, dArray, 0, dArray2, 0, nArray, 0, dArray3, 0);
        drawContext.getGLU().gluProject(vec42.x, vec42.y, vec42.z, dArray, 0, dArray2, 0, nArray, 0, dArray4, 0);
        double d = dArray3[0];
        double d2 = dArray3[1];
        double d3 = dArray4[0];
        double d4 = dArray4[1];
        return Math.sqrt((d - d3) * (d - d3) + (d2 - d4) * (d2 - d4));
    }

    private double distanceInPixels(DrawContext drawContext, Position position, Point point) {
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        int[] nArray = new int[4];
        drawContext.getGL().glGetDoublev(2982, dArray, 0);
        drawContext.getGL().glGetDoublev(2983, dArray2, 0);
        drawContext.getGL().glGetIntegerv(2978, nArray, 0);
        Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(position);
        double[] dArray3 = new double[4];
        drawContext.getGLU().gluProject(vec4.x, vec4.y, vec4.z, dArray, 0, dArray2, 0, nArray, 0, dArray3, 0);
        double d = dArray3[0];
        double d2 = dArray3[1];
        double d3 = point.x;
        double d4 = point.y;
        return Math.sqrt((d - d3) * (d - d3) + (d2 - d4) * (d2 - d4));
    }

    private double distance(KMLCoord kMLCoord, KMLCoord kMLCoord2) {
        LatLon latLon = LatLon.fromDegrees((double)kMLCoord.getLat(), (double)kMLCoord.getLon());
        LatLon latLon2 = LatLon.fromDegrees((double)kMLCoord2.getLat(), (double)kMLCoord2.getLon());
        return LatLon.ellipsoidalDistance((LatLon)latLon, (LatLon)latLon2, (double)6378137.0, (double)6356752.3);
    }

    static class PloygonTessCallback
    extends GLUtessellatorCallbackAdapter {
        DrawContext dc;

        PloygonTessCallback(DrawContext drawContext) {
            this.dc = drawContext;
        }

        public void begin(int n) {
            this.dc.getGL().glBegin(n);
        }

        public void end() {
            this.dc.getGL().glEnd();
        }

        public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
            double[] dArray2 = new double[6];
            dArray2[0] = dArray[0];
            dArray2[1] = dArray[1];
            dArray2[2] = dArray[2];
            for (int i = 3; i < 6; ++i) {
                dArray2[i] = (double)fArray[0] * ((double[])objectArray[0])[i] + (double)fArray[1] * ((double[])objectArray[1])[i] + (double)fArray[2] * ((double[])objectArray[2])[i] + (double)fArray[3] * ((double[])objectArray[3])[i];
            }
            objectArray2[0] = dArray2;
        }

        public void vertex(Object object) {
            double[] dArray = (double[])object;
            this.dc.getGL().glVertex3dv(dArray, 0);
        }

        public void error(int n) {
            System.out.println("Error: " + n);
        }
    }
}

