/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.wms;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.BasicTiledImageLayer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileUrlBuilder;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.wms.BoundingBox;
import gov.nasa.worldwind.wms.Capabilities;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class WMSTiledImageLayer
extends BasicTiledImageLayer {
    private AVList creationParams;
    private static final String[] formatOrderPreference = new String[]{"image/dds", "image/png", "image/jpeg"};

    public static AVList xmlStateToParams(String string) {
        Double d;
        Integer n;
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        AVListImpl aVListImpl = new AVListImpl();
        String string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.ImageFormat");
        if (string4 != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.ImageFormat", string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.DataCacheNameKey")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.ServiceURLKey")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.Title")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.Title", string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.DatasetNameKey")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.FormatSuffixKey")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.LayerNames")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.LayerNames", string4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("gov.nasa.worldwind.avkey.StyleNames")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.StyleNames", string4);
        }
        if ((n = restorableSupport.getStateValueAsInteger("gov.nasa.worldwind.avkey.NumEmptyLevels")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", n);
        }
        if ((n = restorableSupport.getStateValueAsInteger("gov.nasa.worldwind.avkey.NumLevels")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", n);
        }
        if ((n = restorableSupport.getStateValueAsInteger("gov.nasa.worldwind.avkey.TileWidthKey")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.TileWidthKey", n);
        }
        if ((n = restorableSupport.getStateValueAsInteger("gov.nasa.worldwind.avkey.TileHeightKey")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.TileHeightKey", n);
        }
        if ((d = restorableSupport.getStateValueAsDouble("gov.nasa.worldwind.avkey.ExpiryTime")) != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.ExpiryTime", Math.round(d));
        }
        Double d2 = restorableSupport.getStateValueAsDouble("gov.nasa.worldwind.avkey.LevelZeroTileDelta.Latitude");
        Double d3 = restorableSupport.getStateValueAsDouble("gov.nasa.worldwind.avkey.LevelZeroTileDelta.Longitude");
        if (d2 != null && d3 != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", LatLon.fromDegrees(d2, d3));
        }
        Double d4 = restorableSupport.getStateValueAsDouble("gov.nasa.worldwind.avKey.Sector.MinLatitude");
        Double d5 = restorableSupport.getStateValueAsDouble("gov.nasa.worldwind.avKey.Sector.MinLongitude");
        Double d6 = restorableSupport.getStateValueAsDouble("gov.nasa.worldwind.avKey.Sector.MaxLatitude");
        Double d7 = restorableSupport.getStateValueAsDouble("gov.nasa.worldwind.avKey.Sector.MaxLongitude");
        if (d4 != null && d5 != null && d6 != null && d7 != null) {
            aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", Sector.fromDegrees(d4, d6, d5, d7));
        }
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder(restorableSupport.getStateValueAsString("wms.Version"), aVListImpl));
        return aVListImpl;
    }

    public static WMSTiledImageLayer fromRestorableState(String string) {
        return new WMSTiledImageLayer(string);
    }

    public WMSTiledImageLayer(String string) {
        this(WMSTiledImageLayer.xmlStateToParams(string));
        RestorableSupport restorableSupport;
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string2 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2, exception);
        }
        RestorableSupport.StateObject stateObject = restorableSupport.getStateObject("avlist");
        if (stateObject != null) {
            RestorableSupport.StateObject[] stateObjectArray;
            for (RestorableSupport.StateObject stateObject2 : stateObjectArray = restorableSupport.getAllStateObjects(stateObject, "")) {
                if (stateObject2 == null) continue;
                this.setValue(stateObject2.getName(), stateObject2.getValue());
            }
        }
    }

    public WMSTiledImageLayer(AVList aVList) {
        super(aVList);
        this.creationParams = aVList.copy();
    }

    public WMSTiledImageLayer(Capabilities capabilities, AVList aVList) {
        super(WMSTiledImageLayer.initParams(capabilities, aVList));
        this.setUseTransparentTextures(true);
        this.setName(WMSTiledImageLayer.makeTitle(capabilities, aVList.getStringValue("gov.nasa.worldwind.avkey.LayerNames"), aVList.getStringValue("gov.nasa.worldwind.avkey.StyleNames")));
        this.creationParams = aVList.copy();
    }

    private static AVList initParams(Capabilities capabilities, AVList aVList) {
        if (capabilities == null) {
            String string = Logging.getMessage("nullValue.WMSCapabilities");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.LayerConfigParams");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = aVList.getStringValue("gov.nasa.worldwind.avkey.LayerNames");
        if (string == null || string.length() == 0) {
            String string2 = Logging.getMessage("nullValue.WMSLayerNames");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String[] stringArray = string.split(",");
        if (stringArray == null || stringArray.length == 0) {
            String string3 = Logging.getMessage("nullValue.WMSLayerNames");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        for (String object2 : stringArray) {
            if (capabilities.getLayerByName(object2) != null) continue;
            String string2 = Logging.getMessage("WMS.LayerNameMissing", object2);
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        aVList.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string);
        Object object3 = capabilities.getGetMapRequestGetURL();
        object3 = WMSTiledImageLayer.fixGetMapString((String)object3);
        if (aVList.getValue("gov.nasa.worldwind.avkey.ServiceURLKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", object3);
        }
        if ((object3 = aVList.getStringValue("gov.nasa.worldwind.avkey.ServiceURLKey")) == null || ((String)object3).length() == 0) {
            Logging.logger().severe("WMS.RequestMapURLMissing");
            throw new IllegalArgumentException(Logging.getMessage("WMS.RequestMapURLMissing"));
        }
        String string5 = aVList.getStringValue("gov.nasa.worldwind.avkey.StyleNames");
        if (aVList.getValue("gov.nasa.worldwind.avkey.DataCacheNameKey") == null) {
            try {
                URI uRI = new URI((String)object3);
                String string3 = WWIO.formPath(uRI.getAuthority(), uRI.getPath(), string, string5);
                aVList.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", string3);
            }
            catch (URISyntaxException uRISyntaxException) {
                String string4 = Logging.getMessage("WMS.RequestMapURLBad", (String)object3);
                Logging.logger().severe(string4);
                throw new IllegalArgumentException(string4);
            }
        }
        if (aVList.getStringValue("gov.nasa.worldwind.avkey.ImageFormat") == null) {
            String string6 = WMSTiledImageLayer.chooseImageFormat(capabilities);
            aVList.setValue("gov.nasa.worldwind.avkey.ImageFormat", string6);
        }
        if (aVList.getStringValue("gov.nasa.worldwind.avkey.ImageFormat") == null) {
            Logging.logger().severe("WMS.NoImageFormats");
            throw new IllegalArgumentException(Logging.getMessage("WMS.NoImageFormats"));
        }
        Sector sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        if (sector == null) {
            for (String string6 : stringArray) {
                BoundingBox boundingBox = capabilities.getLayerGeographicBoundingBox(capabilities.getLayerByName(string6));
                if (boundingBox == null) {
                    Logging.logger().log(Level.SEVERE, "WMS.NoGeographicBoundingBoxForLayer", string6);
                    continue;
                }
                sector = Sector.union(sector, Sector.fromDegrees(WMSTiledImageLayer.clamp(boundingBox.getMiny(), -90.0, 90.0), WMSTiledImageLayer.clamp(boundingBox.getMaxy(), -90.0, 90.0), WMSTiledImageLayer.clamp(boundingBox.getMinx(), -180.0, 180.0), WMSTiledImageLayer.clamp(boundingBox.getMaxx(), -180.0, 180.0)));
            }
            if (sector == null) {
                Logging.logger().severe("WMS.NoGeographicBoundingBox");
                throw new IllegalArgumentException(Logging.getMessage("WMS.NoGeographicBoundingBox"));
            }
            aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta") == null) {
            Angle angle = Angle.fromDegrees(36.0);
            aVList.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon(angle, angle));
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.TileWidthKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 512);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.TileHeightKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 512);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".dds");
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.NumLevels") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumLevels", 14);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.NumEmptyLevels") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        }
        aVList.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder(capabilities.getVersion(), aVList));
        return aVList;
    }

    private static double clamp(double d, double d2, double d3) {
        return d < d2 ? d2 : (d > d3 ? d3 : d);
    }

    private static String fixGetMapString(String string) {
        int n = (string = string.trim()).indexOf("?");
        if (n < 0) {
            string = string + "?";
        } else if (n != string.length() - 1 && string.lastIndexOf("&") != string.length() - 1) {
            string = string + "&";
        }
        return string;
    }

    private static String makeTitle(Capabilities capabilities, String string, String string2) {
        String[] stringArray = string.split(",");
        String[] stringArray2 = string2 != null ? string2.split(",") : null;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            Element element;
            String string4;
            Element element2;
            String string5;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append((string5 = capabilities.getLayerTitle(element2 = capabilities.getLayerByName(string4 = stringArray[i]))) != null ? string5 : string4);
            if (stringArray2 == null || stringArray2.length <= i || (element = capabilities.getLayerStyleByName(element2, string3 = stringArray2[i])) == null) continue;
            stringBuilder.append(" : ");
            String string6 = capabilities.getStyleTitle(element2, element);
            stringBuilder.append(string6 != null ? string6 : string3);
        }
        return stringBuilder.toString();
    }

    private static String chooseImageFormat(Capabilities capabilities) {
        String[] stringArray = capabilities.getGetMapFormats();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        for (String string : formatOrderPreference) {
            for (String string2 : stringArray) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return string2;
            }
        }
        return stringArray[0];
    }

    private RestorableSupport makeRestorableState(AVList aVList) {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        if (restorableSupport == null) {
            return null;
        }
        for (Map.Entry<String, Object> entry : aVList.getEntries()) {
            if (entry.getValue() instanceof LatLon) {
                restorableSupport.addStateValueAsDouble(entry.getKey() + ".Latitude", ((LatLon)entry.getValue()).getLatitude().degrees);
                restorableSupport.addStateValueAsDouble((String)entry.getKey() + ".Longitude", ((LatLon)entry.getValue()).getLongitude().degrees);
                continue;
            }
            if (entry.getValue() instanceof Sector) {
                restorableSupport.addStateValueAsDouble(entry.getKey() + ".MinLatitude", ((Sector)entry.getValue()).getMinLatitude().degrees);
                restorableSupport.addStateValueAsDouble((String)entry.getKey() + ".MaxLatitude", ((Sector)entry.getValue()).getMaxLatitude().degrees);
                restorableSupport.addStateValueAsDouble((String)entry.getKey() + ".MinLongitude", ((Sector)entry.getValue()).getMinLongitude().degrees);
                restorableSupport.addStateValueAsDouble((String)entry.getKey() + ".MaxLongitude", ((Sector)entry.getValue()).getMaxLongitude().degrees);
                continue;
            }
            if (entry.getValue() instanceof URLBuilder) {
                restorableSupport.addStateValueAsString("wms.Version", ((URLBuilder)entry.getValue()).wmsVersion);
                restorableSupport.addStateValueAsString("wms.Crs", ((URLBuilder)entry.getValue()).crs);
                continue;
            }
            restorableSupport.addStateValueAsString(entry.getKey(), entry.getValue().toString());
        }
        restorableSupport.addStateValueAsBoolean("wms.UseTransparentTextures", this.isUseTransparentTextures());
        restorableSupport.addStateValueAsString("wms.LayerName", this.getName());
        restorableSupport.addStateValueAsBoolean("wms.LayerEnabled", this.isEnabled());
        RestorableSupport.StateObject stateObject = restorableSupport.addStateObject("avlist");
        for (Map.Entry entry : this.getEntries()) {
            if (entry.getValue().equals("gov.nasa.worldwind.avkey.ConstructionParameters")) continue;
            restorableSupport.addStateValueAsString(stateObject, (String)entry.getKey(), entry.getValue().toString());
        }
        return restorableSupport;
    }

    public String getRestorableState() {
        return this.makeRestorableState(this.creationParams).getStateAsXml();
    }

    public void restoreState(String string) {
        String string2 = Logging.getMessage("RestorableSupport.RestoreRequiresConstructor");
        Logging.logger().severe(string2);
        throw new UnsupportedOperationException(string2);
    }

    private static class URLBuilder
    implements TileUrlBuilder {
        private static final String MAX_VERSION = "1.3.0";
        private final String layerNames;
        private final String styleNames;
        private final String imageFormat;
        private final String wmsVersion;
        private final String crs;
        public String URLTemplate = null;

        private URLBuilder(String string, AVList aVList) {
            this.layerNames = aVList.getStringValue("gov.nasa.worldwind.avkey.LayerNames");
            this.styleNames = aVList.getStringValue("gov.nasa.worldwind.avkey.StyleNames");
            this.imageFormat = aVList.getStringValue("gov.nasa.worldwind.avkey.ImageFormat");
            if (string == null || string.compareTo(MAX_VERSION) >= 0) {
                this.wmsVersion = MAX_VERSION;
                this.crs = "&crs=CRS:84";
            } else {
                this.wmsVersion = string;
                this.crs = "&srs=EPSG:4326";
            }
        }

        public URL getURL(Tile tile, String string) throws MalformedURLException {
            StringBuffer stringBuffer;
            if (this.URLTemplate == null) {
                stringBuffer = new StringBuffer(tile.getLevel().getService());
                if (!stringBuffer.toString().toLowerCase().contains("service=wms")) {
                    stringBuffer.append("service=WMS");
                }
                stringBuffer.append("&request=GetMap");
                stringBuffer.append("&version=");
                stringBuffer.append(this.wmsVersion);
                stringBuffer.append(this.crs);
                stringBuffer.append("&layers=");
                stringBuffer.append(this.layerNames);
                stringBuffer.append("&styles=");
                stringBuffer.append(this.styleNames != null ? this.styleNames : "default");
                stringBuffer.append("&width=");
                stringBuffer.append(tile.getLevel().getTileWidth());
                stringBuffer.append("&height=");
                stringBuffer.append(tile.getLevel().getTileHeight());
                stringBuffer.append("&format=");
                if (string == null) {
                    stringBuffer.append(this.imageFormat);
                } else {
                    stringBuffer.append(string);
                }
                stringBuffer.append("&transparent=TRUE");
                stringBuffer.append("&bgcolor=0x000000");
                this.URLTemplate = stringBuffer.toString();
            } else {
                stringBuffer = new StringBuffer(this.URLTemplate);
            }
            Sector sector = tile.getSector();
            stringBuffer.append("&bbox=");
            stringBuffer.append(sector.getMinLongitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMinLatitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMaxLongitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMaxLatitude().getDegrees());
            stringBuffer.append("&");
            return new URL(stringBuffer.toString().replace(" ", "%20"));
        }
    }
}

