/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.wms;

import gov.nasa.worldwind.util.Logging;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.TreeMap;

public abstract class Request {
    private URI uri = null;
    private TreeMap<String, String> queryParams = new TreeMap();

    public Request() {
        this.initialize();
    }

    public Request(URI uRI) throws URISyntaxException {
        if (uRI != null) {
            try {
                this.setUri(uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
                Logging.logger().fine(Logging.getMessage("generic.URIInvalid", uRI.toString()));
                throw uRISyntaxException;
            }
        }
        this.initialize();
    }

    public Request(Request request) throws URISyntaxException {
        request.copyParamsTo(this);
        this.setUri(request.getUri());
    }

    protected void initialize() {
        this.queryParams.put("SERVICE", "WMS");
        this.queryParams.put("EXCEPTIONS", "application/vnd.ogc.se_xml");
    }

    private void copyParamsTo(Request request) {
        for (Map.Entry<String, String> entry : this.queryParams.entrySet()) {
            request.setParam(entry.getKey(), entry.getValue());
        }
    }

    protected void setUri(URI uRI) throws URISyntaxException {
        try {
            this.uri = new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), uRI.getPath(), this.buildQueryString(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            String string = Logging.getMessage("generic.URIInvalid", uRI.toString());
            Logging.logger().fine(string);
            throw uRISyntaxException;
        }
    }

    public String getRequestName() {
        return this.getParam("REQUEST");
    }

    public String getVersion() {
        return this.getParam("VERSION");
    }

    public void setVersion(String string) {
        this.setParam("VERSION", string);
    }

    public void setParam(String string, String string2) {
        if (string != null) {
            this.queryParams.put(string, string2);
        }
    }

    public String getParam(String string) {
        return string != null ? this.queryParams.get(string) : null;
    }

    public URI getUri() throws URISyntaxException {
        if (this.uri == null) {
            return null;
        }
        try {
            return new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), this.uri.getPath(), this.buildQueryString(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            String string = Logging.getMessage("generic.URIInvalid", this.uri.toString());
            Logging.logger().fine(string);
            throw uRISyntaxException;
        }
    }

    private String buildQueryString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, String> entry : this.queryParams.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            stringBuffer.append((Object)entry.getKey());
            stringBuffer.append("=");
            stringBuffer.append((Object)entry.getValue());
            stringBuffer.append("&");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        String string = "Error converting wms-request URI to string.";
        try {
            URI uRI = this.getUri();
            return uRI != null ? uRI.toString() : string;
        }
        catch (URISyntaxException uRISyntaxException) {
            return string;
        }
    }
}

