/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import java.awt.Rectangle;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class ViewSupport {
    private final GLU glu = new GLU();

    public void loadGLViewState(DrawContext drawContext, Matrix matrix, Matrix matrix2) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (matrix == null) {
            Logging.logger().fine("nullValue.ModelViewIsNull");
        }
        if (matrix2 == null) {
            Logging.logger().fine("nullValue.ProjectionIsNull");
        }
        double[] dArray = new double[16];
        GL gL = drawContext.getGL();
        int[] nArray = new int[1];
        gL.glGetIntegerv(2976, nArray, 0);
        gL.glMatrixMode(5888);
        if (matrix != null) {
            matrix.toArray(dArray, 0, false);
            gL.glLoadMatrixd(dArray, 0);
        } else {
            gL.glLoadIdentity();
        }
        gL.glMatrixMode(5889);
        if (matrix2 != null) {
            matrix2.toArray(dArray, 0, false);
            gL.glLoadMatrixd(dArray, 0);
        } else {
            gL.glLoadIdentity();
        }
        gL.glMatrixMode(nArray[0]);
    }

    public Vec4 project(Vec4 vec4, Matrix matrix, Matrix matrix2, Rectangle rectangle) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrix == null || matrix2 == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.RectangleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        matrix.toArray(dArray, 0, false);
        matrix2.toArray(dArray2, 0, false);
        int[] nArray = new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
        double[] dArray3 = new double[3];
        if (!this.glu.gluProject(vec4.x, vec4.y, vec4.z, dArray, 0, dArray2, 0, nArray, 0, dArray3, 0)) {
            return null;
        }
        return Vec4.fromArray3(dArray3, 0);
    }

    public Vec4 unProject(Vec4 vec4, Matrix matrix, Matrix matrix2, Rectangle rectangle) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrix == null || matrix2 == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.RectangleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        matrix.toArray(dArray, 0, false);
        matrix2.toArray(dArray2, 0, false);
        int[] nArray = new int[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height};
        double[] dArray3 = new double[3];
        if (!this.glu.gluUnProject(vec4.x, vec4.y, vec4.z, dArray, 0, dArray2, 0, nArray, 0, dArray3, 0)) {
            return null;
        }
        return Vec4.fromArray3(dArray3, 0);
    }

    public Line computeRayFromScreenPoint(double d, double d2, Matrix matrix, Matrix matrix2, Rectangle rectangle) {
        if (matrix == null || matrix2 == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.RectangleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix3 = matrix.getInverse();
        if (matrix3 == null) {
            return null;
        }
        Vec4 vec4 = Vec4.UNIT_W.transformBy4(matrix3);
        if (vec4 == null) {
            return null;
        }
        double d3 = (double)rectangle.height - d2 - 1.0;
        Vec4 vec42 = this.unProject(new Vec4(d, d3, 0.0, 0.0), matrix, matrix2, rectangle);
        Vec4 vec43 = this.unProject(new Vec4(d, d3, 1.0, 0.0), matrix, matrix2, rectangle);
        if (vec42 == null || vec43 == null) {
            return null;
        }
        return new Line(vec4, vec43.subtract3(vec42).normalize3());
    }

    public double computePixelSizeAtDistance(double d, Angle angle, Rectangle rectangle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.RectangleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = rectangle.getWidth() > 0.0 ? 2.0 * angle.tanHalfAngle() / rectangle.getWidth() : 0.0;
        return Math.abs(d) * d2;
    }

    public double computeHorizonDistance(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = globe.getMaximumRadius();
        return Math.sqrt(d * (2.0 * d2 + d));
    }

    public double computeElevationAboveSurface(DrawContext drawContext, Position position) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Globe globe = drawContext.getGlobe();
        if (globe == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = null;
        Vec4 vec4 = drawContext.getPointOnGlobe(position.getLatitude(), position.getLongitude());
        if (vec4 != null) {
            position2 = globe.computePositionFromPoint(vec4);
        }
        if (position2 == null) {
            position2 = new Position(position.getLatLon(), globe.getElevation(position.getLatitude(), position.getLongitude()) * drawContext.getVerticalExaggeration());
        }
        return position.getElevation() - position2.getElevation();
    }
}

