/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.OrbitView;
import gov.nasa.worldwind.view.OrbitViewInterpolator;
import java.util.Date;

public class ScheduledOrbitViewInterpolator
implements OrbitViewInterpolator {
    private long startTime = -1L;
    private final long length;

    public ScheduledOrbitViewInterpolator(long l) {
        this(null, l);
    }

    public ScheduledOrbitViewInterpolator(Date date, long l) {
        if (l < 0L) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", l);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (date != null) {
            this.startTime = date.getTime();
        }
        this.length = l;
    }

    public ScheduledOrbitViewInterpolator(Date date, Date date2) {
        if (date == null || date2 == null) {
            String string = Logging.getMessage("nullValue.DateIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (date.after(date2)) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", date);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.startTime = date.getTime();
        this.length = date2.getTime() - date.getTime();
    }

    public final double nextInterpolant(OrbitView orbitView) {
        if (orbitView == null) {
            String string = Logging.getMessage("nullValue.OrbitViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        long l = System.currentTimeMillis();
        if (this.startTime < 0L) {
            this.startTime = l;
        }
        if (l < this.startTime) {
            return 0.0;
        }
        long l2 = l - this.startTime;
        double d = (double)l2 / (double)this.length;
        return ScheduledOrbitViewInterpolator.clampDouble(d, 0.0, 1.0);
    }

    public final OrbitViewInterpolator coalesceWith(OrbitView orbitView, OrbitViewInterpolator orbitViewInterpolator) {
        if (orbitView == null) {
            String string = Logging.getMessage("nullValue.OrbitViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (orbitViewInterpolator == null) {
            String string = Logging.getMessage("nullValue.OrbitViewInterpolatorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this;
    }

    private static double clampDouble(double d, double d2, double d3) {
        return d < d2 ? d2 : (d > d3 ? d3 : d);
    }
}

