/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.OrbitViewModel;

class FlatOrbitViewModel
implements OrbitViewModel {
    FlatOrbitViewModel() {
    }

    public Matrix computeTransformMatrix(Globe globe, Position position, Angle angle, Angle angle2, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = Matrix.IDENTITY;
        matrix = matrix.multiply(Matrix.fromTranslation(0.0, 0.0, -d));
        matrix = matrix.multiply(Matrix.fromRotationX(angle2.multiply(-1.0)));
        matrix = matrix.multiply(Matrix.fromRotationZ(angle));
        matrix = matrix.multiply(FlatOrbitViewModel.computeCenterTransform(globe, position));
        return matrix;
    }

    public OrbitViewModel.ModelCoordinates computeModelCoordinates(Globe globe, Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null || vec42 == null || vec43 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = Matrix.fromLookAt(vec4, vec42, vec43);
        return this.computeModelCoordinates(globe, matrix, vec42);
    }

    public OrbitViewModel.ModelCoordinates computeModelCoordinates(Globe globe, Matrix matrix, Vec4 vec4) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position = globe.computePositionFromPoint(vec4);
        Matrix matrix2 = FlatOrbitViewModel.computeCenterTransform(globe, position);
        Matrix matrix3 = matrix2.getInverse();
        if (matrix3 == null) {
            String string = Logging.getMessage("generic.NoninvertibleMatrix");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Matrix matrix4 = matrix.multiply(matrix3);
        Angle angle = matrix4.getRotationZ();
        Angle angle2 = matrix4.getRotationX();
        Vec4 vec42 = matrix4.getTranslation();
        if (angle != null && angle2 != null && vec42 != null) {
            return new BasicModelCoordinates(position, angle, angle2.multiply(-1.0), vec42.getLength3());
        }
        return null;
    }

    private static Matrix computeCenterTransform(Globe globe, Position position) {
        Matrix matrix = Matrix.IDENTITY;
        if (globe != null && position != null) {
            Vec4 vec4 = globe.computePointFromPosition(position);
            Vec4 vec42 = globe.getCenter();
            matrix = matrix.multiply(Matrix.fromTranslation(-vec4.x, -vec4.y, -vec4.z));
            matrix = matrix.multiply(Matrix.fromTranslation(-vec42.x, -vec42.y, -vec42.z));
        }
        return matrix;
    }

    private static class BasicModelCoordinates
    implements OrbitViewModel.ModelCoordinates {
        private final Position center;
        private final Angle heading;
        private final Angle pitch;
        private final double zoom;

        private BasicModelCoordinates(Position position, Angle angle, Angle angle2, double d) {
            if (position == null) {
                String string = Logging.getMessage("nullValue.PositionIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (angle == null || angle2 == null) {
                String string = Logging.getMessage("nullValue.AngleIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.center = position;
            this.heading = angle;
            this.pitch = angle2;
            this.zoom = d;
        }

        public Position getCenterPosition() {
            return this.center;
        }

        public Angle getHeading() {
            return this.heading;
        }

        public Angle getPitch() {
            return this.pitch;
        }

        public double getZoom() {
            return this.zoom;
        }
    }
}

