/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.ViewStateIterator;
import gov.nasa.worldwind.util.Logging;
import java.util.logging.Level;

public abstract class AbstractViewStateIterator
implements ViewStateIterator {
    private long startTime = -1L;
    private long length;
    private boolean smoothed = true;
    private boolean hasNext = true;

    public AbstractViewStateIterator(long l) {
        this(-1L, l);
    }

    public AbstractViewStateIterator(long l, long l2) {
        if (l2 < 0L) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", l2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.startTime = l;
        this.length = l2;
    }

    public boolean isSmoothed() {
        return this.smoothed;
    }

    public void setSmoothed(boolean bl) {
        this.smoothed = bl;
    }

    public ViewStateIterator coalesceWith(View view, ViewStateIterator viewStateIterator) {
        return this;
    }

    public boolean hasNextState(View view) {
        return this.hasNext;
    }

    public void nextState(View view) {
        if (view == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        long l = System.currentTimeMillis();
        if (this.startTime < 0L) {
            this.startTime = l;
        }
        if (!this.hasStarted(l)) {
            return;
        }
        if (!this.hasNextIteration(l)) {
            this.stopNextIteration();
        }
        double d = this.computeInterpolant(l);
        if (this.smoothed) {
            d = AbstractViewStateIterator.smoothValue(d);
        }
        try {
            this.doNextState(d, view);
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, "generic.ExceptionWhileRunningViewStateIterator", exception);
            this.stopNextIteration();
        }
    }

    protected abstract void doNextState(double var1, View var3);

    protected final void stopNextIteration() {
        this.hasNext = false;
    }

    private boolean hasStarted(long l) {
        return this.startTime < l;
    }

    private boolean hasNextIteration(long l) {
        return l < this.startTime + this.length;
    }

    private double computeInterpolant(long l) {
        if (this.startTime < 0L) {
            this.startTime = l;
        }
        if (l < this.startTime) {
            return 0.0;
        }
        long l2 = l - this.startTime;
        double d = (double)l2 / (double)this.length;
        return AbstractViewStateIterator.clampValue(d, 0.0, 1.0);
    }

    private static double clampValue(double d, double d2, double d3) {
        return d < d2 ? d2 : (d > d3 ? d3 : d);
    }

    private static double smoothValue(double d) {
        return d * d * (3.0 - 2.0 * d);
    }
}

