/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.wizard;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.wizard.Wizard;
import gov.nasa.worldwind.util.wizard.WizardModel;
import gov.nasa.worldwind.util.wizard.WizardPanelDescriptor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class WizardController
implements ActionListener {
    private Wizard wizard;

    public WizardController(Wizard wizard) {
        if (wizard == null) {
            String string = "Wizard is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wizard = wizard;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null && actionEvent.getActionCommand() != null) {
            String string = actionEvent.getActionCommand();
            if (string.equals("wizard.CancelButtonActionCommand")) {
                this.cancelButtonPressed();
            } else if (string.equals("wizard.BackButtonActionCommand")) {
                this.backButtonPressed();
            } else if (string.equals("wizard.NextButtonActionCommand")) {
                this.nextButtonPressed();
            } else if (string.equals("wizard.DialogCloseActionCommand")) {
                this.dialogClosed();
            }
        }
    }

    private void backButtonPressed() {
        WizardModel wizardModel = this.wizard.getModel();
        if (wizardModel != null && wizardModel.getCurrentPanel() != null) {
            WizardPanelDescriptor wizardPanelDescriptor = wizardModel.getCurrentPanel();
            Object object = wizardPanelDescriptor.getBackPanelDescriptor();
            this.wizard.setCurrentPanelDescriptor(object);
        }
    }

    private void nextButtonPressed() {
        WizardModel wizardModel = this.wizard.getModel();
        if (wizardModel != null && wizardModel.getCurrentPanel() != null) {
            WizardPanelDescriptor wizardPanelDescriptor = wizardModel.getCurrentPanel();
            Object object = wizardPanelDescriptor.getNextPanelDescriptor();
            if (object != null && object instanceof Wizard.FinishIdentifier) {
                this.wizard.close(0);
            } else {
                this.wizard.setCurrentPanelDescriptor(object);
            }
        }
    }

    private void cancelButtonPressed() {
        this.wizard.close(1);
    }

    private void dialogClosed() {
        this.wizard.close(-1);
    }

    void resetButtonsToPanelRules() {
        WizardModel wizardModel = this.wizard.getModel();
        if (wizardModel != null) {
            wizardModel.setCancelButtonText("Cancel");
            wizardModel.setCancelButtonIcon(null);
            wizardModel.setBackButtonText("<Back");
            wizardModel.setBackButtonIcon(null);
            WizardPanelDescriptor wizardPanelDescriptor = wizardModel.getCurrentPanel();
            if (wizardPanelDescriptor != null && wizardPanelDescriptor.getBackPanelDescriptor() != null) {
                wizardModel.setBackButtonEnabled(Boolean.TRUE);
            } else {
                wizardModel.setBackButtonEnabled(Boolean.FALSE);
            }
            if (wizardPanelDescriptor != null && wizardPanelDescriptor.getNextPanelDescriptor() != null) {
                wizardModel.setNextButtonEnabled(Boolean.TRUE);
            } else {
                wizardModel.setNextButtonEnabled(Boolean.FALSE);
            }
            if (wizardPanelDescriptor != null && wizardPanelDescriptor.getNextPanelDescriptor() != null && wizardPanelDescriptor.getNextPanelDescriptor() instanceof Wizard.FinishIdentifier) {
                wizardModel.setNextButtonText("Finish");
                wizardModel.setNextButtonIcon(null);
            } else {
                wizardModel.setNextButtonText("Next>");
                wizardModel.setNextButtonIcon(null);
            }
        }
    }
}

