/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.wizard;

import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.wizard.Wizard;
import gov.nasa.worldwind.util.wizard.WizardModel;
import gov.nasa.worldwind.util.wizard.WizardPanelDescriptor;
import java.awt.Component;
import javax.swing.JPanel;

public class DefaultPanelDescriptor
implements WizardPanelDescriptor {
    private Wizard wizard;
    private Object panelIdentifier;
    private Component panelComponent;
    private static final String DEFAULT_PANEL_IDENTIFIER = "wizard.DefaultPanelIdentifier";

    public DefaultPanelDescriptor() {
        this.panelIdentifier = DEFAULT_PANEL_IDENTIFIER;
        this.panelComponent = new JPanel();
    }

    public DefaultPanelDescriptor(Object object, Component component) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.ObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (component == null) {
            String string = "Component is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.panelIdentifier = object;
        this.panelComponent = component;
    }

    public final Wizard getWizard() {
        return this.wizard;
    }

    public final WizardModel getWizardModel() {
        return this.wizard != null ? this.wizard.getModel() : null;
    }

    public final Object getPanelIdentifier() {
        return this.panelIdentifier;
    }

    public final void setPanelIdentifier(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.ObjectIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.panelIdentifier = object;
    }

    public final Component getPanelComponent() {
        return this.panelComponent;
    }

    public final void setPanelComponent(Component component) {
        if (component == null) {
            String string = "Component is null";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.panelComponent = component;
    }

    public Object getBackPanelDescriptor() {
        return null;
    }

    public Object getNextPanelDescriptor() {
        return null;
    }

    public void registerPanel(Wizard wizard) {
        this.wizard = wizard;
    }

    public void aboutToDisplayPanel() {
    }

    public void displayingPanel() {
    }

    public void aboutToHidePanel() {
    }
}

