/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class WWIO {
    public static final String ILLEGAL_FILE_PATH_PART_CHARACTERS = "[?/\\\\=+<>:;\\,\"\\|^\\[\\]]";

    public static String formPath(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (string == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.separator);
            }
            stringBuilder.append(string.replaceAll(ILLEGAL_FILE_PATH_PART_CHARACTERS, "_"));
        }
        return stringBuilder.toString();
    }

    public static String stripIllegalFileNameCharacters(String string) {
        return string.replaceAll(ILLEGAL_FILE_PATH_PART_CHARACTERS, "_");
    }

    public static boolean saveBuffer(ByteBuffer byteBuffer, File file) throws IOException {
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        FileOutputStream fileOutputStream = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        int n = 0;
        try {
            fileOutputStream = new FileOutputStream(file);
            abstractInterruptibleChannel = fileOutputStream.getChannel();
            FileLock fileLock = ((FileChannel)abstractInterruptibleChannel).tryLock();
            if (fileLock == null) {
                Logging.logger().log(Level.FINER, "WWIO.UnableToAcquireLockFor", file.getPath());
                boolean bl = false;
                return bl;
            }
            byteBuffer.rewind();
            while (byteBuffer.hasRemaining()) {
                n += ((FileChannel)abstractInterruptibleChannel).write(byteBuffer);
            }
            ((FileChannel)abstractInterruptibleChannel).force(true);
            fileOutputStream.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("WWIO.ErrorSavingBufferTo", file.getPath()), iOException);
            if (n > 0) {
                file.delete();
            }
            throw iOException;
        }
        finally {
            try {
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                } else if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                Logging.logger().severe(Logging.getMessage("WWIO.ErrorTryingToClose", file.getPath()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MappedByteBuffer mapFile(File file) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            MappedByteBuffer mappedByteBuffer = fileInputStream.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            return mappedByteBuffer;
        }
        finally {
            fileInputStream.close();
        }
    }

    public static ByteBuffer readURLContentToBuffer(URL uRL) throws IOException {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        InputStream inputStream = uRL.openStream();
        return WWIO.readStreamToBuffer(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer readFileToBuffer(File file) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileChannel fileChannel = fileInputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)fileChannel.size());
            int n = 0;
            while (n >= 0 && byteBuffer.hasRemaining()) {
                n = fileChannel.read(byteBuffer);
            }
            byteBuffer.flip();
            ByteBuffer byteBuffer2 = byteBuffer;
            return byteBuffer2;
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer readZipEntryToBuffer(File file, String string) throws IOException {
        if (file == null) {
            String string2 = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        InputStream inputStream = null;
        try {
            ZipEntry zipEntry;
            ZipFile zipFile = new ZipFile(file);
            if (zipFile.size() < 1) {
                String string3 = Logging.getMessage("WWIO.ZipFileIsEmpty", file.getPath());
                Logging.logger().severe(string3);
                throw new IOException(string3);
            }
            if (string != null) {
                zipEntry = zipFile.getEntry(string);
                if (zipEntry == null) {
                    String string4 = Logging.getMessage("WWIO.ZipFileEntryNIF", string, file.getPath());
                    Logging.logger().severe(string4);
                    throw new IOException(string4);
                }
            } else {
                zipEntry = zipFile.entries().nextElement();
            }
            inputStream = zipFile.getInputStream(zipEntry);
            ByteBuffer byteBuffer = null;
            if (zipEntry.getSize() > 0L) {
                byteBuffer = WWIO.transferStreamToByteBuffer(inputStream, (int)zipEntry.getSize());
                byteBuffer.rewind();
            }
            ByteBuffer byteBuffer2 = byteBuffer;
            return byteBuffer2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private static ByteBuffer transferStreamToByteBuffer(InputStream inputStream, int n) throws IOException {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 1) {
            Logging.logger().severe("WWIO.NumberBytesTransferLessThanOne");
            throw new IllegalArgumentException(Logging.getMessage("WWIO.NumberBytesTransferLessThanOne"));
        }
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = new byte[n];
        while (n3 >= 0 && n - n2 > 0) {
            n3 = inputStream.read(byArray, n2, n - n2);
            if (n3 <= 0) continue;
            n2 += n3;
        }
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(byArray.length);
        return byteBuffer.put(byArray);
    }

    public static ByteBuffer readStreamToBuffer(InputStream inputStream) throws IOException {
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8192);
        int n = 0;
        while (n >= 0) {
            n = readableByteChannel.read(byteBuffer);
            if (n <= 0 || byteBuffer.hasRemaining()) continue;
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.limit() + 8192);
            byteBuffer2.put((ByteBuffer)byteBuffer.rewind());
            byteBuffer = byteBuffer2;
        }
        if (byteBuffer != null) {
            byteBuffer.flip();
        }
        return byteBuffer;
    }

    public static String replaceSuffix(String string, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.InputFileNameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        return string.substring(0, string.lastIndexOf(".")) + (string2 != null ? string2 : "");
    }

    public static File saveBufferToTempFile(ByteBuffer byteBuffer, String string) throws IOException {
        if (byteBuffer == null) {
            String string2 = Logging.getMessage("nullValue.ByteBufferIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = File.createTempFile("WorldWind", string != null ? string : "");
        file.deleteOnExit();
        byteBuffer.rewind();
        WWIO.saveBuffer(byteBuffer, file);
        return file;
    }

    public static boolean isFileOutOfDate(URL uRL, long l) {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            URI uRI = uRL.toURI();
            if (uRI.isOpaque()) {
                return false;
            }
            File file = new File(uRI);
            return file.exists() && file.lastModified() < l;
        }
        catch (URISyntaxException uRISyntaxException) {
            Logging.logger().log(Level.SEVERE, "WWIO.ExceptionValidatingFileExpiration", uRL);
            return false;
        }
    }

    public static Proxy configureProxy() {
        String string = Configuration.getStringValue("gov.nasa.worldwind.avkey.UrlProxyHost");
        if (string == null) {
            return null;
        }
        Proxy proxy = null;
        try {
            int n = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.UrlProxyPort");
            String string2 = Configuration.getStringValue("gov.nasa.worldwind.avkey.UrlProxyType");
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            if (string2.equals("Proxy.Type.Http")) {
                proxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
            } else if (string2.equals("Proxy.Type.SOCKS")) {
                proxy = new Proxy(Proxy.Type.SOCKS, inetSocketAddress);
            }
        }
        catch (Exception exception) {
            Logging.logger().log(Level.WARNING, Logging.getMessage("URLRetriever.ErrorConfiguringProxy", string), exception);
        }
        return proxy;
    }

    public static String makeSuffixForMimeType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ImageFomat");
            Logging.logger().severe(string2);
            throw new IllegalStateException(string2);
        }
        if (!string.contains("/") || string.endsWith("/")) {
            String string3 = Logging.getMessage("generic.InvalidImageFormat");
            Logging.logger().severe(string3);
            throw new IllegalStateException(string3);
        }
        String string4 = string.substring(string.lastIndexOf("/") + 1);
        return "." + string4.replaceFirst("jpeg", "jpg");
    }

    public static Object getFileOrResourceAsStream(String string, Class clazz) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalStateException(string2);
        }
        File file = new File(string);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (Exception exception) {
                return exception;
            }
        }
        if (clazz == null) {
            clazz = WWIO.class.getClass();
        }
        try {
            return clazz.getResourceAsStream("/" + string);
        }
        catch (Exception exception) {
            return exception;
        }
    }
}

