/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.util.WWIO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gazetteer
extends JPanel {
    private static final String service = "http://local.yahooapis.com/MapsService/V1/geocode?appid=nasaworldwind&location=";

    public ArrayList<Location> getLocations(String string) throws IOException, ParserConfigurationException, XPathExpressionException, SAXException, GazetteerException {
        if (string == null || string.length() < 1) {
            return null;
        }
        String string2 = this.lookupLocation(string.replaceAll(" ", "+"));
        if (string2 == null || string2.length() < 1) {
            return null;
        }
        return this.parseLocationString(string2);
    }

    public String lookupLocation2(String string) throws IOException {
        if (string == null || string.length() < 1) {
            return null;
        }
        String string2 = service + string;
        ByteBuffer byteBuffer = WWIO.readURLContentToBuffer(new URL(string2));
        if (byteBuffer == null || !byteBuffer.hasRemaining()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (byteBuffer.hasRemaining() && !Thread.currentThread().isInterrupted()) {
            stringBuffer.append((char)byteBuffer.get());
        }
        return stringBuffer.toString();
    }

    public String lookupLocation(String string) throws IOException, GazetteerException {
        if (string == null || string.length() < 1) {
            return null;
        }
        String string2 = service + string;
        URL uRL = new URL(string2);
        URLConnection uRLConnection = uRL.openConnection();
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
        int n = httpURLConnection.getResponseCode();
        String string3 = httpURLConnection.getResponseMessage();
        InputStream inputStream = null;
        try {
            if (n == 200) {
                inputStream = uRLConnection.getInputStream();
                ByteBuffer byteBuffer = WWIO.readStreamToBuffer(inputStream);
                StringBuffer stringBuffer = new StringBuffer();
                while (byteBuffer.hasRemaining() && !Thread.currentThread().isInterrupted()) {
                    stringBuffer.append((char)byteBuffer.get());
                }
                String string4 = stringBuffer.toString();
                return string4;
            }
            throw new GazetteerException(string3);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public ArrayList<Location> parseLocationString(String string) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes("UTF-8")));
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        NodeList nodeList = (NodeList)xPath.evaluate("/ResultSet/Result", document, XPathConstants.NODESET);
        ArrayList<Location> arrayList = new ArrayList<Location>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string2 = xPath.evaluate("Latitude", node);
            String string3 = xPath.evaluate("Longitude", node);
            if (string2 == null || string3 == null) continue;
            LatLon latLon = LatLon.fromDegrees(Double.parseDouble(string2), Double.parseDouble(string3));
            Location location = new Location(null, latLon, null, null, null, null, null);
            arrayList.add(location);
        }
        return arrayList;
    }

    public static class GazetteerException
    extends Exception {
        public GazetteerException(String string) {
            super(string);
        }
    }

    public static class Location {
        private final String precision;
        private final LatLon latlon;
        private final String address;
        private final String city;
        private final String state;
        private final String zip;
        private final String country;

        public Location(String string, LatLon latLon, String string2, String string3, String string4, String string5, String string6) {
            this.precision = string;
            this.latlon = latLon;
            this.address = string2;
            this.city = string3;
            this.state = string4;
            this.zip = string5;
            this.country = string6;
        }

        public String getPrecision() {
            return this.precision;
        }

        public LatLon getLatlon() {
            return this.latlon;
        }

        public String getAddress() {
            return this.address;
        }

        public String getCity() {
            return this.city;
        }

        public String getState() {
            return this.state;
        }

        public String getZip() {
            return this.zip;
        }

        public String getCountry() {
            return this.country;
        }
    }
}

