/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.retrieve;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public abstract class URLRetriever
extends WWObjectImpl
implements Retriever {
    private volatile String state = "gov.nasa.worldwind.RetrieverStatusNotStarted";
    private volatile int contentLength = 0;
    private AtomicInteger contentLengthRead = new AtomicInteger(0);
    private volatile String contentType;
    private volatile ByteBuffer byteBuffer;
    private volatile URLConnection connection;
    private final URL url;
    private final RetrievalPostProcessor postProcessor;
    private int connectTimeout = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.URLConnectTimeout", 8000);
    private int readTimeout = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.URLReadTimeout", 5000);
    private int staleRequestLimit = -1;
    private long submitTime;
    private long beginTime;
    private long endTime;

    public URLRetriever(URL uRL, RetrievalPostProcessor retrievalPostProcessor) {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (retrievalPostProcessor == null) {
            String string = Logging.getMessage("nullValue.PostProcessorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.url = uRL;
        this.postProcessor = retrievalPostProcessor;
    }

    public final URL getUrl() {
        return this.url;
    }

    public final int getContentLength() {
        return this.contentLength;
    }

    protected void setContentLengthRead(int n) {
        this.contentLengthRead.set(n);
    }

    public final int getContentLengthRead() {
        return this.contentLengthRead.get();
    }

    public final String getContentType() {
        return this.contentType;
    }

    public final ByteBuffer getBuffer() {
        return this.byteBuffer;
    }

    public final String getName() {
        return this.url.toString();
    }

    public final String getState() {
        return this.state;
    }

    protected final URLConnection getConnection() {
        return this.connection;
    }

    public final RetrievalPostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    public final int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public int getStaleRequestLimit() {
        return this.staleRequestLimit;
    }

    public void setStaleRequestLimit(int n) {
        this.staleRequestLimit = n;
    }

    public final void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    public void setSubmitTime(long l) {
        this.submitTime = l;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long l) {
        this.beginTime = l;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long l) {
        this.endTime = l;
    }

    public final Retriever call() throws Exception {
        if (this.interrupted()) {
            return this;
        }
        try {
            this.setState("gov.nasa.worldwind.RetrieverStatusStarted");
            if (!this.interrupted()) {
                this.setState("gov.nasa.worldwind.RetrieverStatusConnecting");
                this.connection = this.openConnection();
            }
            if (!this.interrupted()) {
                this.setState("gov.nasa.worldwind.RetrieverStatusReading");
                this.byteBuffer = this.read();
            }
            if (!this.interrupted()) {
                this.setState("gov.nasa.worldwind.RetrieverStatusSuccessful");
            }
            WorldWind.getNetworkStatus().logAvailableHost(this.url);
        }
        catch (UnknownHostException unknownHostException) {
            this.setState("gov.nasa.worldwind.RetrieverStatusError");
            WorldWind.getNetworkStatus().logUnavailableHost(this.url);
            throw unknownHostException;
        }
        catch (SocketException socketException) {
            this.setState("gov.nasa.worldwind.RetrieverStatusError");
            WorldWind.getNetworkStatus().logUnavailableHost(this.url);
            throw socketException;
        }
        catch (Exception exception) {
            this.setState("gov.nasa.worldwind.RetrieverStatusError");
            if (!(exception instanceof SocketTimeoutException)) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("URLRetriever.ErrorAttemptingToRetrieve", this.url.toString()), exception);
            }
            throw exception;
        }
        finally {
            this.end();
        }
        return this;
    }

    private void setState(String string) {
        String string2 = this.state;
        this.state = string;
        this.firePropertyChange("gov.nasa.worldwind.avkey.RetrieverState", string2, this.state);
    }

    private boolean interrupted() {
        if (Thread.currentThread().isInterrupted()) {
            this.setState("gov.nasa.worldwind.RetrieverStatusInterrupted");
            String string = Logging.getMessage("URLRetriever.RetrievalInterruptedFor", this.url.toString());
            Logging.logger().fine(string);
            return true;
        }
        return false;
    }

    private URLConnection openConnection() throws IOException {
        Object object;
        try {
            object = WWIO.configureProxy();
            this.connection = object != null ? this.url.openConnection((Proxy)object) : this.url.openConnection();
        }
        catch (IOException iOException) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("URLRetriever.ErrorOpeningConnection", this.url.toString()), iOException);
            throw iOException;
        }
        if (this.connection == null) {
            object = Logging.getMessage("URLRetriever.NullReturnedFromOpenConnection", this.url);
            Logging.logger().severe((String)object);
            throw new IllegalStateException((String)object);
        }
        this.connection.setConnectTimeout(this.connectTimeout);
        this.connection.setReadTimeout(this.readTimeout);
        return this.connection;
    }

    private void end() throws Exception {
        try {
            if (this.postProcessor != null) {
                this.byteBuffer = this.postProcessor.run(this);
            }
        }
        catch (Exception exception) {
            this.setState("gov.nasa.worldwind.RetrieverStatusError");
            Logging.logger().log(Level.SEVERE, Logging.getMessage("URLRetriever.ErrorPostProcessing", this.url.toString()), exception);
            throw exception;
        }
    }

    private ByteBuffer read() throws Exception {
        try {
            ByteBuffer byteBuffer = this.doRead(this.connection);
            if (byteBuffer == null) {
                this.contentLength = 0;
            }
            return byteBuffer;
        }
        catch (Exception exception) {
            if (!(exception instanceof SocketTimeoutException || exception instanceof UnknownHostException || exception instanceof SocketException)) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("URLRetriever.ErrorReadingFromConnection", this.url.toString()), exception);
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBuffer doRead(URLConnection uRLConnection) throws Exception {
        ByteBuffer byteBuffer;
        if (uRLConnection == null) {
            String string = Logging.getMessage("nullValue.ConnectionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.contentLength = this.connection.getContentLength();
        InputStream inputStream = null;
        try {
            inputStream = this.connection.getInputStream();
            if (inputStream == null) {
                Logging.logger().log(Level.SEVERE, "URLRetriever.InputStreamFromConnectionNull", uRLConnection.getURL());
                ByteBuffer byteBuffer2 = null;
                return byteBuffer2;
            }
            this.contentType = uRLConnection.getContentType();
            byteBuffer = this.contentType != null && this.contentType.equalsIgnoreCase("application/zip") ? this.readZipStream(inputStream, uRLConnection.getURL()) : this.readNonSpecificStream(inputStream, uRLConnection);
            this.contentType = uRLConnection.getContentType();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Logging.logger().log(Level.SEVERE, "URLRetriever.ExceptionClosingInputStreamToConnection", uRLConnection.getURL());
                }
            }
        }
        return byteBuffer;
    }

    private ByteBuffer readNonSpecificStream(InputStream inputStream, URLConnection uRLConnection) throws IOException {
        if (inputStream == null) {
            String string = Logging.getMessage("URLRetriever.InputStreamNullFor", uRLConnection.getURL());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.contentLength < 1) {
            return this.readNonSpecificStreamUnknownLength(inputStream);
        }
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.contentLength);
        int n = 0;
        while (!this.interrupted() && n >= 0 && n < byteBuffer.limit()) {
            int n2 = readableByteChannel.read(byteBuffer);
            if (n2 <= 0) continue;
            this.contentLengthRead.getAndAdd(n += n2);
        }
        if (byteBuffer != null) {
            byteBuffer.flip();
        }
        return byteBuffer;
    }

    private ByteBuffer readNonSpecificStreamUnknownLength(InputStream inputStream) throws IOException {
        int n = (int)Math.ceil(Math.pow(2.0, 15.0));
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        int n2 = 0;
        int n3 = 0;
        while (!this.interrupted() && n2 >= 0) {
            n2 = readableByteChannel.read(byteBuffer);
            if (n2 > 0) {
                this.contentLengthRead.getAndAdd(n3 += n2);
            }
            if (n2 <= 0 || byteBuffer.hasRemaining()) continue;
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.limit() + n);
            byteBuffer2.put((ByteBuffer)byteBuffer.rewind());
            byteBuffer = byteBuffer2;
        }
        if (byteBuffer != null) {
            byteBuffer.flip();
        }
        return byteBuffer;
    }

    private ByteBuffer readZipStream(InputStream inputStream, URL uRL) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (zipEntry == null) {
            Logging.logger().severe(Logging.getMessage("URLRetriever.NoZipEntryFor") + uRL);
            return null;
        }
        ByteBuffer byteBuffer = null;
        if (zipEntry.getSize() > 0L) {
            byteBuffer = ByteBuffer.allocate((int)zipEntry.getSize());
            byte[] byArray = new byte[8192];
            while (byteBuffer.hasRemaining()) {
                int n = zipInputStream.read(byArray);
                if (n <= 0) continue;
                byteBuffer.put(byArray, 0, n);
                this.contentLengthRead.getAndAdd(byteBuffer.position() + 1);
            }
        }
        if (byteBuffer != null) {
            byteBuffer.flip();
        }
        return byteBuffer;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        URLRetriever uRLRetriever = (URLRetriever)object;
        return !(this.url == null ? uRLRetriever.url != null : !this.url.toString().contentEquals(uRLRetriever.url.toString()));
    }

    public int hashCode() {
        int n = this.url != null ? this.url.hashCode() : 0;
        return n;
    }

    public String toString() {
        return this.getName() != null ? this.getName() : super.toString();
    }
}

