/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.retrieve;

import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public final class RetrieveToFilePostProcessor
implements RetrievalPostProcessor {
    File destination;

    public RetrieveToFilePostProcessor(File file) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.DestNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.destination = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer run(Retriever retriever) {
        if (retriever == null) {
            String string = Logging.getMessage("nullValue.RetrieverIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            ByteBuffer byteBuffer = retriever.getBuffer();
            if (byteBuffer == null) {
                Logging.logger().log(Level.SEVERE, "RetrieveToFilePostProcessor.NullBufferPostprocessing", retriever.getName());
                return null;
            }
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.destination);
                fileOutputStream.getChannel().write(byteBuffer);
                ByteBuffer byteBuffer2 = null;
                return byteBuffer2;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("RetrieveToFilePostProcessor.ErrorPostprocessing", retriever.getName());
            Logging.logger().severe(string);
            throw new WWRuntimeException(string, iOException);
        }
    }
}

