/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.SectorGeometryList;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.LocationRenderer;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.tracks.TrackPoint;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackRenderer
extends LocationRenderer {
    private double markerPixels = 8.0;
    private double minMarkerSize = 3.0;
    private Material material = Material.WHITE;
    private String iconFilePath;
    private LocationRenderer.Shape shape = this.SPHERE;

    public double getMarkerPixels() {
        return this.markerPixels;
    }

    public void setMarkerPixels(double d) {
        this.markerPixels = d;
    }

    public double getMinMarkerSize() {
        return this.minMarkerSize;
    }

    public void setMinMarkerSize(double d) {
        this.minMarkerSize = d;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.material = material;
    }

    public String getIconFilePath() {
        return this.iconFilePath;
    }

    public void setIconFilePath(String string) {
        this.iconFilePath = string;
    }

    public void setShapeType(String string) {
        this.shape = string.equalsIgnoreCase("Cone") ? this.CONE : (string.equalsIgnoreCase("Cylinder") ? this.CYLINDER : this.SPHERE);
    }

    @Override
    protected Vec4 draw(DrawContext drawContext, Iterator<TrackPoint> iterator) {
        if (drawContext.getVisibleSector() == null) {
            return null;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return null;
        }
        if (!this.shape.isInitialized) {
            this.shape.initialize(drawContext);
        }
        Vec4 vec4 = null;
        this.begin(drawContext);
        if (!drawContext.isPickingMode()) {
            this.material.apply(drawContext.getGL(), 1028);
        }
        Vec4 vec42 = null;
        int n = 0;
        while (iterator.hasNext()) {
            TrackPoint trackPoint = iterator.next();
            if (n >= this.lowerLimit) {
                if (n > this.upperLimit) break;
                Vec4 vec43 = this.computeSurfacePoint(drawContext, trackPoint);
                if (vec43 != null) {
                    if (drawContext.isPickingMode()) {
                        Color color = drawContext.getUniquePickColor();
                        int n2 = color.getRGB();
                        PickedObject pickedObject = new PickedObject(n2, this.getClient() != null ? this.getClient() : trackPoint.getPosition(), trackPoint.getPosition(), false);
                        pickedObject.setValue("gov.nasa.worldwind.avkey.PickedObject.ID", n);
                        this.pickSupport.addPickableObject(pickedObject);
                        drawContext.getGL().glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                    }
                    double d = this.computeMarkerRadius(drawContext, vec43);
                    if (vec42 == null) {
                        vec42 = vec43;
                        this.shape.render(drawContext, vec43, d);
                        vec4 = vec43;
                    } else {
                        double d2;
                        double d3 = vec43.distanceTo3(vec42);
                        if (d3 > (d2 = 4.0 * d)) {
                            vec42 = vec43;
                            this.shape.render(drawContext, vec43, d);
                            vec4 = vec43;
                        }
                    }
                }
            }
            ++n;
        }
        this.end(drawContext);
        return vec4;
    }

    private double computeMarkerRadius(DrawContext drawContext, Vec4 vec4) {
        double d = vec4.distanceTo3(drawContext.getView().getEyePoint());
        double d2 = this.markerPixels * drawContext.getView().computePixelSizeAtDistance(d);
        if (d2 < this.minMarkerSize) {
            d2 = this.minMarkerSize;
        }
        return d2;
    }
}

