/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceSector
extends SurfacePolygon {
    public SurfaceSector(Sector sector, Color color, Color color2) {
        super(SurfaceSector.makePositions(sector), color, color2);
    }

    public SurfaceSector(Sector sector) {
        super(SurfaceSector.makePositions(sector), null, null);
    }

    public SurfaceSector(Sector sector, Color color, Color color2, Dimension dimension) {
        super(SurfaceSector.makePositions(sector), color, color2, dimension);
    }

    public void setSector(Sector sector) {
        this.setPositions(SurfaceSector.makePositions(sector));
    }

    public Sector getSector() {
        return this.getSectors().get(0);
    }

    private static Iterable<LatLon> makePositions(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(5);
        arrayList.add(new LatLon(sector.getMinLatitude(), sector.getMinLongitude()));
        arrayList.add(new LatLon(sector.getMinLatitude(), sector.getMaxLongitude()));
        arrayList.add(new LatLon(sector.getMaxLatitude(), sector.getMaxLongitude()));
        arrayList.add(new LatLon(sector.getMaxLatitude(), sector.getMinLongitude()));
        arrayList.add(new LatLon(sector.getMinLatitude(), sector.getMinLongitude()));
        return arrayList;
    }
}

