/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.render.AbstractAnnotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import javax.media.opengl.GL;

public class ScreenAnnotation
extends AbstractAnnotation {
    private Point screenPoint;

    public ScreenAnnotation(String string, Point point) {
        this.init(string, point, null, null);
    }

    public ScreenAnnotation(String string, Point point, Font font) {
        this.init(string, point, font, null);
    }

    public ScreenAnnotation(String string, Point point, Font font, Color color) {
        this.init(string, point, font, color);
    }

    public ScreenAnnotation(String string, Point point, AnnotationAttributes annotationAttributes) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (point == null) {
            String string3 = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (annotationAttributes == null) {
            String string4 = Logging.getMessage("nullValue.AnnotationAttributesIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.setText(string);
        this.screenPoint = point;
        this.getAttributes().setDefaults(annotationAttributes);
        this.getAttributes().setLeader("Render.FrameFactory.LeaderNone");
        this.getAttributes().setDrawOffset(new Point(0, 0));
    }

    private void init(String string, Point point, Font font, Color color) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (point == null) {
            String string3 = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.setText(string);
        this.screenPoint = point;
        this.getAttributes().setFont(font);
        this.getAttributes().setTextColor(color);
        this.getAttributes().setLeader("Render.FrameFactory.LeaderNone");
        this.getAttributes().setDrawOffset(new Point(0, 0));
    }

    public Point getScreenPoint() {
        return this.screenPoint;
    }

    public void setScreenPoint(Point point) {
        if (point == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.screenPoint = point;
    }

    protected void doDraw(DrawContext drawContext) {
        if (drawContext.isPickingMode() && this.getPickSupport() == null) {
            return;
        }
        GL gL = drawContext.getGL();
        gL.glDepthFunc(519);
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
        gL.glTranslated(this.screenPoint.x, this.screenPoint.y, 0.0);
        this.drawAnnotation(drawContext, this.screenPoint, 1.0, 1.0, null);
    }

    public String getRestorableState() {
        RestorableSupport.StateObject stateObject;
        RestorableSupport restorableSupport = null;
        String string = super.getRestorableState();
        if (string != null) {
            try {
                restorableSupport = RestorableSupport.parse(string);
            }
            catch (Exception exception) {
                String string2 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
                Logging.logger().severe(string2);
            }
        }
        if (restorableSupport == null) {
            restorableSupport = RestorableSupport.newRestorableSupport();
        }
        if (restorableSupport == null) {
            return null;
        }
        if (this.screenPoint != null && (stateObject = restorableSupport.addStateObject("screenPoint")) != null) {
            restorableSupport.addStateValueAsDouble(stateObject, "x", this.screenPoint.getX());
            restorableSupport.addStateValueAsDouble(stateObject, "y", this.screenPoint.getY());
        }
        return restorableSupport.getStateAsXml();
    }

    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            super.restoreState(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        RestorableSupport.StateObject stateObject = restorableSupport.getStateObject("screenPoint");
        if (stateObject != null) {
            Double d = restorableSupport.getStateValueAsDouble(stateObject, "x");
            Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "y");
            if (d != null && d2 != null) {
                this.setScreenPoint(new Point(d.intValue(), d2.intValue()));
            }
        }
    }
}

