/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.SectorGeometryList;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.LocationRenderer;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.tracks.TrackPoint;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Iterator;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipeRenderer
extends LocationRenderer {
    private Material junctionMaterial = Material.RED;
    private Material pipeMaterial = Material.WHITE;
    private double pipeRadius = 1000.0;
    private double junctionShapeRadius = 1.8 * this.pipeRadius;
    private LocationRenderer.Shape junctionShape = this.SPHERE;
    private Pipe pipeShape = new Pipe();

    public Material getPipeMaterial() {
        return this.pipeMaterial;
    }

    public void setPipeMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pipeMaterial = material;
    }

    public Material getJunctionMaterial() {
        return this.junctionMaterial;
    }

    public void setJunctionMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.junctionMaterial = material;
    }

    public void setJunctionShape(String string) {
        this.junctionShape = string.equalsIgnoreCase("Cone") ? this.CONE : (string.equalsIgnoreCase("Cylinder") ? this.CYLINDER : this.SPHERE);
    }

    public String getJunctionShape() {
        return this.junctionShape.name;
    }

    @Override
    protected Vec4 draw(DrawContext drawContext, Iterator<TrackPoint> iterator) {
        Object object;
        if (drawContext.getVisibleSector() == null) {
            return null;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return null;
        }
        if (!this.pipeShape.isInitialized) {
            this.pipeShape.initialize(drawContext);
        }
        if (!this.junctionShape.isInitialized) {
            this.junctionShape.initialize(drawContext);
        }
        int n = 0;
        ArrayList<Vec4> arrayList = new ArrayList<Vec4>();
        while (iterator.hasNext()) {
            Vec4 vec4;
            object = iterator.next();
            if (n >= this.lowerLimit && n <= this.upperLimit && (vec4 = this.computeSurfacePoint(drawContext, (TrackPoint)object)) != null) {
                arrayList.add(vec4);
            }
            if (++n < this.upperLimit) continue;
            break;
        }
        if (arrayList.size() < 1) {
            return null;
        }
        this.begin(drawContext);
        this.pipeMaterial.apply(drawContext.getGL(), 1028);
        object = (Vec4)arrayList.get(0);
        for (int i = 1; i < arrayList.size(); ++i) {
            Vec4 vec4 = (Vec4)arrayList.get(i);
            this.pipeShape.render(drawContext, (Vec4)object, vec4, this.pipeRadius);
            object = vec4;
        }
        this.junctionMaterial.apply(drawContext.getGL(), 1028);
        for (Vec4 vec4 : arrayList) {
            this.junctionShape.render(drawContext, vec4, this.junctionShapeRadius);
        }
        this.end(drawContext);
        return null;
    }

    private static class Pipe
    extends LocationRenderer.Cylinder {
        private static final double TO_DEGREES = 57.29577951308232;

        private Pipe() {
        }

        protected void initialize(DrawContext drawContext) {
            super.initialize(drawContext);
            this.name = "Pipe";
        }

        protected void render(DrawContext drawContext, Vec4 vec4, Vec4 vec42, double d) {
            double d2 = vec4.distanceTo3(vec42);
            Vec4 vec43 = new Vec4((vec42.x - vec4.x) / d2, (vec42.y - vec4.y) / d2, (vec42.z - vec4.z) / d2);
            double d3 = Math.acos(vec43.z);
            double d4 = -vec43.y;
            double d5 = vec43.x;
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            GL gL = drawContext.getGL();
            drawContext.getView().pushReferenceCenter(drawContext, vec4);
            gL.glRotated(d3 * 57.29577951308232, d4 / d6, d5 / d6, 0.0);
            gL.glScaled(d, d, d2 / 2.0);
            drawContext.getGL().glCallList(this.glListId);
            drawContext.getView().popReferenceCenter(drawContext);
        }
    }
}

