/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import javax.media.opengl.GL;

public class Material {
    public static final int SPECULAR = 0;
    public static final int DIFFUSE = 1;
    public static final int AMBIENT = 2;
    public static final int EMISSION = 3;
    public static final Material WHITE = new Material(new Color(0.9f, 0.9f, 0.9f, 0.0f), new Color(0.8f, 0.8f, 0.8f, 0.0f), new Color(0.2f, 0.2f, 0.2f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), 20.0f);
    public static final Material RED = new Material(new Color(0.75f, 0.0f, 0.0f, 0.0f), new Color(0.8f, 0.0f, 0.0f, 0.0f), new Color(0.2f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), 80.0f);
    public static final Material GREEN = new Material(new Color(0.0f, 0.75f, 0.0f, 0.0f), new Color(0.0f, 0.8f, 0.0f, 0.0f), new Color(0.0f, 0.2f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), 20.0f);
    public static final Material BLUE = new Material(new Color(0.0f, 0.0f, 0.75f, 0.0f), new Color(0.0f, 0.0f, 0.8f, 0.0f), new Color(0.0f, 0.0f, 0.2f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), 20.0f);
    public static final Material YELLOW = new Material(new Color(0.75f, 0.75f, 0.55f, 0.0f), new Color(0.8f, 0.8f, 0.0f, 0.0f), new Color(0.2f, 0.2f, 0.01f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), 20.0f);
    private final Color specular;
    private final Color diffuse;
    private final Color ambient;
    private final Color emission;
    private final float shininess;

    public Material(Color color, Color color2, Color color3, Color color4, float f) {
        if (color == null || color2 == null || color3 == null || color4 == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.specular = color;
        this.diffuse = color2;
        this.ambient = color3;
        this.emission = color4;
        this.shininess = f;
    }

    public Material(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.specular = new Color(0.75f, 0.75f, 0.55f, 0.0f);
        this.diffuse = color;
        this.ambient = new Color(0.2f, 0.2f, 0.01f, 0.0f);
        this.emission = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        this.shininess = 20.0f;
    }

    public Color getSpecular() {
        return this.specular;
    }

    public Color getDiffuse() {
        return this.diffuse;
    }

    public Color getAmbient() {
        return this.ambient;
    }

    public Color getEmission() {
        return this.emission;
    }

    public float getShininess() {
        return this.shininess;
    }

    public void apply(GL gL, int n) {
        float[] fArray = new float[4];
        gL.glMaterialfv(n, 4610, this.specular.getRGBComponents(fArray), 0);
        gL.glMaterialfv(n, 4609, this.diffuse.getRGBComponents(fArray), 0);
        gL.glMaterialfv(n, 4608, this.ambient.getRGBComponents(fArray), 0);
        gL.glMaterialf(n, 5633, this.shininess);
        gL.glMaterialfv(n, 5632, this.emission.getRGBComponents(fArray), 0);
    }
}

