/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Restorable;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;

public class AnnotationAttributes
implements Restorable {
    private static final AnnotationAttributes defaults = new AnnotationAttributes();
    private AnnotationAttributes defaultAttributes = defaults;
    private String frameShape;
    private Dimension size;
    private double scale = -1.0;
    private double opacity = -1.0;
    private String leader;
    private int cornerRadius = -1;
    private String adjustWidthToText;
    private Point drawOffset;
    private boolean isHighlighted = false;
    private boolean isVisible = true;
    private double highlightScale = -1.0;
    private Font font;
    private int textAlign = -1;
    private Color textColor;
    private Color backgroundColor;
    private Color borderColor;
    private double borderWidth = -1.0;
    private int borderStippleFactor = -1;
    private short borderStipplePattern = 0;
    private int antiAliasHint = -1;
    private Insets insets;
    private Object imageSource;
    private double imageScale = -1.0;
    private Point imageOffset;
    private double imageOpacity = -1.0;
    private String imageRepeat;
    private double distanceMinScale = -1.0;
    private double distanceMaxScale = -1.0;
    private double distanceMinOpacity = -1.0;
    private String effect;

    public void setDefaults(AnnotationAttributes annotationAttributes) {
        if (annotationAttributes == null) {
            String string = Logging.getMessage("nullValue.AnnotationAttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.defaultAttributes = annotationAttributes;
    }

    public String getFrameShape() {
        return this.frameShape != null ? this.frameShape : this.defaultAttributes.getFrameShape();
    }

    public void setFrameShape(String string) {
        this.frameShape = string;
    }

    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    public void setHighlighted(boolean bl) {
        this.isHighlighted = bl;
    }

    public double getHighlightScale() {
        return this.highlightScale > 0.0 ? this.highlightScale : this.defaultAttributes.getHighlightScale();
    }

    public void setHighlightScale(double d) {
        this.highlightScale = d;
    }

    public Dimension getSize() {
        return this.size != null ? this.size : this.defaultAttributes.getSize();
    }

    public void setSize(Dimension dimension) {
        this.size = dimension;
    }

    public double getScale() {
        return this.scale >= 0.0 ? this.scale : this.defaultAttributes.getScale();
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public double getOpacity() {
        return this.opacity >= 0.0 ? this.opacity : this.defaultAttributes.getOpacity();
    }

    public void setOpacity(double d) {
        this.opacity = d;
    }

    public String getLeader() {
        return this.leader != null ? this.leader : this.defaultAttributes.getLeader();
    }

    public void setLeader(String string) {
        this.leader = string;
    }

    public int getCornerRadius() {
        return this.cornerRadius >= 0 ? this.cornerRadius : this.defaultAttributes.getCornerRadius();
    }

    public void setCornerRadius(int n) {
        this.cornerRadius = n;
    }

    public String getAdjustWidthToText() {
        return this.adjustWidthToText != null ? this.adjustWidthToText : this.defaultAttributes.getAdjustWidthToText();
    }

    public void setAdjustWidthToText(String string) {
        this.adjustWidthToText = string;
    }

    public Point getDrawOffset() {
        return this.drawOffset != null ? this.drawOffset : this.defaultAttributes.getDrawOffset();
    }

    public void setDrawOffset(Point point) {
        this.drawOffset = point;
    }

    public Insets getInsets() {
        return this.insets != null ? this.insets : this.defaultAttributes.getInsets();
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public double getBorderWidth() {
        return this.borderWidth >= 0.0 ? this.borderWidth : this.defaultAttributes.getBorderWidth();
    }

    public void setBorderWidth(double d) {
        this.borderWidth = d;
    }

    public int getBorderStippleFactor() {
        return this.borderStippleFactor >= 0 ? this.borderStippleFactor : this.defaultAttributes.getBorderStippleFactor();
    }

    public void setBorderStippleFactor(int n) {
        this.borderStippleFactor = n;
    }

    public short getBorderStipplePattern() {
        return this.borderStipplePattern != 0 ? this.borderStipplePattern : this.defaultAttributes.getBorderStipplePattern();
    }

    public void setBorderStipplePattern(short s) {
        this.borderStipplePattern = s;
    }

    public int getAntiAliasHint() {
        return this.antiAliasHint >= 0 ? this.antiAliasHint : this.defaultAttributes.getAntiAliasHint();
    }

    public void setAntiAliasHint(int n) {
        this.antiAliasHint = n;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public Font getFont() {
        return this.font != null ? this.font : this.defaultAttributes.getFont();
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public int getTextAlign() {
        return this.textAlign >= 0 ? this.textAlign : this.defaultAttributes.getTextAlign();
    }

    public void setTextAlign(int n) {
        this.textAlign = n;
    }

    public Color getTextColor() {
        return this.textColor != null ? this.textColor : this.defaultAttributes.getTextColor();
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor != null ? this.backgroundColor : this.defaultAttributes.getBackgroundColor();
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor != null ? this.borderColor : this.defaultAttributes.getBorderColor();
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Object getImageSource() {
        return this.imageSource;
    }

    public void setImageSource(Object object) {
        this.imageSource = object;
    }

    public double getImageScale() {
        return this.imageScale >= 0.0 ? this.imageScale : this.defaultAttributes.getImageScale();
    }

    public void setImageScale(double d) {
        this.imageScale = d;
    }

    public Point getImageOffset() {
        return this.imageOffset != null ? this.imageOffset : this.defaultAttributes.getImageOffset();
    }

    public void setImageOffset(Point point) {
        this.imageOffset = point;
    }

    public double getImageOpacity() {
        return this.imageOpacity >= 0.0 ? this.imageOpacity : this.defaultAttributes.getImageOpacity();
    }

    public void setImageOpacity(double d) {
        this.imageOpacity = d;
    }

    public String getImageRepeat() {
        return this.imageRepeat != null ? this.imageRepeat : this.defaultAttributes.getImageRepeat();
    }

    public void setImageRepeat(String string) {
        this.imageRepeat = string;
    }

    public String getPath() {
        return this.imageSource instanceof String ? (String)this.imageSource : null;
    }

    public double getDistanceMinScale() {
        return this.distanceMinScale >= 0.0 ? this.distanceMinScale : this.defaultAttributes.getDistanceMinScale();
    }

    public void setDistanceMinScale(double d) {
        this.distanceMinScale = d;
    }

    public double getDistanceMaxScale() {
        return this.distanceMaxScale >= 0.0 ? this.distanceMaxScale : this.defaultAttributes.getDistanceMaxScale();
    }

    public void setDistanceMaxScale(double d) {
        this.distanceMaxScale = d;
    }

    public double getDistanceMinOpacity() {
        return this.distanceMinOpacity >= 0.0 ? this.distanceMinOpacity : this.defaultAttributes.getDistanceMinOpacity();
    }

    public void setDistanceMinOpacity(double d) {
        this.distanceMinOpacity = d;
    }

    public String getEffect() {
        return this.effect != null ? this.effect : this.defaultAttributes.getEffect();
    }

    public void setEffect(String string) {
        this.effect = string;
    }

    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        if (restorableSupport == null) {
            return null;
        }
        AnnotationAttributes.saveAttributes(this, restorableSupport, null);
        if (this.defaultAttributes != defaults) {
            RestorableSupport.StateObject stateObject = restorableSupport.addStateObject("defaultAttributes");
            AnnotationAttributes.saveAttributes(this.defaultAttributes, restorableSupport, stateObject);
        }
        return restorableSupport.getStateAsXml();
    }

    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        AnnotationAttributes.restoreAttributes(restorableSupport, null, this);
        RestorableSupport.StateObject stateObject = restorableSupport.getStateObject("defaultAttributes");
        if (stateObject != null) {
            AnnotationAttributes annotationAttributes = this.defaultAttributes;
            if (annotationAttributes == defaults) {
                annotationAttributes = new AnnotationAttributes();
            }
            AnnotationAttributes.restoreAttributes(restorableSupport, stateObject, annotationAttributes);
            this.setDefaults(annotationAttributes);
        }
    }

    private static void saveAttributes(AnnotationAttributes annotationAttributes, RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Object object;
        if (annotationAttributes == null || restorableSupport == null) {
            throw new IllegalArgumentException();
        }
        if (annotationAttributes.frameShape != null) {
            restorableSupport.addStateValueAsString(stateObject, "frameShape", annotationAttributes.frameShape);
        }
        restorableSupport.addStateValueAsBoolean(stateObject, "highlighted", annotationAttributes.isHighlighted);
        if (annotationAttributes.highlightScale >= 0.0) {
            restorableSupport.addStateValueAsDouble(stateObject, "highlightScale", annotationAttributes.highlightScale);
        }
        if (annotationAttributes.size != null && (object = restorableSupport.addStateObject(stateObject, "size")) != null) {
            restorableSupport.addStateValueAsDouble((RestorableSupport.StateObject)object, "width", annotationAttributes.size.getWidth());
            restorableSupport.addStateValueAsDouble((RestorableSupport.StateObject)object, "height", annotationAttributes.size.getHeight());
        }
        if (annotationAttributes.scale >= 0.0) {
            restorableSupport.addStateValueAsDouble(stateObject, "scale", annotationAttributes.scale);
        }
        if (annotationAttributes.opacity >= 0.0) {
            restorableSupport.addStateValueAsDouble(stateObject, "opacity", annotationAttributes.opacity);
        }
        if (annotationAttributes.leader != null) {
            restorableSupport.addStateValueAsString(stateObject, "leader", annotationAttributes.leader);
        }
        if (annotationAttributes.cornerRadius >= 0) {
            restorableSupport.addStateValueAsInteger(stateObject, "cornerRadius", annotationAttributes.cornerRadius);
        }
        if (annotationAttributes.adjustWidthToText != null) {
            restorableSupport.addStateValueAsString(stateObject, "adjustWidthToText", annotationAttributes.adjustWidthToText);
        }
        if (annotationAttributes.drawOffset != null && (object = restorableSupport.addStateObject(stateObject, "drawOffset")) != null) {
            restorableSupport.addStateValueAsDouble((RestorableSupport.StateObject)object, "x", annotationAttributes.drawOffset.getX());
            restorableSupport.addStateValueAsDouble((RestorableSupport.StateObject)object, "y", annotationAttributes.drawOffset.getY());
        }
        if (annotationAttributes.insets != null && (object = restorableSupport.addStateObject(stateObject, "insets")) != null) {
            restorableSupport.addStateValueAsInteger((RestorableSupport.StateObject)object, "top", annotationAttributes.insets.top);
            restorableSupport.addStateValueAsInteger((RestorableSupport.StateObject)object, "left", annotationAttributes.insets.left);
            restorableSupport.addStateValueAsInteger((RestorableSupport.StateObject)object, "bottom", annotationAttributes.insets.bottom);
            restorableSupport.addStateValueAsInteger((RestorableSupport.StateObject)object, "right", annotationAttributes.insets.right);
        }
        if (annotationAttributes.borderWidth >= 0.0) {
            restorableSupport.addStateValueAsDouble(stateObject, "borderWidth", annotationAttributes.borderWidth);
        }
        if (annotationAttributes.borderStippleFactor >= 0) {
            restorableSupport.addStateValueAsInteger(stateObject, "borderStippleFactor", annotationAttributes.borderStippleFactor);
        }
        if (annotationAttributes.borderStipplePattern != 0) {
            restorableSupport.addStateValueAsInteger(stateObject, "borderStipplePattern", annotationAttributes.borderStipplePattern);
        }
        if (annotationAttributes.antiAliasHint >= 0) {
            restorableSupport.addStateValueAsInteger(stateObject, "antiAliasHint", annotationAttributes.antiAliasHint);
        }
        restorableSupport.addStateValueAsBoolean(stateObject, "visible", annotationAttributes.isVisible);
        if (annotationAttributes.font != null && (object = restorableSupport.addStateObject(stateObject, "font")) != null) {
            restorableSupport.addStateValueAsString((RestorableSupport.StateObject)object, "name", annotationAttributes.font.getName());
            restorableSupport.addStateValueAsInteger((RestorableSupport.StateObject)object, "style", annotationAttributes.font.getStyle());
            restorableSupport.addStateValueAsInteger((RestorableSupport.StateObject)object, "size", annotationAttributes.font.getSize());
        }
        if (annotationAttributes.textAlign >= 0) {
            restorableSupport.addStateValueAsInteger(stateObject, "textAlign", annotationAttributes.textAlign);
        }
        if (annotationAttributes.textColor != null && (object = RestorableSupport.encodeColor(annotationAttributes.textColor)) != null) {
            restorableSupport.addStateValueAsString(stateObject, "textColor", (String)object);
        }
        if (annotationAttributes.backgroundColor != null && (object = RestorableSupport.encodeColor(annotationAttributes.backgroundColor)) != null) {
            restorableSupport.addStateValueAsString(stateObject, "backgroundColor", (String)object);
        }
        if (annotationAttributes.borderColor != null && (object = RestorableSupport.encodeColor(annotationAttributes.borderColor)) != null) {
            restorableSupport.addStateValueAsString(stateObject, "borderColor", (String)object);
        }
        if (annotationAttributes.getPath() != null) {
            restorableSupport.addStateValueAsString(stateObject, "imagePath", annotationAttributes.getPath(), true);
        }
        if (annotationAttributes.imageScale >= 0.0) {
            restorableSupport.addStateValueAsDouble(stateObject, "imageScale", annotationAttributes.imageScale);
        }
        if (annotationAttributes.imageOffset != null && (object = restorableSupport.addStateObject(stateObject, "imageOffset")) != null) {
            restorableSupport.addStateValueAsDouble((RestorableSupport.StateObject)object, "x", annotationAttributes.imageOffset.getX());
            restorableSupport.addStateValueAsDouble((RestorableSupport.StateObject)object, "y", annotationAttributes.imageOffset.getY());
        }
        if (annotationAttributes.imageOpacity >= 0.0) {
            restorableSupport.addStateValueAsDouble(stateObject, "imageOpacity", annotationAttributes.imageOpacity);
        }
        if (annotationAttributes.imageRepeat != null) {
            restorableSupport.addStateValueAsString(stateObject, "imageRepeat", annotationAttributes.imageRepeat);
        }
        if (annotationAttributes.distanceMinScale >= 0.0) {
            restorableSupport.addStateValueAsDouble(stateObject, "distanceMinScale", annotationAttributes.distanceMinScale);
        }
        if (annotationAttributes.distanceMaxScale >= 0.0) {
            restorableSupport.addStateValueAsDouble(stateObject, "distanceMaxScale", annotationAttributes.distanceMaxScale);
        }
        if (annotationAttributes.distanceMinOpacity >= 0.0) {
            restorableSupport.addStateValueAsDouble(stateObject, "distanceMinOpacity", annotationAttributes.distanceMinOpacity);
        }
        if (annotationAttributes.effect != null) {
            restorableSupport.addStateValueAsString(stateObject, "effect", annotationAttributes.effect);
        }
    }

    private static void restoreAttributes(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject, AnnotationAttributes annotationAttributes) {
        String string;
        Double d;
        Double d2;
        Double d3;
        Object object;
        Double d4;
        RestorableSupport.StateObject stateObject2;
        Double d5;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        RestorableSupport.StateObject stateObject3;
        Boolean bl;
        Integer n;
        Integer n2;
        Integer n3;
        Number number;
        Object object7;
        RestorableSupport.StateObject stateObject4;
        String string2;
        Integer n4;
        String string3;
        Double d6;
        Double d7;
        RestorableSupport.StateObject stateObject5;
        Double d8;
        Boolean bl2;
        if (restorableSupport == null || annotationAttributes == null) {
            throw new IllegalArgumentException();
        }
        String string4 = restorableSupport.getStateValueAsString(stateObject, "frameShape");
        if (string4 != null) {
            annotationAttributes.setFrameShape(string4);
        }
        if ((bl2 = restorableSupport.getStateValueAsBoolean(stateObject, "highlighted")) != null) {
            annotationAttributes.setHighlighted(bl2);
        }
        if ((d8 = restorableSupport.getStateValueAsDouble(stateObject, "highlightScale")) != null) {
            annotationAttributes.setHighlightScale(d8);
        }
        if ((stateObject5 = restorableSupport.getStateObject(stateObject, "size")) != null) {
            d7 = restorableSupport.getStateValueAsDouble(stateObject5, "width");
            d6 = restorableSupport.getStateValueAsDouble(stateObject5, "height");
            if (d7 != null && d6 != null) {
                annotationAttributes.setSize(new Dimension(d7.intValue(), d6.intValue()));
            }
        }
        if ((d7 = restorableSupport.getStateValueAsDouble(stateObject, "scale")) != null) {
            annotationAttributes.setScale(d7);
        }
        if ((d6 = restorableSupport.getStateValueAsDouble(stateObject, "opacity")) != null) {
            annotationAttributes.setOpacity(d6);
        }
        if ((string3 = restorableSupport.getStateValueAsString(stateObject, "leader")) != null) {
            annotationAttributes.setLeader(string3);
        }
        if ((n4 = restorableSupport.getStateValueAsInteger(stateObject, "cornerRadius")) != null) {
            annotationAttributes.setCornerRadius(n4);
        }
        if ((string2 = restorableSupport.getStateValueAsString(stateObject, "adjustWidthToText")) != null) {
            annotationAttributes.setAdjustWidthToText(string2);
        }
        if ((stateObject4 = restorableSupport.getStateObject(stateObject, "drawOffset")) != null) {
            object7 = restorableSupport.getStateValueAsDouble(stateObject4, "x");
            number = restorableSupport.getStateValueAsDouble(stateObject4, "y");
            if (object7 != null && number != null) {
                annotationAttributes.setDrawOffset(new Point(((Double)object7).intValue(), ((Double)number).intValue()));
            }
        }
        if ((object7 = restorableSupport.getStateObject(stateObject, "insets")) != null) {
            number = restorableSupport.getStateValueAsInteger((RestorableSupport.StateObject)object7, "top");
            n3 = restorableSupport.getStateValueAsInteger((RestorableSupport.StateObject)object7, "left");
            n2 = restorableSupport.getStateValueAsInteger((RestorableSupport.StateObject)object7, "bottom");
            n = restorableSupport.getStateValueAsInteger((RestorableSupport.StateObject)object7, "right");
            if (number != null && n3 != null && n2 != null && n != null) {
                annotationAttributes.setInsets(new Insets((Integer)number, n3, n2, n));
            }
        }
        if ((number = restorableSupport.getStateValueAsDouble(stateObject, "borderWidth")) != null) {
            annotationAttributes.setBorderWidth((Double)number);
        }
        if ((n3 = restorableSupport.getStateValueAsInteger(stateObject, "borderStippleFactor")) != null) {
            annotationAttributes.setBorderStippleFactor(n3);
        }
        if ((n2 = restorableSupport.getStateValueAsInteger(stateObject, "borderStipplePattern")) != null) {
            annotationAttributes.setBorderStipplePattern(n2.shortValue());
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "antiAliasHint")) != null) {
            annotationAttributes.setAntiAliasHint(n);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "visible")) != null) {
            annotationAttributes.setVisible(bl);
        }
        if ((stateObject3 = restorableSupport.getStateObject(stateObject, "font")) != null) {
            object6 = restorableSupport.getStateValueAsString(stateObject3, "name");
            object5 = restorableSupport.getStateValueAsInteger(stateObject3, "style");
            object4 = restorableSupport.getStateValueAsInteger(stateObject3, "size");
            if (object6 != null && object5 != null && object4 != null) {
                annotationAttributes.setFont(new Font((String)object6, ((Integer)object5).intValue(), (Integer)object4));
            }
        }
        if ((object6 = restorableSupport.getStateValueAsInteger(stateObject, "textAlign")) != null) {
            annotationAttributes.setTextAlign((Integer)object6);
        }
        if ((object5 = restorableSupport.getStateValueAsString(stateObject, "textColor")) != null && (object4 = RestorableSupport.decodeColor((String)object5)) != null) {
            annotationAttributes.setTextColor((Color)object4);
        }
        if ((object4 = restorableSupport.getStateValueAsString(stateObject, "backgroundColor")) != null && (object3 = RestorableSupport.decodeColor((String)object4)) != null) {
            annotationAttributes.setBackgroundColor((Color)object3);
        }
        if ((object3 = restorableSupport.getStateValueAsString(stateObject, "borderColor")) != null && (object2 = RestorableSupport.decodeColor((String)object3)) != null) {
            annotationAttributes.setBorderColor((Color)object2);
        }
        if ((object2 = restorableSupport.getStateValueAsString(stateObject, "imagePath")) != null) {
            annotationAttributes.setImageSource(object2);
        }
        if ((d5 = restorableSupport.getStateValueAsDouble(stateObject, "imageScale")) != null) {
            annotationAttributes.setImageScale(d5);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "imageOffset")) != null) {
            d4 = restorableSupport.getStateValueAsDouble(stateObject2, "x");
            object = restorableSupport.getStateValueAsDouble(stateObject2, "y");
            if (d4 != null && object != null) {
                annotationAttributes.setImageOffset(new Point(d4.intValue(), ((Double)object).intValue()));
            }
        }
        if ((d4 = restorableSupport.getStateValueAsDouble(stateObject, "imageOpacity")) != null) {
            annotationAttributes.setImageOpacity(d4);
        }
        if ((object = restorableSupport.getStateValueAsString(stateObject, "imageRepeat")) != null) {
            annotationAttributes.setImageRepeat((String)object);
        }
        if ((d3 = restorableSupport.getStateValueAsDouble(stateObject, "distanceMinScale")) != null) {
            annotationAttributes.setDistanceMinScale(d3);
        }
        if ((d2 = restorableSupport.getStateValueAsDouble(stateObject, "distanceMaxScale")) != null) {
            annotationAttributes.setDistanceMaxScale(d2);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "distanceMinOpacity")) != null) {
            annotationAttributes.setDistanceMinOpacity(d);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "effect")) != null) {
            annotationAttributes.setEffect(string);
        }
    }

    static {
        defaults.setFrameShape("Render.FrameFactory.ShapeRectangle");
        defaults.setSize(new Dimension(160, 0));
        defaults.setScale(1.0);
        defaults.setOpacity(1.0);
        defaults.setLeader("Render.FrameFactory.LeaderTriangle");
        defaults.setCornerRadius(6);
        defaults.setAdjustWidthToText("render.Annotation.SizeFitText");
        defaults.setDrawOffset(new Point(-10, 20));
        defaults.setHighlightScale(1.2);
        defaults.setInsets(new Insets(6, 6, 6, 6));
        defaults.setFont(Font.decode("Arial-PLAIN-12"));
        defaults.setTextAlign(0);
        defaults.setTextColor(new Color(1.0f, 1.0f, 1.0f, 0.8f));
        defaults.setBackgroundColor(new Color(0.0f, 0.0f, 0.0f, 0.4f));
        defaults.setBorderColor(new Color(1.0f, 1.0f, 1.0f, 0.7f));
        defaults.setBorderWidth(1.0);
        defaults.setBorderStippleFactor(0);
        defaults.setBorderStipplePattern((short)-21846);
        defaults.setAntiAliasHint(4353);
        defaults.setImageScale(1.0);
        defaults.setImageOffset(new Point(0, 0));
        defaults.setImageOpacity(0.7);
        defaults.setImageRepeat("render.Annotation.RepeatXY");
        defaults.setDistanceMinScale(0.5);
        defaults.setDistanceMaxScale(2.0);
        defaults.setDistanceMinOpacity(0.3);
        defaults.setEffect("render.MultiLineTextRenderer.EffectNone");
    }
}

