/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.rpf.wizard;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.rpf.RPFFileIndex;
import gov.nasa.worldwind.layers.rpf.RPFTiledImageProcessor;
import gov.nasa.worldwind.layers.rpf.wizard.ETRCalculator;
import gov.nasa.worldwind.layers.rpf.wizard.FileSet;
import gov.nasa.worldwind.layers.rpf.wizard.ProgressPanel;
import gov.nasa.worldwind.layers.rpf.wizard.RPFWizardUtil;
import gov.nasa.worldwind.layers.rpf.wizard.TimeFormatter;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.wizard.DefaultPanelDescriptor;
import gov.nasa.worldwind.util.wizard.Wizard;
import gov.nasa.worldwind.util.wizard.WizardModel;
import gov.nasa.worldwind.util.wizard.WizardProperties;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class PreprocessPanelDescriptor
extends DefaultPanelDescriptor {
    private ProgressPanel panelComponent;
    private RPFTiledImageProcessor preprocessor;
    private Thread workerThread;
    private int numSteps;
    private final AtomicInteger stepsTaken = new AtomicInteger(0);
    private final AtomicInteger stepsWithErrors = new AtomicInteger(0);
    private final ETRCalculator etrCalc = new ETRCalculator();
    public static final String IDENTIFIER = "gov.nasa.worldwind.rpf.wizard.PreprocessPanel";
    public static final String THREAD_POOL_SIZE = "gov.nasa.worldwind.rpf.wizard.ThreadPoolSize";
    public static final String STEPS_NEEDED_FOR_ESTIMATE = "gov.nasa.worldwind.rpf.wizard.StepsNeededForEstimate";
    private static final int DEFAULT_THREAD_POOL_SIZE = 3;
    private static final int DEFAULT_STEPS_NEEDED_FOR_ESTIMATE = 20;

    public PreprocessPanelDescriptor() {
        int n = Configuration.getIntegerValue(THREAD_POOL_SIZE, 3);
        int n2 = Configuration.getIntegerValue(STEPS_NEEDED_FOR_ESTIMATE, 20);
        this.panelComponent = new ProgressPanel();
        this.preprocessor = new RPFTiledImageProcessor();
        this.preprocessor.setThreadPoolSize(n);
        this.preprocessor.addPropertyChangeListener(new PropertyEvents());
        this.etrCalc.setStepsNeededForEstimate(n2);
        this.setPanelIdentifier(IDENTIFIER);
        this.setPanelComponent(this.panelComponent);
    }

    public Object getBackPanelDescriptor() {
        return null;
    }

    public Object getNextPanelDescriptor() {
        return Wizard.FINISH;
    }

    public void aboutToDisplayPanel() {
        this.panelComponent.getProgressBar().setMinimum(0);
        this.panelComponent.getProgressBar().setMaximum(0);
        this.panelComponent.getProgressBar().setValue(0);
        this.panelComponent.setProgressDescription1(" ");
        this.panelComponent.setProgressDescription2(" ");
    }

    public void displayingPanel() {
        WizardModel wizardModel = this.getWizardModel();
        final List<FileSet> list = RPFWizardUtil.getFileSetList(wizardModel);
        final File file = RPFWizardUtil.getSelectedFile(wizardModel);
        if (list != null && file != null) {
            this.panelComponent.setTitle(RPFWizardUtil.makeLarger("Importing Imagery"));
            this.panelComponent.setDescription("");
            this.panelComponent.getProgressBar().setVisible(true);
            if (wizardModel != null) {
                wizardModel.setNextButtonEnabled(false);
            }
            this.startWorkerThread(new Runnable(){

                public void run() {
                    ArrayList<FileSet> arrayList = new ArrayList<FileSet>();
                    for (FileSet fileSet : list) {
                        if (!fileSet.isSelected()) continue;
                        arrayList.add(fileSet);
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        FileSet fileSet;
                        fileSet = (FileSet)arrayList.get(i);
                        PreprocessPanelDescriptor.this.preprocess(file, fileSet, i + 1, arrayList.size());
                    }
                    PreprocessPanelDescriptor.this.finished();
                }
            });
        } else {
            this.panelComponent.setTitle(RPFWizardUtil.makeLarger("No Imagery to Import"));
            this.panelComponent.setDescription("No Imagery");
            this.panelComponent.getProgressBar().setVisible(false);
        }
    }

    public void aboutToHidePanel() {
        Wizard wizard = this.getWizard();
        if ((wizard == null || wizard.getReturnCode() != 0) && this.preprocessor != null) {
            this.preprocessor.stop();
        }
    }

    private void preprocess(File file, FileSet fileSet, int n, int n2) {
        List<Layer> list;
        Object object;
        long l = System.currentTimeMillis();
        RPFFileIndex rPFFileIndex = null;
        Layer layer = null;
        try {
            object = this.makeDescription(fileSet, n, n2);
            if (file != null && fileSet != null) {
                list = this.makeSubStepDescription((String)object, "Processing Image Files");
                this.panelComponent.setDescription(RPFWizardUtil.makeBold((String)((Object)list)));
                rPFFileIndex = this.preprocessor.makeFileIndex(file, fileSet.getIdentifier(), fileSet.getTitle(), fileSet.getFiles());
                fileSet.setProperty("filesProcessed", this.stepsTaken.intValue());
                fileSet.setProperty("filesWithErrors", this.stepsWithErrors.intValue());
            }
            if (rPFFileIndex != null) {
                list = this.makeSubStepDescription((String)object, "Generating Overview Imagery");
                this.panelComponent.setDescription(RPFWizardUtil.makeBold((String)((Object)list)));
                layer = this.preprocessor.makeLayer(rPFFileIndex);
            }
        }
        catch (Exception exception) {
            list = "Exception while preprocessing: " + (fileSet != null ? fileSet.getTitle() : "null");
            Logging.logger().log(Level.SEVERE, (String)((Object)list), exception);
            layer = null;
        }
        object = this.getWizardModel();
        if (layer != null && object != null) {
            list = RPFWizardUtil.getLayerList((WizardProperties)object);
            if (list == null) {
                list = new ArrayList<Layer>();
                RPFWizardUtil.setLayerList((WizardProperties)object, list);
            }
            list.add(layer);
        }
        long l2 = System.currentTimeMillis();
        String string = String.format("Preprocessor completed '%s' in %,d (millis)", fileSet != null ? fileSet.getTitle() : "null", l2 - l);
        Logging.logger().fine(string);
    }

    private void finished() {
        this.panelComponent.setTitle(RPFWizardUtil.makeLarger("Finished"));
        this.panelComponent.setDescription(this.makeFinishedDescription());
        this.panelComponent.getProgressBar().setMinimum(0);
        this.panelComponent.getProgressBar().setMaximum(0);
        this.panelComponent.getProgressBar().setValue(0);
        this.panelComponent.getProgressBar().setVisible(false);
        this.panelComponent.setProgressDescription1(" ");
        this.panelComponent.setProgressDescription2(" ");
        WizardModel wizardModel = this.getWizardModel();
        if (wizardModel != null) {
            wizardModel.setNextButtonEnabled(true);
        }
    }

    private void beginTask() {
        this.stepsTaken.set(0);
        this.stepsWithErrors.set(0);
        this.etrCalc.setStartTime(System.currentTimeMillis());
    }

    private void endTask() {
        this.panelComponent.setProgressDescription1(" ");
        this.panelComponent.setProgressDescription2(" ");
    }

    private void stepsForTask(int n) {
        this.numSteps = n;
    }

    private void stepComplete(String string, boolean bl) {
        int n = this.stepsTaken.incrementAndGet();
        if (!bl) {
            this.stepsWithErrors.incrementAndGet();
        }
        int n2 = this.numSteps;
        this.etrCalc.setStep(n);
        this.etrCalc.setNumSteps(n2);
        long l = this.etrCalc.getEstimatedTimeRemaining();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        int n3 = this.stepsWithErrors.get();
        if (n3 > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(this.formatFileCount(n3)).append(" with errors");
        }
        this.setProgressMessage(stringBuilder.toString());
        this.setProgress(n, n2, l);
    }

    private void setProgress(int n, int n2, long l) {
        if (n >= 0 && n < n2) {
            this.panelComponent.getProgressBar().setValue(n);
            this.panelComponent.getProgressBar().setMaximum(n2);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("%,d of %,d", n, n2));
            if (l > 0L) {
                TimeFormatter timeFormatter = new TimeFormatter();
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" - ");
                }
                stringBuilder.append(timeFormatter.formatEstimate(l));
            }
            this.panelComponent.setProgressDescription2(stringBuilder.toString());
        } else {
            this.panelComponent.getProgressBar().setValue(0);
            this.panelComponent.getProgressBar().setMaximum(0);
            this.panelComponent.setProgressDescription2(" ");
        }
    }

    private void setProgressMessage(String string) {
        this.panelComponent.setProgressDescription1(string);
    }

    private String formatFileCount(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("%,d", n));
        stringBuilder.append(" file");
        if (n != 1) {
            stringBuilder.append("s");
        }
        return stringBuilder.toString();
    }

    private String makeDescription(FileSet fileSet, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Importing ");
        if (fileSet != null && fileSet.getTitle() != null) {
            stringBuilder.append("'");
            stringBuilder.append(fileSet.getTitle());
            stringBuilder.append("'");
        }
        if (n2 > 1) {
            stringBuilder.append(" (").append(n).append(" of ").append(n2).append(")");
        }
        return stringBuilder.toString();
    }

    private String makeSubStepDescription(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<br>");
        stringBuilder.append(string);
        stringBuilder.append("<br><br><br>");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private String makeFinishedDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<br>");
        stringBuilder.append("<font size=\"+1\">");
        stringBuilder.append("Import Imagery Complete");
        stringBuilder.append("</font>");
        stringBuilder.append("<br><br>");
        WizardModel wizardModel = this.getWizardModel();
        List<FileSet> list = RPFWizardUtil.getFileSetList(wizardModel);
        if (list != null) {
            for (FileSet fileSet : list) {
                if (fileSet == null || !fileSet.isSelected()) continue;
                stringBuilder.append("<b>");
                stringBuilder.append(fileSet.getTitle());
                stringBuilder.append("</b>");
                Integer n = fileSet.getIntegerProperty("filesProcessed");
                Integer n2 = fileSet.getIntegerProperty("filesWithErrors");
                if (n != null && n2 != null) {
                    int n3 = n - n2;
                    stringBuilder.append("<br>");
                    stringBuilder.append("<font size=\"-2\">");
                    stringBuilder.append(this.formatFileCount(n3)).append(" imported");
                    if (n2 > 0) {
                        stringBuilder.append("; ");
                        stringBuilder.append("<font color=#990000>");
                        stringBuilder.append(this.formatFileCount(n2)).append(" with errors");
                        stringBuilder.append("</font>");
                    }
                    stringBuilder.append("</font>");
                }
                stringBuilder.append("<br><br>");
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private void startWorkerThread(Runnable runnable) {
        this.killWorkerThread();
        this.workerThread = new Thread(runnable);
        this.workerThread.start();
    }

    private void killWorkerThread() {
        if (this.workerThread != null && this.workerThread.isAlive()) {
            this.workerThread.interrupt();
        }
        this.workerThread = null;
    }

    private class PropertyEvents
    implements PropertyChangeListener {
        private PropertyEvents() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent != null && propertyChangeEvent.getPropertyName() != null) {
                if (propertyChangeEvent.getPropertyName().equals("BeginSubTask")) {
                    PreprocessPanelDescriptor.this.beginTask();
                } else if (propertyChangeEvent.getPropertyName().equals("EndSubTask")) {
                    PreprocessPanelDescriptor.this.endTask();
                } else if (propertyChangeEvent.getPropertyName().equals("SubTaskNumSteps")) {
                    PreprocessPanelDescriptor.this.stepsForTask((Integer)propertyChangeEvent.getNewValue());
                } else if (propertyChangeEvent.getPropertyName().equals("SubTaskStepComplete")) {
                    PreprocessPanelDescriptor.this.stepComplete(propertyChangeEvent.getNewValue().toString(), true);
                } else if (propertyChangeEvent.getPropertyName().equals("SubTaskStepFailed")) {
                    PreprocessPanelDescriptor.this.stepComplete(propertyChangeEvent.getNewValue().toString(), false);
                }
            }
        }
    }
}

