/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.rpf.wizard;

import gov.nasa.worldwind.layers.rpf.wizard.FileSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataChooserPanel
extends JPanel {
    private JLabel title;
    private JLabel description;
    private Collection<FileSet> fileSetList;
    private PropertyEvents propertyEvents = new PropertyEvents();
    private Map<FileSet, JToggleButton> selectButtons;
    private JComponent dataPanel;
    private JButton selectAllButton;
    private JButton deselectAllButton;
    private JScrollPane dataScrollPane;
    private JLabel dataDescription;

    public DataChooserPanel() {
        this.makeComponents();
        this.layoutComponents();
    }

    public String getTitle() {
        return this.title.getText();
    }

    public void setTitle(String string) {
        this.title.setText(string);
    }

    public String getDescription() {
        return this.description.getText();
    }

    public void setDescription(String string) {
        this.description.setText(string);
    }

    public String getDataDescription() {
        return this.dataDescription.getText();
    }

    public void setDataDescription(String string) {
        this.dataDescription.setText(string);
    }

    public void setFileSetList(Collection<FileSet> collection) {
        this.removeListeners(this.fileSetList);
        this.fileSetList = collection;
        this.addListeners(this.fileSetList);
        this.selectButtons = new HashMap<FileSet, JToggleButton>();
        if (collection != null && collection.size() > 0) {
            Box box = Box.createVerticalBox();
            for (FileSet fileSet : collection) {
                JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.putClientProperty("fileSet", fileSet);
                jCheckBox.setSelected(fileSet.isSelected());
                jCheckBox.setText(this.makeTitle(fileSet));
                jCheckBox.setAlignmentX(0.0f);
                jCheckBox.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        DataChooserPanel.this.fileSetClicked(itemEvent);
                    }
                });
                box.add(jCheckBox);
                this.selectButtons.put(fileSet, jCheckBox);
            }
            this.dataScrollPane.setViewportView(box);
            this.dataPanel.setVisible(true);
        } else {
            this.dataScrollPane.setViewportView(null);
            this.dataPanel.setVisible(false);
        }
        this.dataPanel.validate();
        this.fileSetSelectionChanged(null);
    }

    private String makeTitle(FileSet fileSet) {
        String string = null;
        if (fileSet != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            if (fileSet.getTitle() != null) {
                stringBuilder.append(fileSet.getTitle());
            } else if (fileSet.getIdentifier() != null) {
                stringBuilder.append(fileSet.getIdentifier());
            } else {
                stringBuilder.append("Various");
            }
            int n = fileSet.getFileCount();
            if (n > 0) {
                stringBuilder.append("<font size=\"-2\">");
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" - ");
                }
                stringBuilder.append(String.format("%,d", n)).append(" file").append(n > 1 ? "s" : "");
                stringBuilder.append("</font>");
            }
            stringBuilder.append("</html>");
            string = stringBuilder.toString();
        }
        return string;
    }

    private void fileSetClicked(ItemEvent itemEvent) {
        if (itemEvent != null) {
            Object object;
            FileSet fileSet = null;
            if (itemEvent.getItem() != null && itemEvent.getItem() instanceof JComponent && (object = ((JComponent)itemEvent.getItem()).getClientProperty("fileSet")) != null && object instanceof FileSet) {
                fileSet = (FileSet)object;
            }
            if (fileSet != null) {
                if (itemEvent.getStateChange() == 1) {
                    fileSet.setSelected(true);
                } else if (itemEvent.getStateChange() == 2) {
                    fileSet.setSelected(false);
                }
            }
        }
    }

    private void setAllSelected(boolean bl) {
        if (this.fileSetList != null) {
            for (FileSet fileSet : this.fileSetList) {
                fileSet.setSelected(bl);
            }
        }
    }

    private void selectAllPressed() {
        this.setAllSelected(true);
    }

    private void deselectAllPressed() {
        this.setAllSelected(false);
    }

    private void fileSetSelectionChanged(Object object) {
        FileSet fileSet;
        JToggleButton jToggleButton;
        if (object != null && object instanceof FileSet && (jToggleButton = this.selectButtons.get(fileSet = (FileSet)object)) != null) {
            jToggleButton.setSelected(fileSet.isSelected());
        }
        boolean bl = true;
        boolean bl2 = false;
        if (this.fileSetList != null) {
            for (FileSet fileSet2 : this.fileSetList) {
                bl &= fileSet2.isSelected();
                bl2 |= fileSet2.isSelected();
            }
        }
        this.selectAllButton.setEnabled(!bl);
        this.deselectAllButton.setEnabled(bl2);
    }

    private void addListeners(Collection<FileSet> collection) {
        if (collection != null) {
            for (FileSet fileSet : collection) {
                fileSet.addPropertyChangeListener(this.propertyEvents);
            }
        }
    }

    private void removeListeners(Collection<FileSet> collection) {
        if (collection != null) {
            for (FileSet fileSet : collection) {
                fileSet.removePropertyChangeListener(this.propertyEvents);
            }
        }
    }

    private void makeComponents() {
        this.title = new JLabel(" ");
        this.title.setBackground(Color.gray);
        this.title.setOpaque(true);
        this.description = new JLabel();
        this.dataPanel = Box.createVerticalBox();
        this.selectAllButton = new JButton("Select All");
        this.deselectAllButton = new JButton("Select None");
        Font font = this.selectAllButton.getFont();
        font = new Font(font.getName(), font.getStyle(), 9);
        Dimension dimension = new Dimension(35, 20);
        this.selectAllButton.setFont(font);
        this.selectAllButton.setPreferredSize(dimension);
        this.selectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataChooserPanel.this.selectAllPressed();
            }
        });
        this.deselectAllButton.setFont(font);
        this.deselectAllButton.setPreferredSize(dimension);
        this.deselectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataChooserPanel.this.deselectAllPressed();
            }
        });
        this.dataScrollPane = new JScrollPane();
        this.dataScrollPane.setHorizontalScrollBarPolicy(31);
        dimension = this.dataScrollPane.getPreferredSize();
        this.dataScrollPane.setPreferredSize(new Dimension(dimension.width, Short.MAX_VALUE));
        this.dataScrollPane.setOpaque(false);
        this.dataScrollPane.getViewport().setOpaque(false);
        this.dataDescription = new JLabel(" ");
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(this.title.getBackground());
        this.title.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)this.title, "West");
        jPanel.add((Component)new JSeparator(), "South");
        this.add((Component)jPanel, "North");
        Box box = Box.createVerticalBox();
        box.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.description.setAlignmentX(0.0f);
        box.add(this.description);
        box.add(Box.createVerticalStrut(10));
        this.dataPanel.setAlignmentX(0.0f);
        Box box2 = Box.createHorizontalBox();
        box2.setAlignmentX(0.0f);
        box2.add(this.selectAllButton);
        box2.add(Box.createHorizontalStrut(2));
        box2.add(new JSeparator(1));
        box2.add(Box.createHorizontalStrut(2));
        box2.add(this.deselectAllButton);
        box2.add(Box.createHorizontalStrut(Short.MAX_VALUE));
        this.dataPanel.add(box2);
        this.dataPanel.add(Box.createVerticalStrut(5));
        this.dataScrollPane.setAlignmentX(0.0f);
        this.dataPanel.add(this.dataScrollPane);
        box.add(this.dataPanel);
        box.add(Box.createVerticalStrut(5));
        this.dataPanel.setVisible(false);
        this.dataDescription.setAlignmentX(0.0f);
        box.add(this.dataDescription);
        this.add((Component)box, "Center");
    }

    private class PropertyEvents
    implements PropertyChangeListener {
        private PropertyEvents() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string;
            if (propertyChangeEvent != null && propertyChangeEvent.getPropertyName() != null && (string = propertyChangeEvent.getPropertyName()).equals("fileSet.Selected")) {
                DataChooserPanel.this.fileSetSelectionChanged(propertyChangeEvent.getSource());
                DataChooserPanel.this.firePropertyChange(string, null, propertyChangeEvent.getSource());
            }
        }
    }
}

