/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.WWObject;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.util.Logging;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerList
extends CopyOnWriteArrayList<Layer>
implements WWObject {
    private WWObjectImpl wwo = new WWObjectImpl(this);

    public LayerList() {
    }

    public LayerList(Layer[] layerArray) {
        if (layerArray == null) {
            String string = Logging.getMessage("nullValue.LayersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (Layer layer : layerArray) {
            this.add(layer);
        }
    }

    @Override
    public Object clone() {
        LayerList layerList = (LayerList)super.clone();
        layerList.wwo = new WWObjectImpl(layerList);
        for (Layer layer : layerList) {
            layer.removePropertyChangeListener(this);
        }
        return layerList;
    }

    @Override
    public boolean add(Layer layer) {
        if (layer == null) {
            String string = Logging.getMessage("nullValue.LayerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        super.add(layer);
        layer.addPropertyChangeListener(this);
        this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", null, this);
        return true;
    }

    @Override
    public void add(int n, Layer layer) {
        if (layer == null) {
            String string = Logging.getMessage("nullValue.LayerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        super.add(n, layer);
        layer.addPropertyChangeListener(this);
        this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", null, this);
    }

    public void remove(Layer layer) {
        if (layer == null) {
            String string = Logging.getMessage("nullValue.LayerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.contains(layer)) {
            return;
        }
        layer.removePropertyChangeListener(this);
        super.remove(layer);
        this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", null, this);
    }

    @Override
    public Layer remove(int n) {
        Layer layer = (Layer)this.get(n);
        if (layer == null) {
            return null;
        }
        layer.removePropertyChangeListener(this);
        super.remove(n);
        this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", null, this);
        return layer;
    }

    @Override
    public Layer set(int n, Layer layer) {
        if (layer == null) {
            String string = Logging.getMessage("nullValue.LayerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Layer layer2 = (Layer)this.get(n);
        if (layer2 != null) {
            layer2.removePropertyChangeListener(this);
        }
        super.set(n, layer);
        layer.addPropertyChangeListener(this);
        this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", null, this);
        return layer2;
    }

    @Override
    public boolean remove(Object object) {
        for (Layer layer : this) {
            if (!layer.equals(object)) continue;
            layer.removePropertyChangeListener(this);
        }
        boolean bl = super.remove(object);
        if (bl) {
            this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", null, this);
        }
        return bl;
    }

    @Override
    public boolean addIfAbsent(Layer layer) {
        for (Layer layer2 : this) {
            if (!layer2.equals(layer)) continue;
            return false;
        }
        layer.addPropertyChangeListener(this);
        boolean bl = super.addIfAbsent(layer);
        if (bl) {
            this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", null, this);
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        for (Layer layer : this) {
            layer.removePropertyChangeListener(this);
        }
        boolean bl = super.removeAll(collection);
        if (bl) {
            this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", null, this);
        }
        return bl;
    }

    @Override
    public int addAllAbsent(Collection<? extends Layer> collection) {
        for (Layer layer : collection) {
            if (this.contains(layer)) continue;
            layer.addPropertyChangeListener(this);
        }
        int n = super.addAllAbsent(collection);
        if (n > 0) {
            this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", null, this);
        }
        return n;
    }

    @Override
    public boolean addAll(Collection<? extends Layer> collection) {
        boolean bl = super.addAll(collection);
        if (bl) {
            this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", null, this);
        }
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends Layer> collection) {
        for (Layer layer : collection) {
            layer.addPropertyChangeListener(this);
        }
        boolean bl = super.addAll(n, collection);
        if (bl) {
            this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", null, this);
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        for (Layer layer : this) {
            if (collection.contains(layer)) continue;
            layer.removePropertyChangeListener(this);
        }
        boolean bl = super.retainAll(collection);
        if (bl) {
            this.firePropertyChange("gov.nasa.worldwind.avkey.LayersObject", null, this);
        }
        return bl;
    }

    @Override
    public Object getValue(String string) {
        return this.wwo.getValue(string);
    }

    @Override
    public Collection<Object> getValues() {
        return this.wwo.getValues();
    }

    @Override
    public Set<Map.Entry<String, Object>> getEntries() {
        return this.wwo.getEntries();
    }

    @Override
    public String getStringValue(String string) {
        return this.wwo.getStringValue(string);
    }

    @Override
    public void setValue(String string, Object object) {
        this.wwo.setValue(string, object);
    }

    @Override
    public void setValues(AVList aVList) {
        this.wwo.setValues(aVList);
    }

    @Override
    public boolean hasKey(String string) {
        return this.wwo.hasKey(string);
    }

    @Override
    public void removeKey(String string) {
        this.wwo.removeKey(string);
    }

    @Override
    public AVList copy() {
        return this.wwo.copy();
    }

    @Override
    public AVList clearList() {
        return this.wwo.clearList();
    }

    public LayerList sort() {
        if (this.size() <= 0) {
            return this;
        }
        Layer[] layerArray = new Layer[this.size()];
        this.toArray(layerArray);
        Arrays.sort(layerArray, new Comparator<Layer>(){

            @Override
            public int compare(Layer layer, Layer layer2) {
                return layer.getName().compareTo(layer2.getName());
            }
        });
        this.clear();
        for (Layer layer : layerArray) {
            super.add(layer);
        }
        return this;
    }

    @Override
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.wwo.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.wwo.removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.wwo.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.wwo.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.wwo.firePropertyChange(propertyChangeEvent);
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
        this.wwo.firePropertyChange(string, object, object2);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.wwo.propertyChange(propertyChangeEvent);
    }

    @Override
    public String toString() {
        String string = "";
        for (Layer layer : this) {
            string = string + layer.toString() + ", ";
        }
        return string;
    }
}

