/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.IconRenderer;
import gov.nasa.worldwind.render.Pedestal;
import gov.nasa.worldwind.render.WWIcon;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconLayer
extends AbstractLayer {
    private final Collection<WWIcon> icons = new ConcurrentLinkedQueue<WWIcon>();
    private Iterable<WWIcon> iconsOverride;
    private IconRenderer iconRenderer = new IconRenderer();
    private Pedestal pedestal;

    public void addIcon(WWIcon wWIcon) {
        if (wWIcon == null) {
            String string = Logging.getMessage("nullValue.Icon");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.iconsOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.icons.add(wWIcon);
    }

    public void addIcons(Iterable<WWIcon> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.iconsOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        for (WWIcon wWIcon : iterable) {
            if (wWIcon == null) continue;
            this.icons.add(wWIcon);
        }
    }

    public void removeIcon(WWIcon wWIcon) {
        if (wWIcon == null) {
            String string = Logging.getMessage("nullValue.Icon");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.iconsOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.icons.remove(wWIcon);
    }

    public void removeAllIcons() {
        if (this.iconsOverride != null) {
            String string = Logging.getMessage("generic.LayerIsUsingCustomIterable");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.clearIcons();
    }

    private void clearIcons() {
        if (this.icons != null && this.icons.size() > 0) {
            this.icons.clear();
        }
    }

    public Iterable<WWIcon> getIcons() {
        return this.getActiveIcons();
    }

    private Iterable<WWIcon> getActiveIcons() {
        if (this.iconsOverride != null) {
            return this.iconsOverride;
        }
        return Collections.unmodifiableCollection(this.icons);
    }

    public void setIcons(Iterable<WWIcon> iterable) {
        this.iconsOverride = iterable;
        this.clearIcons();
    }

    public Pedestal getPedestal() {
        return this.pedestal;
    }

    public void setPedestal(Pedestal pedestal) {
        this.pedestal = pedestal;
    }

    @Override
    protected void doPick(DrawContext drawContext, Point point) {
        this.iconRenderer.setPedestal(this.pedestal);
        this.iconRenderer.pick(drawContext, this.getActiveIcons(), point, this);
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        this.iconRenderer.setPedestal(this.pedestal);
        this.iconRenderer.render(drawContext, this.getActiveIcons());
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.IconLayer.Name");
    }
}

