/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import javax.media.opengl.GL;

public class FogLayer
extends RenderableLayer {
    private float[] fogColor = new float[]{0.66f, 0.7f, 0.81f, 1.0f};
    private float nearFactor = 1.1f;
    private float farFactor = 1.1f;

    public FogLayer() {
        this.setName(Logging.getMessage("layers.Earth.FogLayer.Name"));
    }

    public Color getColor() {
        return new Color(this.fogColor[0], this.fogColor[1], this.fogColor[2], this.fogColor[3]);
    }

    public void setColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        color.getColorComponents(this.fogColor);
    }

    public float getNearFactor() {
        return this.nearFactor;
    }

    public void setNearFactor(float f) {
        this.nearFactor = f;
    }

    public float getFarFactor() {
        return this.farFactor;
    }

    public void setFarFactor(float f) {
        this.farFactor = f;
    }

    public void doRender(DrawContext drawContext) {
        Position position = drawContext.getView().getEyePosition();
        if (position == null) {
            return;
        }
        float f = (float)position.getElevation();
        f = f < 100.0f ? 100.0f : f;
        float f2 = f * this.nearFactor;
        float f3 = (float)(drawContext.getView().computeHorizonDistance() * (double)this.farFactor);
        GL gL = drawContext.getGL();
        gL.glFogfv(2918, this.fogColor, 0);
        gL.glFogi(2917, 9729);
        gL.glFogf(2915, f2);
        gL.glFogf(2916, f3);
        gL.glHint(3156, 4352);
        gL.glEnable(2912);
    }

    public String toString() {
        return this.getName();
    }
}

