/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.BasicTiledImageLayer;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileUrlBuilder;
import java.net.MalformedURLException;
import java.net.URL;

public class NAIPCalifornia
extends BasicTiledImageLayer {
    public NAIPCalifornia() {
        super(NAIPCalifornia.makeLevels(new URLBuilder()));
        this.setUseTransparentTextures(true);
        this.setValue("gov.nasa.worldwind.avkey.URLConnectTimeout", 20000);
        this.setValue("gov.nasa.worldwind.avkey.URLReadTimeout", 20000);
        this.setValue("gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit", 30000);
        this.setAvailableImageFormats(new String[]{"image/png"});
    }

    private static LevelSet makeLevels(URLBuilder uRLBuilder) {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", "Earth/NAIP/California");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", "http://giifmap.cnr.berkeley.edu/cgi-bin/naip.wms");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", "naip2005C");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".dds");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", 14);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon(Angle.fromDegrees(36.0), Angle.fromDegrees(36.0)));
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", Sector.fromDegrees(32.2006, 42.0421, -124.45, -113.222));
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", uRLBuilder);
        return new LevelSet(aVListImpl);
    }

    public String toString() {
        return Logging.getMessage("layers.Earth.NAIP.California.Name");
    }

    private static class URLBuilder
    implements TileUrlBuilder {
        private URLBuilder() {
        }

        public URL getURL(Tile tile, String string) throws MalformedURLException {
            StringBuffer stringBuffer = new StringBuffer(tile.getLevel().getService());
            if (stringBuffer.lastIndexOf("?") != stringBuffer.length() - 1) {
                stringBuffer.append("?");
            }
            stringBuffer.append("service=WMS");
            stringBuffer.append("&request=GetMap");
            stringBuffer.append("&version=1.1.1");
            stringBuffer.append("&srs=EPSG:4326");
            stringBuffer.append("&layers=");
            stringBuffer.append(tile.getLevel().getDataset());
            stringBuffer.append("&styles=default");
            stringBuffer.append("&width=");
            stringBuffer.append(tile.getLevel().getTileWidth());
            stringBuffer.append("&height=");
            stringBuffer.append(tile.getLevel().getTileHeight());
            stringBuffer.append("&format=image/png");
            stringBuffer.append("&transparent=true");
            stringBuffer.append("&bgcolor=0x000000");
            Sector sector = tile.getSector();
            stringBuffer.append("&bbox=");
            stringBuffer.append(sector.getMinLongitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMinLatitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMaxLongitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMaxLatitude().getDegrees());
            return new URL(stringBuffer.toString());
        }
    }
}

