/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.wms.WMSTiledImageLayer;
import java.util.GregorianCalendar;

public class BMNGWMSLayer
extends WMSTiledImageLayer {
    private static final int DEFAULT_MONTH = 5;

    public BMNGWMSLayer() {
        this(5);
    }

    public BMNGWMSLayer(int n) {
        super(BMNGWMSLayer.makeXmlState(n));
        this.setValue("gov.nasa.worldwind.avkey.URLReadTimeout", 30000);
        this.setValue("gov.nasa.worldwind.avkey.DisplayName", String.format("BlueMarble (WMS) %02d/2004", n));
        this.setForceLevelZeroLoads(true);
        this.setRetainLevelZeroTiles(true);
        this.setUseMipMaps(true);
        this.setAvailableImageFormats(new String[]{"image/png", "image/dds"});
    }

    private static String makeXmlState(int n) {
        long l = new GregorianCalendar(2008, 3, 9).getTimeInMillis();
        String string = n + "";
        String string2 = String.format("%02d", n);
        String string3 = new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?><restorableState><stateObject name=\"gov.nasa.worldwind.avkey.NumEmptyLevels\">0</stateObject><stateObject name=\"gov.nasa.worldwind.avkey.ImageFormat\">image/dds</stateObject><stateObject name=\"gov.nasa.worldwind.avkey.DataCacheNameKey\">Earth/BMNGWMS/BMNG(Shaded + Bathymetry) Tiled - Version 1.1 - " + string + ".2004</stateObject>" + "<stateObject name=\"gov.nasa.worldwind.avkey.ServiceURLKey\">http://www.nasa.network.com/wms?SERVICE=WMS&amp;</stateObject>" + "<stateObject name=\"gov.nasa.worldwind.avkey.Title\">Blue Marble " + string2 + "/2004</stateObject>" + "<stateObject name=\"gov.nasa.worldwind.avkey.NumLevels\">5</stateObject>" + "<stateObject name=\"gov.nasa.worldwind.avkey.FormatSuffixKey\">.dds</stateObject>" + "<stateObject name=\"gov.nasa.worldwind.avkey.LevelZeroTileDelta.Latitude\">36.0</stateObject>" + "<stateObject name=\"gov.nasa.worldwind.avkey.LevelZeroTileDelta.Longitude\">36.0</stateObject>" + "<stateObject name=\"gov.nasa.worldwind.avkey.DatasetNameKey\">bmng2004" + string2 + "</stateObject>" + "<stateObject name=\"gov.nasa.worldwind.avkey.TileHeightKey\">512</stateObject>" + "<stateObject name=\"gov.nasa.worldwind.avkey.TileWidthKey\">512</stateObject>" + "<stateObject name=\"gov.nasa.worldwind.avkey.LayerNames\">|bmng2004" + string2 + "</stateObject>" + "<stateObject name=\"gov.nasa.worldwind.avKey.Sector.MinLatitude\">-90.0</stateObject>" + "<stateObject name=\"gov.nasa.worldwind.avKey.Sector.MaxLatitude\">90.0</stateObject>" + "<stateObject name=\"gov.nasa.worldwind.avKey.Sector.MinLongitude\">-180.0</stateObject>" + "<stateObject name=\"gov.nasa.worldwind.avKey.Sector.MaxLongitude\">180.0</stateObject>" + "<stateObject name=\"gov.nasa.worldwind.avkey.ExpiryTime\">" + l + "</stateObject>" + "<stateObject name=\"wms.UseTransparentTextures\">false</stateObject>" + "<stateObject name=\"wms.LayerName\">BlueMarbleNG " + string2 + "/2004</stateObject>" + "<stateObject name=\"wms.LayerEnabled\">true</stateObject>" + "</restorableState>");
        return string3;
    }
}

