/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.formats.dds.DDSConverter;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.TextureTile;
import gov.nasa.worldwind.layers.TiledImageLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.retrieve.HTTPRetriever;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.retrieve.URLRetriever;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class BasicTiledImageLayer
extends TiledImageLayer {
    private final Object fileLock = new Object();

    public BasicTiledImageLayer(LevelSet levelSet) {
        super(levelSet);
        if (!WorldWind.getMemoryCacheSet().containsCache(TextureTile.class.getName())) {
            long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.TextureTileCacheSize", 3000000L);
            BasicMemoryCache basicMemoryCache = new BasicMemoryCache((long)(0.85 * (double)l), l);
            basicMemoryCache.setName("Texture Tiles");
            WorldWind.getMemoryCacheSet().addCache(TextureTile.class.getName(), basicMemoryCache);
        }
    }

    public BasicTiledImageLayer(AVList aVList) {
        this(new LevelSet(aVList));
        this.setValue("gov.nasa.worldwind.avkey.ConstructionParameters", aVList);
    }

    protected void forceTextureLoad(TextureTile textureTile) {
        URL uRL = WorldWind.getDataFileCache().findFile(textureTile.getPath(), true);
        if (uRL != null && !this.isTextureExpired(textureTile, uRL)) {
            this.loadTexture(textureTile, uRL);
        }
    }

    protected void requestTexture(DrawContext drawContext, TextureTile textureTile) {
        Vec4 vec4 = textureTile.getCentroidPoint(drawContext.getGlobe());
        if (this.getReferencePoint() != null) {
            textureTile.setPriority(vec4.distanceTo3(this.getReferencePoint()));
        }
        RequestTask requestTask = new RequestTask(textureTile, this);
        this.getRequestQ().add(requestTask);
    }

    private boolean isTextureExpired(TextureTile textureTile, URL uRL) {
        if (!WWIO.isFileOutOfDate(uRL, textureTile.getLevel().getExpiryTime())) {
            return false;
        }
        WorldWind.getDataFileCache().removeFile(uRL);
        String string = Logging.getMessage("generic.DataFileExpired", uRL);
        Logging.logger().fine(string);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadTexture(TextureTile textureTile, URL uRL) {
        TextureData textureData;
        Object object = this.fileLock;
        synchronized (object) {
            textureData = BasicTiledImageLayer.readTexture(uRL, this.isUseMipMaps());
        }
        if (textureData == null) {
            return false;
        }
        textureTile.setTextureData(textureData);
        if (textureTile.getLevelNumber() != 0 || !this.isRetainLevelZeroTiles()) {
            this.addTileToCache(textureTile);
        }
        return true;
    }

    private static TextureData readTexture(URL uRL, boolean bl) {
        try {
            return TextureIO.newTextureData(uRL, bl, null);
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, "layers.TextureLayer.ExceptionAttemptingToReadTextureFile", exception);
            return null;
        }
    }

    private void addTileToCache(TextureTile textureTile) {
        WorldWind.getMemoryCache(TextureTile.class.getName()).add(textureTile.getTileKey(), textureTile);
    }

    protected void downloadTexture(TextureTile textureTile) {
        Integer n;
        Integer n2;
        URL uRL;
        if (!WorldWind.getRetrievalService().isAvailable()) {
            return;
        }
        try {
            uRL = textureTile.getResourceURL();
            if (uRL == null) {
                return;
            }
            if (WorldWind.getNetworkStatus().isHostUnavailable(uRL)) {
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("layers.TextureLayer.ExceptionCreatingTextureUrl", textureTile), malformedURLException);
            return;
        }
        if (!"http".equalsIgnoreCase(uRL.getProtocol())) {
            Logging.logger().severe(Logging.getMessage("layers.TextureLayer.UnknownRetrievalProtocol", uRL.toString()));
            return;
        }
        HTTPRetriever hTTPRetriever = new HTTPRetriever(uRL, new DownloadPostProcessor(textureTile, this));
        Integer n3 = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.URLConnectTimeout");
        if (n3 != null && n3 > 0) {
            hTTPRetriever.setConnectTimeout(n3);
        }
        if ((n2 = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.URLReadTimeout")) != null && n2 > 0) {
            hTTPRetriever.setReadTimeout(n2);
        }
        if ((n = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit")) != null && n > 0) {
            hTTPRetriever.setStaleRequestLimit(n);
        }
        WorldWind.getRetrievalService().runRetriever(hTTPRetriever, textureTile.getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBuffer(ByteBuffer byteBuffer, File file) throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            WWIO.saveBuffer(byteBuffer, file);
        }
    }

    private static class DownloadPostProcessor
    implements RetrievalPostProcessor {
        private final TextureTile tile;
        private final BasicTiledImageLayer layer;

        public DownloadPostProcessor(TextureTile textureTile, BasicTiledImageLayer basicTiledImageLayer) {
            this.tile = textureTile;
            this.layer = basicTiledImageLayer;
        }

        public ByteBuffer run(Retriever retriever) {
            if (retriever == null) {
                String string = Logging.getMessage("nullValue.RetrieverIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            try {
                Object object;
                if (!retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
                    return null;
                }
                URLRetriever uRLRetriever = (URLRetriever)retriever;
                ByteBuffer byteBuffer = uRLRetriever.getBuffer();
                if (retriever instanceof HTTPRetriever) {
                    object = (HTTPRetriever)retriever;
                    if (((HTTPRetriever)object).getResponseCode() == 204) {
                        this.layer.getLevels().markResourceAbsent(this.tile);
                        return null;
                    }
                    if (((HTTPRetriever)object).getResponseCode() != 200) {
                        this.layer.getLevels().markResourceAbsent(this.tile);
                        return null;
                    }
                }
                if ((object = WorldWind.getDataFileCache().newFile(this.tile.getPath())) == null) {
                    return null;
                }
                if (((File)object).exists()) {
                    return byteBuffer;
                }
                if (byteBuffer != null) {
                    String string = uRLRetriever.getContentType();
                    if (string == null) {
                        return null;
                    }
                    if (string.contains("xml") || string.contains("html") || string.contains("text")) {
                        this.layer.getLevels().markResourceAbsent(this.tile);
                        StringBuffer stringBuffer = new StringBuffer();
                        while (byteBuffer.hasRemaining()) {
                            stringBuffer.append((char)byteBuffer.get());
                        }
                        Logging.logger().severe(stringBuffer.toString());
                        return null;
                    }
                    if (string.contains("dds")) {
                        this.layer.saveBuffer(byteBuffer, (File)object);
                    } else if (string.contains("zip")) {
                        this.layer.saveBuffer(byteBuffer, (File)object);
                    } else if (((File)object).getName().endsWith(".dds")) {
                        if ((byteBuffer = DDSConverter.convertToDDS(byteBuffer, string)) != null) {
                            this.layer.saveBuffer(byteBuffer, (File)object);
                        }
                    } else if (string.contains("image")) {
                        this.layer.saveBuffer(byteBuffer, (File)object);
                    }
                    if (byteBuffer != null) {
                        this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
                    }
                    return byteBuffer;
                }
            }
            catch (IOException iOException) {
                this.layer.getLevels().markResourceAbsent(this.tile);
                Logging.logger().log(Level.SEVERE, Logging.getMessage("layers.TextureLayer.ExceptionSavingRetrievedTextureFile", this.tile.getPath()), iOException);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestTask
    implements Runnable,
    Comparable<RequestTask> {
        private final BasicTiledImageLayer layer;
        private final TextureTile tile;

        private RequestTask(TextureTile textureTile, BasicTiledImageLayer basicTiledImageLayer) {
            this.layer = basicTiledImageLayer;
            this.tile = textureTile;
        }

        @Override
        public void run() {
            URL uRL = WorldWind.getDataFileCache().findFile(this.tile.getPath(), false);
            if (uRL != null && !this.layer.isTextureExpired(this.tile, uRL)) {
                if (this.layer.loadTexture(this.tile, uRL)) {
                    this.layer.getLevels().unmarkResourceAbsent(this.tile);
                    this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
                    return;
                }
                WorldWind.getDataFileCache().removeFile(uRL);
                this.layer.getLevels().markResourceAbsent(this.tile);
                String string = Logging.getMessage("generic.DeletedCorruptDataFile", uRL);
                Logging.logger().info(string);
            }
            this.layer.downloadTexture(this.tile);
        }

        @Override
        public int compareTo(RequestTask requestTask) {
            if (requestTask == null) {
                String string = Logging.getMessage("nullValue.RequestTaskIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return this.tile.getPriority() == requestTask.tile.getPriority() ? 0 : (this.tile.getPriority() < requestTask.tile.getPriority() ? -1 : 1);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RequestTask requestTask = (RequestTask)object;
            return !(this.tile == null ? requestTask.tile != null : !this.tile.equals(requestTask.tile));
        }

        public int hashCode() {
            return this.tile != null ? this.tile.hashCode() : 0;
        }

        public String toString() {
            return this.tile.toString();
        }
    }
}

