/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.SectorGeometry;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectorGeometryList
extends ArrayList<SectorGeometry> {
    private Sector sector;
    private PickSupport pickSupport = new PickSupport();
    private HashMap<SectorGeometry, ArrayList<Point>> pickSectors = new HashMap();

    public SectorGeometryList() {
    }

    public SectorGeometryList(SectorGeometryList sectorGeometryList) {
        super(sectorGeometryList);
    }

    public Sector getSector() {
        return this.sector;
    }

    public void setSector(Sector sector) {
        this.sector = sector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pick(DrawContext drawContext, Point point) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (point == null) {
            return;
        }
        this.pickSupport.clearPickList();
        this.pickSupport.beginPicking(drawContext);
        GL gL = drawContext.getGL();
        gL.glPushAttrib(8513);
        gL.glEnable(2929);
        gL.glShadeModel(7424);
        gL.glDisable(2884);
        try {
            SectorGeometry sectorGeometry2;
            for (SectorGeometry sectorGeometry2 : this) {
                Color color = drawContext.getUniquePickColor();
                drawContext.getGL().glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                sectorGeometry2.render(drawContext);
                this.pickSupport.addPickableObject(color.getRGB(), sectorGeometry2, Position.ZERO, true);
            }
            PickedObject pickedObject = this.pickSupport.getTopObject(drawContext, point, null);
            if (pickedObject == null || pickedObject.getObject() == null) {
                return;
            }
            sectorGeometry2 = (SectorGeometry)pickedObject.getObject();
            gL.glDepthFunc(515);
            sectorGeometry2.pick(drawContext, point);
        }
        finally {
            gL.glPopAttrib();
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.clearPickList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<PickedObject> pick(DrawContext drawContext, List<Point> list) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (list == null || list.size() < 1) {
            return null;
        }
        this.pickSupport.clearPickList();
        this.pickSupport.beginPicking(drawContext);
        GL gL = drawContext.getGL();
        gL.glPushAttrib(8513);
        gL.glEnable(2929);
        gL.glShadeModel(7424);
        gL.glDisable(2884);
        try {
            Object object;
            ArrayList<Object> arrayList;
            Object object2;
            for (SectorGeometry object42 : this) {
                Color color = drawContext.getUniquePickColor();
                drawContext.getGL().glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                object42.render(drawContext);
                this.pickSupport.addPickableObject(color.getRGB(), object42, Position.ZERO, true);
            }
            this.pickSectors.clear();
            for (Point point : list) {
                PickedObject pickedObject = this.pickSupport.getTopObject(drawContext, point, null);
                if (pickedObject == null || pickedObject.getObject() == null) continue;
                object2 = (SectorGeometry)pickedObject.getObject();
                if (!this.pickSectors.containsKey(object2)) {
                    arrayList = new ArrayList();
                    this.pickSectors.put((SectorGeometry)object2, arrayList);
                } else {
                    arrayList = this.pickSectors.get(object2);
                }
                arrayList.add(point);
            }
            if (this.pickSectors.size() < 1) {
                object = null;
                return object;
            }
            gL.glDepthFunc(515);
            object = new ArrayList();
            for (Map.Entry<SectorGeometry, ArrayList<Point>> entry : this.pickSectors.entrySet()) {
                object2 = entry.getValue();
                arrayList = entry.getKey().pick(drawContext, (List<Point>)object2);
                if (arrayList == null) continue;
                for (ArrayList<Object> arrayList2 : arrayList) {
                    if (arrayList2 == null) continue;
                    ((ArrayList)object).add(arrayList2);
                }
            }
            Object object3 = object;
            return object3;
        }
        finally {
            gL.glPopAttrib();
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.clearPickList();
        }
    }

    public Vec4 getSurfacePoint(Position position) {
        return this.getSurfacePoint(position.getLatitude(), position.getLongitude(), position.getElevation());
    }

    public Vec4 getSurfacePoint(Angle angle, Angle angle2) {
        return this.getSurfacePoint(angle, angle2, 0.0);
    }

    public Vec4 getSurfacePoint(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (SectorGeometry sectorGeometry : this) {
            Vec4 vec4;
            if (!sectorGeometry.getSector().contains(angle, angle2) || (vec4 = sectorGeometry.getSurfacePoint(angle, angle2, d)) == null) continue;
            return vec4;
        }
        return null;
    }
}

