/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.retrieve.HTTPRetriever;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.retrieve.URLRetriever;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.TileKey;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class BasicElevationModel
extends WWObjectImpl
implements ElevationModel {
    private boolean isEnabled = true;
    private final LevelSet levels;
    private final double minElevation;
    private final double maxElevation;
    private long numExpectedValues = 0L;
    private final Object fileLock = new Object();
    private ConcurrentHashMap<TileKey, Tile> levelZeroTiles = new ConcurrentHashMap();
    private MemoryCache memoryCache = new BasicMemoryCache(4000000L, 5000000L);
    private int extremesLevel = -1;
    private ShortBuffer extremes = null;

    public BasicElevationModel(LevelSet levelSet, double d, double d2) {
        if (levelSet == null) {
            String string = Logging.getMessage("nullValue.LevelSetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = Tile.class.getName();
        if (WorldWind.getMemoryCacheSet().containsCache(string)) {
            this.memoryCache = WorldWind.getMemoryCache(string);
        } else {
            long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.ElevationTileCacheSize", 5000000L);
            this.memoryCache = new BasicMemoryCache((long)(0.85 * (double)l), l);
            this.memoryCache.setName("Elevation Tiles");
            WorldWind.getMemoryCacheSet().addCache(string, this.memoryCache);
        }
        this.levels = new LevelSet(levelSet);
        this.minElevation = d;
        this.maxElevation = d2;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public LevelSet getLevels() {
        return this.levels;
    }

    public final double getMaxElevation() {
        return this.maxElevation;
    }

    public final double getMinElevation() {
        return this.minElevation;
    }

    public long getNumExpectedValuesPerTile() {
        return this.numExpectedValues;
    }

    public void setNumExpectedValuesPerTile(long l) {
        this.numExpectedValues = l;
    }

    private Tile createTile(TileKey tileKey) {
        gov.nasa.worldwind.util.Level level = this.levels.getLevel(tileKey.getLevelNumber());
        Angle angle = level.getTileDelta().getLatitude();
        Angle angle2 = level.getTileDelta().getLongitude();
        Angle angle3 = Tile.computeRowLatitude(tileKey.getRow(), angle);
        Angle angle4 = Tile.computeColumnLongitude(tileKey.getColumn(), angle2);
        Sector sector = new Sector(angle3, angle3.add(angle), angle4, angle4.add(angle2));
        return new Tile(sector, level, tileKey.getRow(), tileKey.getColumn());
    }

    private void requestTile(TileKey tileKey) {
        if (WorldWind.getTaskService().isFull()) {
            return;
        }
        RequestTask requestTask = new RequestTask(tileKey, this);
        WorldWind.getTaskService().addTask(requestTask);
    }

    private boolean loadElevations(Tile tile, URL uRL) {
        ShortBuffer shortBuffer = this.readElevations(uRL);
        if (shortBuffer == null) {
            return false;
        }
        if (this.numExpectedValues > 0L && (long)shortBuffer.capacity() != this.numExpectedValues) {
            return false;
        }
        tile.elevations = shortBuffer;
        this.addTileToCache(tile, shortBuffer);
        return true;
    }

    private void addTileToCache(Tile tile, ShortBuffer shortBuffer) {
        if (tile.getLevelNumber() == 0) {
            this.levelZeroTiles.putIfAbsent(tile.getTileKey(), tile);
        } else {
            this.memoryCache.add(tile.getTileKey(), tile, shortBuffer.limit() * 2);
        }
    }

    private boolean areElevationsInMemory(TileKey tileKey) {
        Tile tile = this.getTileFromMemory(tileKey);
        return tile != null && tile.elevations != null;
    }

    private Tile getTileFromMemory(TileKey tileKey) {
        if (tileKey.getLevelNumber() == 0) {
            return this.levelZeroTiles.get(tileKey);
        }
        return (Tile)this.memoryCache.getObject(tileKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShortBuffer readElevations(URL uRL) {
        try {
            ByteBuffer byteBuffer;
            Object object = this.fileLock;
            synchronized (object) {
                byteBuffer = WWIO.readURLContentToBuffer(uRL);
            }
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            return byteBuffer.asShortBuffer();
        }
        catch (IOException iOException) {
            Logging.logger().log(Level.SEVERE, "TiledElevationModel.ExceptionAttemptingToReadTextureFile", uRL.toString());
            return null;
        }
    }

    private void downloadElevations(Tile tile) {
        if (!WorldWind.getRetrievalService().isAvailable()) {
            return;
        }
        URL uRL = null;
        try {
            uRL = tile.getResourceURL();
            if (WorldWind.getNetworkStatus().isHostUnavailable(uRL)) {
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("TiledElevationModel.ExceptionCreatingElevationsUrl", uRL), malformedURLException);
            return;
        }
        HTTPRetriever hTTPRetriever = new HTTPRetriever(uRL, new DownloadPostProcessor(tile, this));
        if (WorldWind.getRetrievalService().contains(hTTPRetriever)) {
            return;
        }
        WorldWind.getRetrievalService().runRetriever(hTTPRetriever, 0.0);
    }

    public final int getTargetResolution(DrawContext drawContext, Sector sector, int n) {
        if (!this.isEnabled) {
            return 0;
        }
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0) {
            Logging.logger().severe("BasicElevationModel.DensityBelowZero");
        }
        LatLon latLon = this.levels.getSector().getCentroid();
        double d = drawContext.getGlobe().getRadiusAt(latLon.getLatitude(), latLon.getLongitude());
        double d2 = sector.getDeltaLatRadians() * d;
        double d3 = 0.8 * d2 / (double)n;
        for (gov.nasa.worldwind.util.Level level : this.levels.getLevels()) {
            if (!(level.getTexelSize(d) < d3)) continue;
            return level.getLevelNumber();
        }
        return this.levels.getNumLevels();
    }

    public final int getTargetResolution(Globe globe, double d) {
        if (!this.isEnabled) {
            return 0;
        }
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            Logging.logger().severe("BasicElevationModel.DensityBelowZero");
        }
        LatLon latLon = this.levels.getSector().getCentroid();
        double d2 = globe.getRadiusAt(latLon.getLatitude(), latLon.getLongitude());
        for (gov.nasa.worldwind.util.Level level : this.levels.getLevels()) {
            if (!(level.getTexelSize(d2) < d)) continue;
            return level.getLevelNumber();
        }
        return this.levels.getNumLevels() - 1;
    }

    public final double getElevation(Angle angle, Angle angle2) {
        if (!this.isEnabled()) {
            return 0.0;
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        TileKey tileKey = new TileKey(angle, angle2, this.levels.getLastLevel(angle, angle2));
        Tile tile = this.getTileFromMemory(tileKey);
        if (tile == null) {
            TileKey tileKey2;
            int n = tileKey.getRow();
            int n2 = tileKey.getColumn();
            for (int i = tileKey.getLevelNumber() - 1; i >= 0 && (tile = this.getTileFromMemory(tileKey2 = new TileKey(i, n /= 2, n2 /= 2, this.levels.getLevel(i).getCacheName()))) == null; --i) {
            }
        }
        if (tile == null) {
            TileKey tileKey3 = new TileKey(angle, angle2, this.levels.getFirstLevel());
            this.requestTile(tileKey3);
            return 0.0;
        }
        return this.lookupElevation(angle.radians, angle2.radians, tile);
    }

    public Double getBestElevation(Angle angle, Angle angle2) {
        if (!this.isEnabled()) {
            return null;
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        TileKey tileKey = new TileKey(angle, angle2, this.levels.getLastLevel(angle, angle2));
        Tile tile = this.getTileFromMemory(tileKey);
        if (tile != null) {
            return this.lookupElevation(angle.radians, angle2.radians, tile);
        }
        this.requestTile(tileKey);
        return null;
    }

    public Double getElevationAtResolution(Angle angle, Angle angle2, int n) {
        if (!this.isEnabled()) {
            return null;
        }
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 0 || n > this.getLevels().getLastLevel(angle2, angle).getLevelNumber()) {
            return this.getBestElevation(angle, angle2);
        }
        TileKey tileKey = new TileKey(angle, angle2, this.levels.getLevel(n));
        Tile tile = this.getTileFromMemory(tileKey);
        if (tile != null) {
            return this.lookupElevation(angle.radians, angle2.radians, tile);
        }
        this.requestTile(tileKey);
        return null;
    }

    public final int getTileCount(Sector sector, int n) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isEnabled()) {
            return 0;
        }
        gov.nasa.worldwind.util.Level level = this.levels.getLevel(n);
        LatLon latLon = this.levels.getLevel(n).getTileDelta();
        int n2 = Tile.computeRow(latLon.getLatitude(), sector.getMaxLatitude());
        int n3 = Tile.computeColumn(latLon.getLongitude(), sector.getMinLongitude());
        int n4 = Tile.computeRow(latLon.getLatitude(), sector.getMinLatitude());
        int n5 = Tile.computeColumn(latLon.getLongitude(), sector.getMaxLongitude());
        return 1 + (n2 - n4) * (1 + n5 - n3);
    }

    public final ElevationModel.Elevations getElevations(Sector sector, int n) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isEnabled()) {
            return new BasicElevations(sector, Integer.MIN_VALUE, this);
        }
        gov.nasa.worldwind.util.Level level = this.levels.getLevel(n);
        LatLon latLon = this.levels.getLevel(n).getTileDelta();
        int n2 = Tile.computeRow(latLon.getLatitude(), sector.getMaxLatitude());
        int n3 = Tile.computeColumn(latLon.getLongitude(), sector.getMinLongitude());
        int n4 = Tile.computeRow(latLon.getLatitude(), sector.getMinLatitude());
        int n5 = Tile.computeColumn(latLon.getLongitude(), sector.getMaxLongitude());
        TreeSet<Tile> treeSet = new TreeSet<Tile>(new Comparator<Tile>(){

            @Override
            public int compare(Tile tile, Tile tile2) {
                if (tile2.getLevelNumber() == tile.getLevelNumber() && tile2.getRow() == tile.getRow() && tile2.getColumn() == tile.getColumn()) {
                    return 0;
                }
                return tile.getLevelNumber() > tile2.getLevelNumber() ? -1 : 1;
            }
        });
        ArrayList<TileKey> arrayList = new ArrayList<TileKey>();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = n4; i <= n2; ++i) {
            for (int j = n3; j <= n5; ++j) {
                TileKey tileKey = new TileKey(n, i, j, level.getCacheName());
                Tile tile = this.getTileFromMemory(tileKey);
                if (tile != null) {
                    treeSet.add(tile);
                    continue;
                }
                bl = true;
                this.requestTile(tileKey);
                TileKey tileKey2 = null;
                TileKey tileKey3 = null;
                int n6 = i;
                int n7 = j;
                for (int k = tileKey.getLevelNumber() - 1; k >= 0; --k) {
                    tileKey3 = new TileKey(k, n6 /= 2, n7 /= 2, this.levels.getLevel(k).getCacheName());
                    tile = this.getTileFromMemory(tileKey3);
                    if (tile != null) {
                        if (treeSet.contains(tile)) break;
                        treeSet.add(tile);
                        break;
                    }
                    if (k == 0) {
                        bl2 = true;
                    }
                    tileKey2 = tileKey3;
                }
                if (tileKey2 == null || arrayList.contains(tileKey2)) continue;
                this.requestTile(tileKey2);
                arrayList.add(tileKey2);
            }
        }
        BasicElevations basicElevations = bl2 || treeSet.isEmpty() ? new BasicElevations(sector, Integer.MIN_VALUE, this) : (bl ? new BasicElevations(sector, treeSet.last().getLevelNumber(), this) : new BasicElevations(sector, n, this));
        basicElevations.tiles = treeSet;
        return basicElevations;
    }

    public final int getTileCountAtResolution(Sector sector, int n) {
        int n2 = this.getLevels().getLastLevel(sector).getLevelNumber();
        if (n >= 0) {
            n2 = Math.min(n, this.getLevels().getLastLevel(sector).getLevelNumber());
        }
        return this.getTileCount(sector, n2);
    }

    public final ElevationModel.Elevations getElevationsAtResolution(Sector sector, int n) {
        ElevationModel.Elevations elevations;
        int n2 = this.getLevels().getLastLevel(sector).getLevelNumber();
        if (n >= 0) {
            n2 = Math.min(n, this.getLevels().getLastLevel(sector).getLevelNumber());
        }
        return (elevations = this.getElevations(sector, n2)).getResolution() == n2 ? elevations : null;
    }

    public final ElevationModel.Elevations getBestElevations(Sector sector) {
        return this.getElevationsAtResolution(sector, this.getLevels().getLastLevel(sector).getLevelNumber());
    }

    private double lookupElevation(double d, double d2, Tile tile) {
        Sector sector = tile.getSector();
        int n = tile.getLevel().getTileHeight();
        int n2 = tile.getLevel().getTileWidth();
        double d3 = sector.getDeltaLat().radians;
        double d4 = sector.getDeltaLon().radians;
        double d5 = sector.getMaxLatitude().radians - d;
        double d6 = d2 - sector.getMinLongitude().radians;
        double d7 = d5 / d3;
        double d8 = d6 / d4;
        int n3 = (int)((double)(n - 1) * d7);
        int n4 = (int)((double)(n2 - 1) * d8);
        int n5 = n3 * n2 + n4;
        double d9 = tile.elevations.get(n5);
        double d10 = n4 < n2 - 1 ? (double)tile.elevations.get(n5 + 1) : d9;
        double d11 = d4 / (double)(n2 - 1);
        double d12 = d3 / (double)(n - 1);
        double d13 = (d6 - (double)n4 * d11) / d11;
        double d14 = (d5 - (double)n3 * d12) / d12;
        double d15 = d9 + d13 * (d10 - d9);
        if (n3 < n - 1 && n4 < n2 - 1) {
            d9 = tile.elevations.get(n5 + n2);
            d10 = tile.elevations.get(n5 + n2 + 1);
        }
        double d16 = d9 + d13 * (d10 - d9);
        return d15 + d14 * (d16 - d15);
    }

    public double[] getMinAndMaxElevations(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.extremesLevel < 0 || this.extremes == null) {
            return new double[]{this.getMinElevation(), this.getMaxElevation()};
        }
        try {
            LatLon latLon = this.levels.getLevel(this.extremesLevel).getTileDelta();
            int n = Tile.computeRow(latLon.getLatitude(), sector.getMaxLatitude());
            int n2 = Tile.computeColumn(latLon.getLongitude(), sector.getMinLongitude());
            int n3 = Tile.computeRow(latLon.getLatitude(), sector.getMinLatitude());
            int n4 = Tile.computeColumn(latLon.getLongitude(), sector.getMaxLongitude());
            int n5 = Tile.computeColumn(latLon.getLongitude(), Angle.POS180) + 1;
            short s = Short.MAX_VALUE;
            short s2 = Short.MIN_VALUE;
            for (int i = n3; i <= n; ++i) {
                for (int j = n2; j <= n4; ++j) {
                    int n6 = 2 * (i * n5 + j);
                    short s3 = this.extremes.get(n6);
                    short s4 = this.extremes.get(n6 + 1);
                    if (s3 > s2) {
                        s2 = s3;
                    }
                    if (s3 < s) {
                        s = s3;
                    }
                    if (s4 > s2) {
                        s2 = s4;
                    }
                    if (s4 >= s) continue;
                    s = s4;
                }
            }
            return new double[]{s, s2};
        }
        catch (Exception exception) {
            String string = Logging.getMessage("BasicElevationModel.ExceptionDeterminingExtremes", sector);
            Logging.logger().log(Level.WARNING, string, exception);
            return new double[]{this.getMinElevation(), this.getMaxElevation()};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadExtremeElevations(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ExtremeElevationsFileName");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        InputStream inputStream = null;
        try {
            String[] stringArray;
            inputStream = this.getClass().getResourceAsStream("/" + string);
            if (inputStream == null) {
                stringArray = new File(string);
                if (stringArray.exists()) {
                    inputStream = new FileInputStream((File)stringArray);
                } else {
                    Logging.logger().log(Level.WARNING, "BasicElevationModel.UnavailableExtremesFile", string);
                }
            }
            if (inputStream == null) {
                return;
            }
            stringArray = string.substring(0, string.lastIndexOf(".")).split("_");
            this.extremesLevel = Integer.parseInt(stringArray[stringArray.length - 1]);
            if (this.extremesLevel < 0) {
                this.extremes = null;
                Logging.logger().log(Level.WARNING, "BasicElevationModel.UnavailableExtremesLevel", string);
                return;
            }
            ByteBuffer byteBuffer = WWIO.readStreamToBuffer(inputStream);
            this.extremes = byteBuffer.asShortBuffer();
            this.extremes.rewind();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logging.logger().log(Level.WARNING, Logging.getMessage("BasicElevationModel.ExceptionReadingExtremeElevations", string), fileNotFoundException);
            this.extremes = null;
            this.extremesLevel = -1;
        }
        catch (IOException iOException) {
            Logging.logger().log(Level.WARNING, Logging.getMessage("BasicElevationModel.ExceptionReadingExtremeElevations", string), iOException);
            this.extremes = null;
            this.extremesLevel = -1;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Logging.logger().log(Level.WARNING, Logging.getMessage("generic.ExceptionClosingStream", string), iOException);
                }
            }
        }
    }

    private static class BasicElevations
    implements ElevationModel.Elevations {
        private final int resolution;
        private final Sector sector;
        private final BasicElevationModel elevationModel;
        private Set<Tile> tiles;
        private short[] extremes = null;

        private BasicElevations(Sector sector, int n, BasicElevationModel basicElevationModel) {
            this.sector = sector;
            this.resolution = n;
            this.elevationModel = basicElevationModel;
        }

        public int getResolution() {
            return this.resolution;
        }

        public Sector getSector() {
            return this.sector;
        }

        public boolean hasElevations() {
            return this.tiles != null && this.tiles.size() > 0;
        }

        public double getElevation(double d, double d2) {
            if (this.tiles == null) {
                return 0.0;
            }
            try {
                for (Tile tile : this.tiles) {
                    if (!tile.getSector().containsRadians(d, d2)) continue;
                    return this.elevationModel.lookupElevation(d, d2, tile);
                }
                return 0.0;
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("BasicElevationModel.ExceptionComputingElevation", d, d2), exception);
                return 0.0;
            }
        }

        public short[] getExtremes() {
            if (this.extremes != null) {
                return this.extremes;
            }
            if (this.tiles == null) {
                return null;
            }
            short s = Short.MAX_VALUE;
            short s2 = Short.MIN_VALUE;
            for (Tile tile : this.tiles) {
                tile.elevations.rewind();
                if (!tile.elevations.hasRemaining()) {
                    return null;
                }
                while (tile.elevations.hasRemaining()) {
                    short s3 = tile.elevations.get();
                    if (s3 > s2) {
                        s2 = s3;
                    }
                    if (s3 >= s) continue;
                    s = s3;
                }
            }
            this.extremes = new short[]{s, s2};
            return this.extremes;
        }
    }

    private static class DownloadPostProcessor
    implements RetrievalPostProcessor {
        private Tile tile;
        private BasicElevationModel elevationModel;

        public DownloadPostProcessor(Tile tile, BasicElevationModel basicElevationModel) {
            this.tile = tile;
            this.elevationModel = basicElevationModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBuffer run(Retriever retriever) {
            block17: {
                if (retriever == null) {
                    String string = Logging.getMessage("nullValue.RetrieverIsNull");
                    Logging.logger().severe(string);
                    throw new IllegalArgumentException(string);
                }
                try {
                    URLRetriever uRLRetriever;
                    if (!retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
                        ByteBuffer byteBuffer = null;
                        return byteBuffer;
                    }
                    if (retriever instanceof HTTPRetriever && ((HTTPRetriever)(uRLRetriever = (HTTPRetriever)retriever)).getResponseCode() != 200) {
                        this.elevationModel.levels.markResourceAbsent(this.tile);
                        ByteBuffer byteBuffer = null;
                        return byteBuffer;
                    }
                    uRLRetriever = (URLRetriever)retriever;
                    ByteBuffer byteBuffer = uRLRetriever.getBuffer();
                    File file = WorldWind.getDataFileCache().newFile(this.tile.getPath());
                    if (file == null) {
                        ByteBuffer byteBuffer2 = null;
                        return byteBuffer2;
                    }
                    if (file.exists()) {
                        ByteBuffer byteBuffer3 = byteBuffer;
                        return byteBuffer3;
                    }
                    if (byteBuffer == null) break block17;
                    Object object = this.elevationModel.fileLock;
                    synchronized (object) {
                        WWIO.saveBuffer(byteBuffer, file);
                    }
                    object = byteBuffer;
                    return object;
                }
                catch (IOException iOException) {
                    Logging.logger().log(Level.SEVERE, Logging.getMessage("TiledElevationModel.ExceptionSavingRetrievedElevationFile", this.tile.getPath()), iOException);
                }
                finally {
                    this.elevationModel.firePropertyChange("gov.nasa.worldwind.avkey.ElevationModel", null, this);
                }
            }
            return null;
        }
    }

    private static class RequestTask
    implements Runnable {
        private final BasicElevationModel elevationModel;
        private final TileKey tileKey;

        private RequestTask(TileKey tileKey, BasicElevationModel basicElevationModel) {
            this.elevationModel = basicElevationModel;
            this.tileKey = tileKey;
        }

        public final void run() {
            if (this.elevationModel.areElevationsInMemory(this.tileKey)) {
                return;
            }
            Tile tile = this.elevationModel.createTile(this.tileKey);
            URL uRL = WorldWind.getDataFileCache().findFile(tile.getPath(), false);
            if (uRL != null) {
                if (this.elevationModel.loadElevations(tile, uRL)) {
                    this.elevationModel.levels.unmarkResourceAbsent(tile);
                    this.elevationModel.firePropertyChange("gov.nasa.worldwind.avkey.ElevationModel", null, this);
                    return;
                }
                WorldWind.getDataFileCache().removeFile(uRL);
                this.elevationModel.levels.markResourceAbsent(tile);
                String string = Logging.getMessage("generic.DeletedCorruptDataFile", uRL);
                Logging.logger().info(string);
            }
            this.elevationModel.downloadElevations(tile);
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RequestTask requestTask = (RequestTask)object;
            return !(this.tileKey != null ? !this.tileKey.equals(requestTask.tileKey) : requestTask.tileKey != null);
        }

        public final int hashCode() {
            return this.tileKey != null ? this.tileKey.hashCode() : 0;
        }

        public final String toString() {
            return this.tileKey.toString();
        }
    }

    private static final class Tile
    extends gov.nasa.worldwind.util.Tile
    implements Cacheable {
        private ShortBuffer elevations;

        private Tile(Sector sector, gov.nasa.worldwind.util.Level level, int n, int n2) {
            super(sector, level, n, n2);
        }
    }
}

