/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom.coords;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.coords.UTMCoordConverter;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;

public class UTMCoord {
    private final Angle latitude;
    private final Angle longitude;
    private final char hemisphere;
    private final int zone;
    private final double easting;
    private final double northing;

    public static UTMCoord fromLatLon(Angle angle, Angle angle2) {
        return UTMCoord.fromLatLon(angle, angle2, null);
    }

    public static UTMCoord fromLatLon(Angle angle, Angle angle2, Globe globe) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        UTMCoordConverter uTMCoordConverter = new UTMCoordConverter(globe);
        long l = uTMCoordConverter.convertGeodeticToUTM(angle.radians, angle2.radians);
        if (l != 0L) {
            String string = Logging.getMessage("Coord.UTMConversionError");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new UTMCoord(angle, angle2, uTMCoordConverter.getZone(), uTMCoordConverter.getHemisphere(), uTMCoordConverter.getEasting(), uTMCoordConverter.getNorthing());
    }

    public static UTMCoord fromUTM(int n, char c, double d, double d2) {
        return UTMCoord.fromUTM(n, c, d, d2, null);
    }

    public static UTMCoord fromUTM(int n, char c, double d, double d2, Globe globe) {
        UTMCoordConverter uTMCoordConverter = new UTMCoordConverter(globe);
        long l = uTMCoordConverter.convertUTMToGeodetic(n, c, d, d2);
        if (l != 0L) {
            String string = Logging.getMessage("Coord.UTMConversionError");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new UTMCoord(Angle.fromRadians(uTMCoordConverter.getLatitude()), Angle.fromRadians(uTMCoordConverter.getLongitude()), n, c, d, d2);
    }

    public UTMCoord(Angle angle, Angle angle2, int n, char c, double d, double d2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.latitude = angle;
        this.longitude = angle2;
        this.hemisphere = c;
        this.zone = n;
        this.easting = d;
        this.northing = d2;
    }

    public Angle getLatitude() {
        return this.latitude;
    }

    public Angle getLongitude() {
        return this.longitude;
    }

    public int getZone() {
        return this.zone;
    }

    public char getHemisphere() {
        return this.hemisphere;
    }

    public double getEasting() {
        return this.easting;
    }

    public double getNorthing() {
        return this.northing;
    }

    public String toString() {
        return this.zone + " " + this.hemisphere + " " + (int)this.easting + "E" + " " + (int)this.northing + "N";
    }
}

