/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;

public final class Plane {
    private final Vec4 n;

    public Plane(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.VectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4.getLengthSquared3() == 0.0) {
            String string = Logging.getMessage("Geom.Plane.VectorIsZero");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.n = vec4;
    }

    public Plane(double d, double d2, double d3, double d4) {
        if (d == 0.0 && d2 == 0.0 && d3 == 0.0) {
            String string = Logging.getMessage("Geom.Plane.VectorIsZero");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.n = new Vec4(d, d2, d3, d4);
    }

    public final Vec4 getNormal() {
        return new Vec4(this.n.x, this.n.y, this.n.z);
    }

    public final double getDistance() {
        return this.n.w;
    }

    public final Vec4 getVector() {
        return this.n;
    }

    public final double dot(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.n.x * vec4.x + this.n.y * vec4.y + this.n.z * vec4.z + this.n.w * vec4.w;
    }

    public final Plane computeParallelPlaneAtDistance(double d) {
        return new Plane(this.n.x, this.n.y, this.n.z, d);
    }

    public Vec4 intersect(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.intersectDistance(line);
        if (Double.isNaN(d)) {
            return null;
        }
        if (Double.isInfinite(d)) {
            return line.getOrigin();
        }
        return line.getPointAt(d);
    }

    public double intersectDistance(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.n.dot3(line.getDirection());
        if (d == 0.0) {
            double d2 = this.n.dot4(line.getOrigin());
            if (d2 == 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
        return -this.n.dot4(line.getOrigin()) / d;
    }

    public Vec4 intersect(Vec4 vec4, Vec4 vec42) {
        if (vec4 == null || vec42 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Line line = Line.fromSegment(vec4, vec42);
        double d = this.intersectDistance(line);
        if (Double.isInfinite(d)) {
            return Vec4.INFINITY;
        }
        if (Double.isNaN(d) || d < 0.0 || d > 1.0) {
            return null;
        }
        return line.getPointAt(d);
    }

    public Vec4[] clip(Vec4 vec4, Vec4 vec42) {
        if (vec4 == null || vec42 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Line line = Line.fromSegment(vec4, vec42);
        double d = this.n.dot3(line.getDirection());
        if (d == 0.0) {
            double d2 = this.n.dot4(line.getOrigin());
            if (d2 == 0.0) {
                return new Vec4[]{vec4, vec42};
            }
            return null;
        }
        double d3 = -this.n.dot4(line.getOrigin()) / d;
        if (d3 < 0.0 || d3 > 1.0) {
            return null;
        }
        Vec4 vec43 = line.getPointAt(d3);
        if (d > 0.0) {
            return new Vec4[]{vec43, vec42};
        }
        return new Vec4[]{vec4, vec43};
    }

    public double distanceTo(Vec4 vec4) {
        return this.n.dot4(vec4);
    }

    public int onSameSide(Vec4 vec4, Vec4 vec42) {
        double d = this.distanceTo(vec4);
        double d2 = this.distanceTo(vec42);
        if (d < 0.0 && d2 < 0.0) {
            return -1;
        }
        if (d > 0.0 && d2 > 0.0) {
            return 1;
        }
        return 0;
    }

    public int onSameSide(Vec4[] vec4Array) {
        int n;
        double d = this.distanceTo(vec4Array[0]);
        int n2 = d < 0.0 ? -1 : (n = d > 0.0 ? 1 : 0);
        if (n == 0) {
            return 0;
        }
        for (int i = 1; i < vec4Array.length; ++i) {
            d = this.distanceTo(vec4Array[i]);
            if (n == -1 && d < 0.0 || n == 1 && d > 0.0) continue;
            return 0;
        }
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Plane plane = (Plane)object;
        return this.n.normalize3().equals(plane.n.normalize3());
    }

    public final int hashCode() {
        return this.n.hashCode();
    }

    public final String toString() {
        return this.n.toString();
    }
}

