/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.nitfs.NITFSImageSegment;
import gov.nasa.worldwind.formats.nitfs.NITFSRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NITFSSegmentType;
import gov.nasa.worldwind.formats.nitfs.UserDefinedImageSubheader;
import gov.nasa.worldwind.formats.rpf.RPFFile;
import gov.nasa.worldwind.formats.rpf.RPFFrameFileComponents;
import gov.nasa.worldwind.formats.rpf.RPFImageType;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

public class RPFImageFile
extends RPFFile {
    private NITFSImageSegment imageSegment = (NITFSImageSegment)this.getNITFSSegment(NITFSSegmentType.IMAGE_SEGMENT);
    private UserDefinedImageSubheader imageSubheader = null;
    private RPFFrameFileComponents rpfFrameFileComponents = null;

    public RPFFrameFileComponents getRPFFrameFileComponents() {
        return this.rpfFrameFileComponents;
    }

    public UserDefinedImageSubheader getImageSubheader() {
        return this.imageSubheader;
    }

    public NITFSImageSegment getImageSegment() {
        return this.imageSegment;
    }

    private RPFImageFile(File file) throws IOException, NITFSRuntimeException {
        super(file);
        this.validateRPFImage();
        this.imageSubheader = this.imageSegment.getUserDefinedImageSubheader();
        this.rpfFrameFileComponents = this.imageSubheader.getRPFFrameFileComponents();
    }

    private void validateRPFImage() throws NITFSRuntimeException {
        if (null == this.imageSegment) {
            throw new NITFSRuntimeException("NITFSReader.ImageSegmentWasNotFound");
        }
        if (null == this.imageSegment.getUserDefinedImageSubheader()) {
            throw new NITFSRuntimeException("NITFSReader.UserDefinedImageSubheaderWasNotFound");
        }
        if (null == this.imageSegment.getUserDefinedImageSubheader().getRPFFrameFileComponents()) {
            throw new NITFSRuntimeException("NITFSReader.RPFFrameFileComponentsWereNotFoundInUserDefinedImageSubheader");
        }
    }

    public int[] getImagePixelsAsArray(int[] nArray, RPFImageType rPFImageType) {
        this.getImageSegment().getImagePixelsAsArray(nArray, rPFImageType);
        return nArray;
    }

    public ByteBuffer getImageAsDdsTexture() {
        if (null != this.imageSegment) {
            return this.imageSegment.getImageAsDdsTexture();
        }
        return null;
    }

    public BufferedImage getBufferedImage() {
        if (null == this.imageSegment) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(this.getImageSegment().numSignificantCols, this.getImageSegment().numSignificantRows, 2);
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        this.getImageSegment().getImagePixelsAsArray(nArray, RPFImageType.IMAGE_TYPE_ALPHA_RGB);
        return bufferedImage;
    }

    public boolean hasTransparentAreas() {
        if (null != this.imageSegment) {
            return this.imageSegment.hasTransparentPixels() || this.imageSegment.hasMaskedSubframes();
        }
        return false;
    }

    public static RPFImageFile load(File file) throws IOException, NITFSRuntimeException {
        return new RPFImageFile(file);
    }
}

