/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.nitfs;

import gov.nasa.worldwind.formats.nitfs.NITFSDataExtensionSegment;
import gov.nasa.worldwind.formats.nitfs.NITFSExtendedHeaderSegment;
import gov.nasa.worldwind.formats.nitfs.NITFSFileHeader;
import gov.nasa.worldwind.formats.nitfs.NITFSImageSegment;
import gov.nasa.worldwind.formats.nitfs.NITFSLabelSegment;
import gov.nasa.worldwind.formats.nitfs.NITFSReservedExtensionSegment;
import gov.nasa.worldwind.formats.nitfs.NITFSRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NITFSSegment;
import gov.nasa.worldwind.formats.nitfs.NITFSSegmentType;
import gov.nasa.worldwind.formats.nitfs.NITFSSymbolSegment;
import gov.nasa.worldwind.formats.nitfs.NITFSTextSegment;
import gov.nasa.worldwind.formats.nitfs.NITFSUtil;
import gov.nasa.worldwind.formats.rpf.RPFUserDefinedHeaderSegment;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class NITFSMessage {
    private ByteBuffer buffer;
    private NITFSFileHeader fileHeader;
    private ArrayList<NITFSSegment> segments = new ArrayList();

    public NITFSSegment getSegment(NITFSSegmentType nITFSSegmentType) {
        for (NITFSSegment nITFSSegment : this.segments) {
            if (null == nITFSSegment || !nITFSSegment.segmentType.equals((Object)nITFSSegmentType)) continue;
            return nITFSSegment;
        }
        return null;
    }

    public NITFSFileHeader getNITFSFileHeader() {
        return this.fileHeader;
    }

    private NITFSMessage(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
        this.fileHeader = new NITFSFileHeader(byteBuffer);
        this.readSegments();
    }

    private void readSegments() {
        int n = this.buffer.position();
        int n2 = this.fileHeader.getHeaderLength();
        n2 = this.parseSegment(NITFSSegmentType.IMAGE_SEGMENT, n2);
        n2 = this.parseSegment(NITFSSegmentType.SYMBOL_SEGMENT, n2);
        n2 = this.parseSegment(NITFSSegmentType.LABEL_SEGMENT, n2);
        n2 = this.parseSegment(NITFSSegmentType.TEXT_SEGMENT, n2);
        n2 = this.parseSegment(NITFSSegmentType.DATA_EXTENSION_SEGMENT, n2);
        n2 = this.parseSegment(NITFSSegmentType.RESERVED_EXTENSION_SEGMENT, n2);
        RPFUserDefinedHeaderSegment rPFUserDefinedHeaderSegment = new RPFUserDefinedHeaderSegment(this.buffer);
        this.segments.add(rPFUserDefinedHeaderSegment);
        n2 += rPFUserDefinedHeaderSegment.headerLength + rPFUserDefinedHeaderSegment.dataLength;
        n2 = this.parseSegment(NITFSSegmentType.EXTENDED_HEADER_SEGMENT, n2);
        for (NITFSSegment nITFSSegment : this.segments) {
        }
    }

    private int parseSegment(NITFSSegmentType nITFSSegmentType, int n) {
        int n2 = nITFSSegmentType.getHeaderLengthSize();
        int n3 = nITFSSegmentType.getDataLengthSize();
        int n4 = Integer.parseInt(NITFSUtil.getString(this.buffer, 3));
        for (int i = 0; i < n4; ++i) {
            NITFSSegment nITFSSegment;
            int n5 = Integer.parseInt(NITFSUtil.getString(this.buffer, n2));
            int n6 = Integer.parseInt(NITFSUtil.getString(this.buffer, n3));
            int n7 = this.buffer.position();
            switch (nITFSSegmentType) {
                case IMAGE_SEGMENT: {
                    nITFSSegment = new NITFSImageSegment(this.buffer, n, n5, n + n5, n6);
                    break;
                }
                case SYMBOL_SEGMENT: {
                    nITFSSegment = new NITFSSymbolSegment(this.buffer, n, n5, n + n5, n6);
                    break;
                }
                case LABEL_SEGMENT: {
                    nITFSSegment = new NITFSLabelSegment(this.buffer, n, n5, n + n5, n6);
                    break;
                }
                case TEXT_SEGMENT: {
                    nITFSSegment = new NITFSTextSegment(this.buffer, n, n5, n + n5, n6);
                    break;
                }
                case DATA_EXTENSION_SEGMENT: {
                    nITFSSegment = new NITFSDataExtensionSegment(this.buffer, n, n5, n + n5, n6);
                    break;
                }
                case RESERVED_EXTENSION_SEGMENT: {
                    nITFSSegment = new NITFSReservedExtensionSegment(this.buffer, n, n5, n + n5, n6);
                    break;
                }
                case USER_DEFINED_HEADER_SEGMENT: {
                    nITFSSegment = new RPFUserDefinedHeaderSegment(this.buffer);
                    break;
                }
                case EXTENDED_HEADER_SEGMENT: {
                    nITFSSegment = new NITFSExtendedHeaderSegment(this.buffer, n, n5, n + n5, n6);
                    break;
                }
                default: {
                    throw new NITFSRuntimeException("NITFSReader.UnknownOrUnsupportedSegment", nITFSSegmentType.toString());
                }
            }
            this.segments.add(nITFSSegment);
            n += n5 + n6;
            this.buffer.position(n7);
        }
        return n;
    }

    public static NITFSMessage load(File file) throws IOException {
        NITFSMessage.validateImageFile(file);
        ByteBuffer byteBuffer = NITFSUtil.readEntireFile(file).asReadOnlyBuffer();
        String string = NITFSUtil.getString(byteBuffer, 0, 4);
        if (0 != "NITF".compareTo(string) && 0 != "NSIF".compareTo(string)) {
            byteBuffer = null;
            throw new NITFSRuntimeException("NITFSReader.UnknownOrUnsupportedNITFSFormat", file.getCanonicalPath());
        }
        return new NITFSMessage(byteBuffer);
    }

    private static void validateImageFile(File file) throws IOException, IllegalArgumentException, NITFSRuntimeException {
        if (null == file) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists() || !file.canRead()) {
            throw new NITFSRuntimeException("NITFSReader.NoFileOrNoPermission", file.getCanonicalPath());
        }
    }
}

