/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.gpx;

import gov.nasa.worldwind.tracks.Track;
import gov.nasa.worldwind.tracks.TrackPoint;
import gov.nasa.worldwind.tracks.TrackSegment;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class GpxWriter {
    private final Document doc;
    private final Result result;

    public GpxWriter(String string) throws IOException, ParserConfigurationException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.doc = documentBuilderFactory.newDocumentBuilder().newDocument();
        this.result = new StreamResult(new File(string));
        this.createGpxDocument(this.doc);
    }

    public GpxWriter(OutputStream outputStream) throws IOException, ParserConfigurationException {
        if (outputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.doc = documentBuilderFactory.newDocumentBuilder().newDocument();
        this.result = new StreamResult(outputStream);
        this.createGpxDocument(this.doc);
    }

    public void writeTrack(Track track) throws TransformerException {
        if (track == null) {
            String string = Logging.getMessage("nullValue.TrackIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.doWriteTrack(track, this.doc.getDocumentElement());
        this.doFlush();
    }

    public void close() {
    }

    private void createGpxDocument(Document document) {
        if (document != null) {
            if (document.getDocumentElement() != null) {
                document.removeChild(document.getDocumentElement());
            }
            document.setXmlStandalone(false);
            Element element = document.createElement("gpx");
            element.setAttribute("version", "1.1");
            element.setAttribute("creator", "NASA World Wind");
            document.appendChild(element);
        }
    }

    private void doWriteTrack(Track track, Element element) {
        if (track != null) {
            Element element2 = this.doc.createElement("trk");
            if (track.getName() != null) {
                Element element3 = this.doc.createElement("name");
                Text object = this.doc.createTextNode(track.getName());
                element3.appendChild(object);
                element2.appendChild(element3);
            }
            if (track.getSegments() != null) {
                for (TrackSegment trackSegment : track.getSegments()) {
                    this.doWriteTrackSegment(trackSegment, element2);
                }
            }
            element.appendChild(element2);
        }
    }

    private void doWriteTrackSegment(TrackSegment trackSegment, Element element) {
        if (trackSegment != null) {
            Element element2 = this.doc.createElement("trkseg");
            if (trackSegment.getPoints() != null) {
                for (TrackPoint trackPoint : trackSegment.getPoints()) {
                    this.doWriteTrackPoint(trackPoint, element2);
                }
            }
            element.appendChild(element2);
        }
    }

    private void doWriteTrackPoint(TrackPoint trackPoint, Element element) {
        if (trackPoint != null) {
            Element element2 = this.doc.createElement("trkpt");
            element2.setAttribute("lat", Double.toString(trackPoint.getLatitude()));
            element2.setAttribute("lon", Double.toString(trackPoint.getLongitude()));
            Element element3 = this.doc.createElement("ele");
            Text text = this.doc.createTextNode(Double.toString(trackPoint.getElevation()));
            element3.appendChild(text);
            element2.appendChild(element3);
            if (trackPoint.getTime() != null) {
                Element element4 = this.doc.createElement("time");
                Text text2 = this.doc.createTextNode(trackPoint.getTime());
                element4.appendChild(text2);
                element2.appendChild(element4);
            }
            element.appendChild(element2);
        }
    }

    private void doFlush() throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource dOMSource = new DOMSource(this.doc);
        transformer.transform(dOMSource, this.result);
    }
}

