/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.gpx;

import gov.nasa.worldwind.formats.gpx.ElementParser;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.tracks.TrackPoint;
import gov.nasa.worldwind.util.Logging;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GpxTrackPoint
extends ElementParser
implements TrackPoint {
    private double latitude;
    private double longitude;
    private double elevation;
    private String time;

    public GpxTrackPoint(String string, String string2, String string3, Attributes attributes) {
        super("trkpt");
        if (attributes == null) {
            String string4 = Logging.getMessage("nullValue.org.xml.sax.AttributesIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string5 = attributes.getLocalName(i);
            String string6 = attributes.getValue(i);
            if (string5.equalsIgnoreCase("lat")) {
                this.latitude = Double.parseDouble(string6);
                continue;
            }
            if (!string5.equalsIgnoreCase("lon")) continue;
            this.longitude = Double.parseDouble(string6);
        }
    }

    public void doStartElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
    }

    public void doEndElement(String string, String string2, String string3) throws SAXException {
        if (string2 == null) {
            String string4 = Logging.getMessage("nullValue.LNameIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string2.equalsIgnoreCase("ele")) {
            this.elevation = Double.parseDouble(this.currentCharacters);
        } else if (string2.equalsIgnoreCase("time")) {
            this.time = this.currentCharacters.trim();
        }
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double d) {
        if (d > 90.0 || d < -90.0) {
            String string = Logging.getMessage("generic.AngleOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.latitude = d;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double d) {
        if (d > 180.0 || d < -180.0) {
            String string = Logging.getMessage("generic.AngleOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.longitude = d;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double d) {
        this.elevation = d;
    }

    public Position getPosition() {
        return Position.fromDegrees(this.latitude, this.longitude, this.elevation);
    }

    public void setPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.latitude = position.getLatitude().getDegrees();
        this.longitude = position.getLongitude().getDegrees();
        this.elevation = position.getElevation();
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.TimeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.time = string;
    }

    public String toString() {
        return String.format("(%10.6f\u00b0, %11.6f\u00b0, %10.4g m, %s)", this.latitude, this.longitude, this.elevation, this.time);
    }
}

