/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.gpx;

import gov.nasa.worldwind.formats.gpx.ElementParser;
import gov.nasa.worldwind.formats.gpx.GpxTrack;
import gov.nasa.worldwind.tracks.Track;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GpxReader {
    private SAXParser parser;
    private List<Track> tracks = new ArrayList<Track>();

    public GpxReader() throws ParserConfigurationException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        this.parser = sAXParserFactory.newSAXParser();
    }

    public void readFile(String string) throws IOException, SAXException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = Logging.getMessage("generic.FileNotFound", string);
            Logging.logger().severe(string3);
            throw new FileNotFoundException(string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.doRead(fileInputStream);
    }

    public void readStream(InputStream inputStream) throws IOException, SAXException {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.doRead(inputStream);
    }

    public List<Track> getTracks() {
        return this.tracks;
    }

    private void doRead(InputStream inputStream) throws IOException, SAXException {
        this.parser.parse(inputStream, (DefaultHandler)new Handler());
    }

    private class Handler
    extends DefaultHandler {
        private ElementParser currentElement = null;
        private boolean firstElement = true;

        private Handler() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            sAXParseException.printStackTrace();
            super.warning(sAXParseException);
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            sAXParseException.printStackTrace();
            super.error(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            sAXParseException.printStackTrace();
            super.fatalError(sAXParseException);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.firstElement) {
                if (!string2.equalsIgnoreCase("gpx")) {
                    throw new IllegalArgumentException("Not a GPX file");
                }
                this.firstElement = false;
            }
            if (this.currentElement != null) {
                this.currentElement.startElement(string, string2, string3, attributes);
            } else if (string2.equalsIgnoreCase("trk")) {
                GpxTrack gpxTrack = new GpxTrack(string, string2, string3, attributes);
                this.currentElement = gpxTrack;
                GpxReader.this.tracks.add(gpxTrack);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.currentElement != null) {
                this.currentElement.endElement(string, string2, string3);
                if (string2.equalsIgnoreCase(this.currentElement.getElementName())) {
                    this.currentElement = null;
                }
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.currentElement != null) {
                this.currentElement.characters(cArray, n, n2);
            }
        }
    }
}

